"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const codebuild_generated_1 = require("./codebuild.generated");
const report_group_utils_1 = require("./report-group-utils");
class ReportGroupBase extends cdk.Resource {
    grantWrite(identity) {
        const ret = iam.Grant.addToPrincipal({
            grantee: identity,
            actions: [
                'codebuild:CreateReport',
                'codebuild:UpdateReport',
                'codebuild:BatchPutTestCases',
            ],
            resourceArns: [this.reportGroupArn],
        });
        if (this.exportBucket) {
            this.exportBucket.grantWrite(identity);
        }
        return ret;
    }
}
/**
 * The ReportGroup resource class.
 */
class ReportGroup extends ReportGroupBase {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id, {
            physicalName: props.reportGroupName,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_codebuild_ReportGroupProps(props);
        const resource = new codebuild_generated_1.CfnReportGroup(this, 'Resource', {
            type: 'TEST',
            exportConfig: {
                exportConfigType: props.exportBucket ? 'S3' : 'NO_EXPORT',
                s3Destination: props.exportBucket
                    ? {
                        bucket: props.exportBucket.bucketName,
                        encryptionDisabled: props.exportBucket.encryptionKey ? false : undefined,
                        encryptionKey: (_b = props.exportBucket.encryptionKey) === null || _b === void 0 ? void 0 : _b.keyArn,
                        packaging: props.zipExport ? 'ZIP' : undefined,
                    }
                    : undefined,
            },
            name: props.reportGroupName,
        });
        resource.applyRemovalPolicy(props.removalPolicy, {
            default: cdk.RemovalPolicy.RETAIN,
        });
        this.reportGroupArn = this.getResourceArnAttribute(resource.attrArn, report_group_utils_1.reportGroupArnComponents(this.physicalName));
        this.reportGroupName = this.getResourceNameAttribute(
        // there is no separate name attribute,
        // so use Fn::Select + Fn::Split to make one
        cdk.Fn.select(1, cdk.Fn.split('/', resource.ref)));
        this.exportBucket = props.exportBucket;
    }
    /**
     * Reference an existing ReportGroup,
     * defined outside of the CDK code,
     * by name.
     */
    static fromReportGroupName(scope, id, reportGroupName) {
        class Import extends ReportGroupBase {
            constructor() {
                super(...arguments);
                this.reportGroupName = reportGroupName;
                this.reportGroupArn = report_group_utils_1.renderReportGroupArn(scope, reportGroupName);
                this.exportBucket = undefined;
            }
        }
        return new Import(scope, id);
    }
}
exports.ReportGroup = ReportGroup;
_a = JSII_RTTI_SYMBOL_1;
ReportGroup[_a] = { fqn: "@aws-cdk/aws-codebuild.ReportGroup", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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