"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = exports.LocalCacheMode = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
/**
 * Local cache modes to enable for the CodeBuild Project
 */
var LocalCacheMode;
(function (LocalCacheMode) {
    /**
     * Caches Git metadata for primary and secondary sources
     */
    LocalCacheMode["SOURCE"] = "LOCAL_SOURCE_CACHE";
    /**
     * Caches existing Docker layers
     */
    LocalCacheMode["DOCKER_LAYER"] = "LOCAL_DOCKER_LAYER_CACHE";
    /**
     * Caches directories you specify in the buildspec file
     */
    LocalCacheMode["CUSTOM"] = "LOCAL_CUSTOM_CACHE";
})(LocalCacheMode = exports.LocalCacheMode || (exports.LocalCacheMode = {}));
/**
 * Cache options for CodeBuild Project.
 * A cache can store reusable pieces of your build environment and use them across multiple builds.
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-caching.html
 */
class Cache {
    static none() {
        return {
            _toCloudFormation() {
                return { type: 'NO_CACHE' };
            },
            _bind() {
            },
        };
    }
    /**
     * Create a local caching strategy.
     * @param modes the mode(s) to enable for local caching
     */
    static local(...modes) {
        jsiiDeprecationWarnings._aws_cdk_aws_codebuild_LocalCacheMode(modes);
        return {
            _toCloudFormation: () => ({
                type: 'LOCAL',
                modes,
            }),
            _bind: () => { return; },
        };
    }
    /**
     * Create an S3 caching strategy.
     * @param bucket the S3 bucket to use for caching
     * @param options additional options to pass to the S3 caching
     */
    static bucket(bucket, options) {
        jsiiDeprecationWarnings._aws_cdk_aws_codebuild_BucketCacheOptions(options);
        return {
            _toCloudFormation: () => ({
                type: 'S3',
                location: core_1.Fn.join('/', [bucket.bucketName, options && options.prefix || core_1.Aws.NO_VALUE]),
            }),
            _bind: (project) => {
                bucket.grantReadWrite(project);
            },
        };
    }
}
exports.Cache = Cache;
_a = JSII_RTTI_SYMBOL_1;
Cache[_a] = { fqn: "@aws-cdk/aws-codebuild.Cache", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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