# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['discogs_alert']

package_data = \
{'': ['*']}

install_requires = \
['bs4==0.0.1',
 'click==7.1.2',
 'fake-useragent==0.1.11',
 'python-dotenv==0.15.0',
 'requests==2.25.1',
 'schedule==0.6.0',
 'selenium==3.141.0']

setup_kwargs = {
    'name': 'discogs-alert',
    'version': '0.0.4',
    'description': 'Configurable, real-time alerts for your discogs wantlist',
    'long_description': '# Discogs Alert\n\n<p align="center">\n    <a href="https://github.com/michaelhball/discogs_alert/blob/main/LICENSE">\n        <img alt="GitHub" src="https://img.shields.io/badge/license-GPL%203.0-blue">\n    </a>\n    <a href="https://github.com/michaelhball/discogs_alert/releases">\n        <img alt="GitHub release" src="https://img.shields.io/github/v/release/michaelhball/discogs_alert?sort=semver">\n    </a>\n</p>\n\n<h3 align="center">\n<p>Customised, real-time alerting for your hard-to-find wantlist items.\n</h3>\n\n![vinyl icon](https://github.com/michaelhball/discogs_alert/blob/main/img/vinyl.png) \ndiscogs-alert enables you to set up ~real-time alerts so you get notified the moment those \nhard-to-find releases go on sale. The project is designed to be \'set and forget\'; you customise your preferences for a \nparticular release once, and then sit back and wait for a notification. \n\n![vinyl icon](https://github.com/michaelhball/discogs_alert/blob/main/img/vinyl.png) \ndiscogs-alert enables both global and fine-grained customisation of your preferences\n(incl. price thresholds, minimum seller rating, and minimum media/sleeve condition). This \nmeans you\'ll only be notified if a record goes on sale that really matches what you\'re looking \nfor.\n\n## Requirements\n\n- Python >= 3.6\n- [Chromedriver](https://chromedriver.chromium.org/) (if you have Google Chrome or any Chromium browser \ninstalled on your computer, you\'ll be fine).\n\n## Installation & Setup\n\nYou can install discogs-alert either via the Python Package Index (PyPI) or from source.\nTo install using `pip`:\n```\npip install discogs-alert\n```\n\n### Downloading and installing from source \nDownload the latest version of discogs-alert from PyPI:\n\n[https://pypi.org/project/discogs-alert/](https://pypi.org/project/discogs-alert/)\n\nYou can then  install it by doing the following:\n```\n$ tar xvfz discogs_alert-0.0.0.tar.gz\n$ cd discogs_alert-0.0.0\n$ python setup.by build\n$ python setup.py install \n```\nThe last command must be executed as a privileged user if you aren\'t currently using a virtualenv.\n\n## Setup\n\nBefore you can use this project, there are a couple more things that need to be setup.\n\n### Discogs access token\n\nA Discogs access token allows discogs_alert to send requests to the discogs API on your behalf, as well as to\nincrease its allowed rate of request. This token can only be used to access the music database features of \nthe Discogs API, not the marketplace, so there is no concern that you are accidentally granting control over \nthe buying or selling of records. You can find more information \n[here](https://www.discogs.com/developers/#page:authentication).\n\nTo create an access token, go to your Discogs settings and click on the \n[Developer](https://www.discogs.com/settings/developers) tab. There is a button on this page to generate a \nnew token. For now, just copy this token to your computer.\n\n### Pushbullet\n\nThis project uses Pushbullet for notifying you once a record you are searching for has gone on sale. You can \nchoose exactly how you want to receive these notifications (i.e. on which device), but you first need to \ncreate a [Pushbullet](https://www.pushbullet.com/) account. After signing up, make sure to install Pushbullet \non all devices where you would like to receive notifications.\n\nOnce you\'ve created an account, simply navigate to your [settings](https://www.pushbullet.com/#settings) page and \ncreate an access token. As before, copy this token to your computer.\n\n### Creating your wantlist\n\nThere are two different ways you can create your wantlist (file containing all records you want to \nset up notifications for) 1) by connecting to one of your Discogs lists, or 2) by creating a local \nJSON file. The former is simpler, and requires no extra effort on your part, while the latter allows\nmore expressivity, as you can specify fine-grained preferences for each release.\n\n#### Discogs List\n\nUsing one of your existing Discogs [lists]() requires only specifying the ID of the list at runtime \n(outlined in the [usage](#usage) section below). As of now, there is no fine-grained control allowed with \nthis option, meaning the list you use should be one containing only those records about which you want to \nbe notified immediately if they go on sale. \n\n#### Local JSON   \n\nHere is an example `wantlist.json` file:\n```yaml\n[\n  {\n    "id": 1061046,\n    "artist_name": "Deep²",    \n    "release_name": "Sphere",\n    "accept_generic_sleeve": true,\n    "min_media_condition": "VG"\n  },\n  {\n    "id": 2247646,\n    "artist_name": "Charanjit Singh",\n    "release_name": "Ten Ragas to a Disco Beat",\n    "price_threshold": 500 \n  }\n]\n```\nThe wantlist is a list of objects, each object representing one release. The only essential \nattribute is the `id` field (which can be found on each release\'s Discogs page), while `artist_name` and `release_name` \nare used only to format the notifications you receive.\n\nThere are a number of extra attributes that can be optionally included for each release. The combination of all \nattributes applied to a given release are used as a filter, so you will only be notified if all conditions \nare met for a given listing item. In the above case, the user is looking for any `VG` or higher \ncopies of the `Deep²` release, with no maximum price (implying that there are currently none for sale, and the \nuser wants to be notified when one is). For the `Charanjit Singh` release, they are looking for any copies\non sale for less than `€500`. What a bargain.\n\nNote that all attributes relating to media and sleeve characteristics also have global values (the setting \nof which will be outlined below). This means that, if you mostly want the same conditions for all records\nyou\'re searching for, you _do not_ need to specify those in every release within your `wantlist.json` file. \nYou can set these values once, globally, and then you set values for specific releases inside your `wantlist.json`\nonly if they differ from your global settings. The values given for a specific release in your \n`wantlist.json` will override your global values.\n\nThe possible optional attributes are as follows:\n* `price_threshold`: maximum allowable price (excluding shipping)\n* `min_media_condition`: minimum allowable media condition (one of `\'P\'`, `\'F\'`, `\'G\'`, `\'G+\'`, `\'VG\'`, `\'VG+\'`\n, `\'NM\'`, or `\'M\'`)\n* `min_sleeve_condition`: minimum allowable sleeve condition (one of `\'P\'`, `\'F\'`, `\'G\'`, `\'G+\'`, `\'VG\'`, `\'VG+\'`\n, `\'NM\'`, or `\'M\'`)\n* `accept_generic_sleeve`: boolean indicating whether you want to accept a generic sleeve\n* `accept_no_sleeve`: boolean indicating whether you want to accept no sleeve\n* `accept_ungraded_sleeve`: boolean indicating whether you want to accept an ungraded sleeve\n\n## Usage\n\nAs of now, discogs_alert can only be run as a python process. The minimal command required to run the \ndiscogs_alert service is\n\n```\n$ python -m discogs_alert -dt <discogs_access_token> -pt <pushbullet_token> --list-id 12345678\n```\n\nwhere the two _required_ arguments are the values of the two tokens you created earlier, and --list-id \nspecifies the ID of your discogs list. This command starts the discogs_alert service, after which it \nregularly pulls the releases from your list, checks their availability on the Discogs marketplace, and \nsends you a notification if any release has gone on sale matching your conditions. You should leave \nthe service running in the background at all times to be most effective. Please note that you can add to \nor change the contents of your wantlist while the service is running. The new list of releases will \ncome into effect the next time the service runs (i.e. within the next minute).\n\nAs an alternative to using a Discogs list id, you can specify the path to a local \n```wantlist.json``` file (explained below). The service works exactly the same in this case, except \nthat it pulls releases to look for from that file rather than from a Discogs list. It is required that you \nuse exactly one of these two options.\n\nEach time one of your wanted releases is found, your Pushbullet account will be sent a notification \nwith the artist and release name, and a URL to the marketplace listing. As long as you \ndon\'t delete the push, you will _not_ be sent repeat notifications for the same listing. \nYou should test that the notification system is working correctly by putting a release in your\n`wantlist.json` that you know is currently for sale. \n\nIf you want further customisation, there are a number of optional arguments and flags with which \nthe service can be run. These optional arguments include the global versions of the conditions \nmentioned above (i.e. the global seller, media, and sleeve conditions) that will be applied to all \nreleases in your wantlist by default.\n\nFor any of the following arguments, you can use either the abbreviated argument indicator \n(prefixed with `-`) or the verbose option (prefixed with `--`). The complete list of options, \nincluding options and default values, can be accessed at any time by running:\n \n```\n$ python -m discogs_alert --help\n```\n\nHere are the possible arguments:\n \n* `-dt` `--discogs-token`: (str) your discogs user access token\n* `-pt` `--pushbullet-token`: (str) your pushbullet token\n* `-lid` `--list-id`: (int) the ID of your Discogs list (NB: either this or the ```-wp``` option are required). \n*  `-wp` `--wantlist-path`: (Path) the relative or absolute path to your `wantlist.json` file \n(NB: either this or the ```-lid``` option are required)\n* `-f` `--frequency`: (int) how often you want the service to run (number of times per hour). \nThis value must be in [1, 60]  (default=`60`, meaning the service runs once a minute)\n* `-co` `--country`: (str) the country where you are (used for things like computing shipping) \n(default=`\'Germany\'`)\n* `-$` `--currency`: (str) your preferred currency (default=`EUR`)\n* `-msr` `--min-seller-rating`: (float) the minimum seller rating you want to accept \n(default=`95`)\n* `-mss` `--min-seller-sales`: (float) the minimum number of sales your accept a seller to have \n(default=`None`)\n* `-mmc` `--min-media-condition`: (str) minimum allowable media condition, as outlined above \n(default=`\'VG+\'`)\n* `-msc` `--min-sleeve-condition`: (str) minimum allowable sleeve condition, as outlined above \n(default=`\'VG+\'`)\n\nAnd here are the possible flags:\n* `-ags`, `--accept-generic-sleeve`: (bool) whether or not you want to accept listings with a \ngeneric sleeve (default=`false`)\n* `-ans`, `--accept-no-sleeve`: (bool) whether or not you want to accept listings with \nno sleeve (default=`false`)\n* `-aus`, `--accept-ungraded-sleeve`: (bool) whether or not you want to accept listings with an\nungraded sleeve (default=`false`).\n* `-V` `--verbose`: (bool) use this flag if you want to run the server in verbose mode, meaning \nit will print updates to the command line as it runs (default=`false`) \n \n### Full Example\n\nTo clarify the CLI outlined above, here is a realistic example. In this case, we are replicating a user \nwho has their `wantlist.json` on their Desktop, and who wants verbose printouts from \nthe service, no minimum seller rating, and a global minimum media condition of `VG`. The \ncommand to run the service in this case would be\n \n```\n$ python -m discogs_alert -dt <discogs_access_token> -pt <pushbullet_token> -wp ~/Desktop/wantlist.json --msr None -mmc VG --verbose\n```\n\n### Running in the background\n\nSince this is a service that you\'ll want to leave running all t time, the best thing to \ndo is run it in the background. This way you don\'t need to leave the process active in your terminal. \nThe easiest way to do this (on Linux & Mac) is with the `nohup` command\n\n```\n$ nohup python -m discogs_alert -dt <discogs_access_token> -pt <pushbullet_token> &\n```\n\nAs can be seen, you need to put `nohup` before the python command and `&` after it. All console output \ngenerated by the service will be saved to a text file named `nohup.out`.\n\nWhen you run this command, it will return a PID (process ID). You will need this to stop the \nprocess in the future, which you can easily do by running `$ kill <PID>`. If you forget the \nPID, you can still terminate the service by running\n\n```\n$ kill $(ps aux | grep \'[p]ython -m discogs_alert\' | awk \'{print $2}\')\n```\n\n## Contributing\n\n1. Fork (https://github.com/michaelhball/discogs_alert/fork)\n2. Create your feature branch (git checkout -b feature/fooBar)\n3. Commit your changes (git commit -am \'Add some fooBar\')\n4. Push to the branch (git push origin feature/fooBar)\n5. Create a new Pull Request\n\n### Setting up the dev environment\n\nIdeally, you should work inside a virtual environment set up for this project. Once that\'s the case, \nsimply run the following two commands to install all dependencies:\n\n* `$ pip install --user poetry`\n* `$ poetry install` \n\nAnd that\'s it! Until you want to push your changes and make a PR. When that\'s the case, you need to run \nthe tests to make sure nothing has broken, which you can do by running `$ poetry pytest tests`. \n\n## Changelog\n\nThe complete release history for this project can be found in [CHANGELOG.md](CHANGELOG.md).\n\n## Author\n\n[**Michael Ball**](https://github.com/michaelhball)\n\n<a href="https://mhsb.me" rel="nofollow">\n<img alt="home icon" src="https://github.com/michaelhball/discogs_alert/blob/main/img/home.png"/>\n</a>\n\n## License\n\nThis project is licensed under the GPL License - see the [LICENSE](LICENSE) file for details\n\n## Housekeeping\n\n<div>vinyl icon made by <a href="https://www.flaticon.com/authors/those-icons" title="Those Icons">Those Icons</a> on <a href="https://www.flaticon.com/" title="Flaticon">www.flaticon.com</a></div>\n',
    'author': 'mhsb',
    'author_email': 'michael.h.s.ball@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/michaelhball/discogs_alert',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
