"use strict";
/**
 * Copyright (c) 2018 The xterm.js authors. All rights reserved.
 * @license MIT
 */
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", { value: true });
const font_ligatures_1 = require("font-ligatures");
const parse_1 = require("./parse");
let fontsPromise = undefined;
/**
 * Loads the font ligature wrapper for the specified font family if it could be
 * resolved, throwing if it is unable to find a suitable match.
 * @param fontFamily The CSS font family definition to resolve
 * @param cacheSize The size of the ligature cache to maintain if the font is resolved
 */
async function load(fontFamily, cacheSize) {
    var e_1, _a;
    var _b, _c;
    if (!fontsPromise) {
        // Web environment that supports font access API
        if (typeof navigator !== 'undefined' && 'fonts' in navigator) {
            try {
                const status = await ((_c = (_b = navigator.permissions).request) === null || _c === void 0 ? void 0 : _c.call(_b, {
                    name: 'local-fonts'
                }));
                if (status && status.state !== 'granted') {
                    throw new Error('Permission to access local fonts not granted.');
                }
            }
            catch (err) {
                // A `TypeError` indicates the 'local-fonts'
                // permission is not yet implemented, so
                // only `throw` if this is _not_ the problem.
                if (err.name !== 'TypeError') {
                    throw err;
                }
            }
            const fonts = {};
            try {
                const fontsIterator = navigator.fonts.query();
                try {
                    for (var fontsIterator_1 = __asyncValues(fontsIterator), fontsIterator_1_1; fontsIterator_1_1 = await fontsIterator_1.next(), !fontsIterator_1_1.done;) {
                        const metadata = fontsIterator_1_1.value;
                        if (!fonts.hasOwnProperty(metadata.family)) {
                            fonts[metadata.family] = [];
                        }
                        fonts[metadata.family].push(metadata);
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (fontsIterator_1_1 && !fontsIterator_1_1.done && (_a = fontsIterator_1.return)) await _a.call(fontsIterator_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                fontsPromise = Promise.resolve(fonts);
            }
            catch (err) {
                console.error(err.name, err.message);
            }
        }
        // Node environment or no font access API
        else {
            try {
                fontsPromise = (await Promise.resolve().then(() => require('font-finder'))).list();
            }
            catch (err) {
                // No-op
            }
        }
        if (!fontsPromise) {
            fontsPromise = Promise.resolve({});
        }
    }
    const fonts = await fontsPromise;
    for (const family of parse_1.default(fontFamily)) {
        // If we reach one of the generic font families, the font resolution
        // will end for the browser and we can't determine the specific font
        // used. Throw.
        if (genericFontFamilies.includes(family)) {
            return undefined;
        }
        if (fonts.hasOwnProperty(family) && fonts[family].length > 0) {
            const font = fonts[family][0];
            if ('blob' in font) {
                return font_ligatures_1.loadBuffer(await (await font.blob()).arrayBuffer(), { cacheSize });
            }
            return await font_ligatures_1.loadFile(font.path, { cacheSize });
        }
    }
    // If none of the fonts could resolve, throw an error
    return undefined;
}
exports.default = load;
// https://drafts.csswg.org/css-fonts-4/#generic-font-families
const genericFontFamilies = [
    'serif',
    'sans-serif',
    'cursive',
    'fantasy',
    'monospace',
    'system-ui',
    'emoji',
    'math',
    'fangsong'
];
//# sourceMappingURL=font.js.map