# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['lcdoc',
 'lcdoc.operations',
 'lcdoc.plugins.doc_lcdoc',
 'lcdoc.plugins.doc_lcdoc.arch',
 'lcdoc.py_test']

package_data = \
{'': ['*'],
 'lcdoc': ['assets/mkdocs/*',
           'assets/mkdocs/lcd/assets/*',
           'assets/mkdocs/lcd/assets/css/*',
           'assets/mkdocs/lcd/assets/javascript/*',
           'assets/mkdocs/lcd/assets/javascript/.git/*',
           'assets/mkdocs/lcd/assets/javascript/.git/hooks/*',
           'assets/mkdocs/lcd/assets/javascript/.git/info/*',
           'assets/mkdocs/lcd/assets/javascript/.git/objects/4b/*',
           'assets/mkdocs/lcd/assets/javascript/css/*',
           'assets/mkdocs/lcd/assets/javascript/fonts/*',
           'assets/mkdocs/lcd/assets/javascript/lib/jasmine-3.7.1/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/.bin/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/font-finder/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/font-finder/src/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/font-finder/src/tables/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/font-ligatures/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/font-ligatures/src/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/font-ligatures/src/processors/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/get-system-fonts/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/lru-cache/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/opentype.js/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/opentype.js/.github/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/opentype.js/bin/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/opentype.js/examples/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/opentype.js/externs/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/opentype.js/src/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/opentype.js/src/tables/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/opentype.js/test/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/opentype.js/test/tables/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/promise-stream-reader/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/tiny-inflate/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/tiny-inflate/test/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/xterm-addon-ligatures/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/xterm-addon-ligatures/bin/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/xterm-addon-ligatures/lib/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/xterm-addon-ligatures/out/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/xterm-addon-ligatures/src/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/xterm-addon-ligatures/typings/*',
           'assets/mkdocs/lcd/assets/javascript/node_modules/yallist/*',
           'assets/mkdocs/lcd/assets/javascript/spec/*',
           'assets/mkdocs/lcd/assets/javascript/src/*',
           'assets/mkdocs/lcd/assets/plantuml/*',
           'assets/mkdocs/lcd/partials/*',
           'assets/mkdocs/lcd/src/_snippets/*',
           'assets/mkdocs/lcd/src/md/keepachangelog/*']}

install_requires = \
['anybadge>=1.7.0,<2.0.0',
 'devapps>=2021.5.10,<2022.0.0',
 'git-changelog>=0.4.0,<0.5.0',
 'httpx>=0.17.1,<0.18.0',
 'markdown-include>=0.6.0,<0.7.0',
 'mkdocs-exclude>=1.0.2,<2.0.0',
 'mkdocs-material>=6.1.0,<7.0.0',
 'mkdocs-pymdownx-material-extras>=1.1.3,<2.0.0',
 'mkdocs>=1.1.2,<2.0.0',
 'mypy>=0.782,<0.783',
 'plantuml-markdown>=3.4.2,<4.0.0',
 'pytest-cov>=2.10.1,<3.0.0',
 'pytest-randomly>=3.4.1,<4.0.0',
 'pytest-sugar>=0.9.4,<0.10.0',
 'pytest-xdist>=2.1.0,<3.0.0',
 'pytest>=6.0.1,<7.0.0',
 'toml>=0.10.1,<0.11.0']

entry_points = \
{'console_scripts': ['doc = devapp.plugin_tools:main']}

setup_kwargs = {
    'name': 'docutools',
    'version': '2021.7.27',
    'description': 'Documentation Tools for the Devapp Framework',
    'long_description': '#  docutools\n\n<p attr="autogenerated by make_badges"></p>\n\n[![docs][img_docs]][lnk_docs]&nbsp; [![package][img_package]][lnk_package]&nbsp; [![discuss][img_discuss]][lnk_discuss]&nbsp; [![pipeline][img_pipeline]][lnk_pipeline]&nbsp; [![coverage][img_coverage]][lnk_coverage]&nbsp; [![statements][img_statements]][lnk_statements]&nbsp; [![code style][img_code style]][lnk_code style]\n\n[lnk_docs]: http://github.pages.com/docutools/\n[img_docs]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/documentation.svg\n[lnk_package]: https://artifacts.github.com/artifactory/pypi-ax-sources/docutools/2021.1.21.dev14+g13aab44.d20210418/docutools-2021.1.21.dev14+g13aab44.d20210418.tar.gz\n[img_package]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/pypi_package.svg\n[lnk_discuss]: https://join.skype.com/krSNYZqvEmJm\n[img_discuss]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/discuss.svg\n[lnk_pipeline]: https://axiros.github.com/devapps/docutools/-/commits/master\n[img_pipeline]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/pipeline.svg\n[lnk_coverage]: http://github.pages.com/docutools//coverage/index.html\n[img_coverage]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/coverage.svg\n[lnk_statements]: http://github.pages.com/docutools//coverage/index.html\n[img_statements]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/statements.svg\n[lnk_code style]: https://github.com/axiros/axblack\n[img_code style]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/code_style_ax_black.svg\n\n<p attr="autogenerated by make_badges"></p>\n\n## Documentation building tools\n\n!!! caution "Work in Progress"\n    The termcast feature is heavily W.I.P!\n\n\n![](img/page-teaser.png){: style="width:1550px" }\n\nThis library is meant to be used as a development dependency for projects which want [mkdocs/material](https://squidfunk.github.io/mkdocs-material/) based documentation,\npulling in all the necessary dependencies plus adding a few strong features as well, which were to hard / did not make sense to realize as mkdocs plugins.\n\n\n\n\n\n\n<!-- pre_proc_marker -->\n\n\n----\n\n\nLast modified: Tue Jul 27 16:17:56 2021',
    'author': 'Gunther Klessinger',
    'author_email': 'gunther.klessinger@axiros.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://axgkl.github.io/docutools/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
