
from .ixn_port import IxnPort
from .ixn_traffic import IxnTrafficItem
from .ixn_protocol import (IxnBgpRouter, IxnOspfRouter, IxnOspfV3Router, IxnBgpRouteRange, IxnOspfRouteRange,
                           IxnPimsmRouter, IxnIgmpHost, IxnIgmpQuerier, IxnPimsmSource, IxnStpBridge, IxnOpenFlowDevice,
                           IxnLacp, IxnIsisRouter, IxnIsisRouteRange, IxnLdpRouter, IxnLdpRouteRange,
                           IxnRsvpNeighborPair, IxnStaticIp, IxnBfdfRouter, IxnOspfv3RouteRange)
from .ixn_interface import IxnInterface, IxnInterfaceL3
from .ixn_topology import (IxnTopology, IxnNgpfEthernet, IxnNgpfVlan, IxnNgpfIpv4, IxnNgpfIpv6, IxnDeviceGroup,
                           IxnNetworkGroup)
from .ixn_root import IxnRoot, IxnQuickTest
from .ixn_protocol_stack import IxnRange
from .ixn_hw import IxnHw, IxnChassis, IxnCard, IxnPhyPort


TYPE_2_OBJECT = {'availableHardware': IxnHw,
                 'bridge': IxnStpBridge,
                 'card': IxnCard,
                 'chassis': IxnChassis,
                 'device': IxnOpenFlowDevice,
                 'deviceGroup': IxnDeviceGroup,
                 'ethernet': IxnNgpfEthernet,
                 'host': IxnIgmpHost,
                 'interface': {'vport': IxnInterface},
                 'ip': IxnStaticIp,
                 'ipv4': {'interface': IxnInterfaceL3,
                          'etherenet': IxnNgpfIpv4},
                 'ipv6': {'interface': IxnInterfaceL3,
                          'etherenet': IxnNgpfIpv6},
                 'lacp': IxnLacp,
                 'neighborPair': IxnRsvpNeighborPair,
                 'neighborRange': IxnBgpRouter,
                 'networkGroup': IxnNetworkGroup,
                 'port': IxnPhyPort,
                 'querier': IxnIgmpQuerier,
                 'quickTest': IxnQuickTest,
                 'range': IxnRange,
                 'router': {'bfd': IxnBfdfRouter,
                            'isis': IxnIsisRouter,
                            'ldp': IxnLdpRouter,
                            'ospf': IxnOspfRouter,
                            'ospfV3': IxnOspfV3Router,
                            'pimsm': IxnPimsmRouter},
                 'routeRange': {'bgp': IxnBgpRouteRange,
                                'ospf': IxnOspfRouteRange,
                                'ospfV3': IxnOspfv3RouteRange,
                                'isis': IxnIsisRouteRange,
                                'ldp': IxnLdpRouteRange},
                 'source': {'interface': IxnPimsmSource},
                 'topology': IxnTopology,
                 'trafficItem': IxnTrafficItem,
                 'vlan': IxnNgpfVlan,
                 'vport': IxnPort,

                 'asymmetricFrameLoss': IxnQuickTest,
                 'asymmetricThroughput': IxnQuickTest,
                 'cloudPerf': IxnQuickTest,
                 'customContDuration': IxnQuickTest,
                 'customFixedDuration': IxnQuickTest,
                 'customStep': IxnQuickTest,
                 'customThroughput': IxnQuickTest,
                 'dhcpRate': IxnQuickTest,
                 'dhcpRateCpf': IxnQuickTest,
                 'dhcpv6Rate': IxnQuickTest,
                 'dhcpv6RateCpf': IxnQuickTest,
                 'dot1xCapacity': IxnQuickTest,
                 'dot1xRate': IxnQuickTest,
                 'eventScheduler': IxnQuickTest,
                 'fcoeMaxNoDropThroughput': IxnQuickTest,
                 'fcoeMaxNoPauseThroughput': IxnQuickTest,
                 'iptvChannelZapping': IxnQuickTest,
                 'l2tpCapacity': IxnQuickTest,
                 'l2tpRate': IxnQuickTest,
                 'l2tpRateCpf': IxnQuickTest,
                 'lnsCpfCapacity': IxnQuickTest,
                 'openFlowFailoverPerformance': IxnQuickTest,
                 'openFlowLayer2LearningRate': IxnQuickTest,
                 'openFlowLayer3LearningRate': IxnQuickTest,
                 'openFlowTableCapacity': IxnQuickTest,
                 'pppoxRateCpf': IxnQuickTest,
                 'pppoxRateCpfServerCapacity': IxnQuickTest,
                 'pppServerCapacity': IxnQuickTest,
                 'pppSessionRate': IxnQuickTest,
                 'ptpBestMasterSelection': IxnQuickTest,
                 'ptpCorrectionFactorError': IxnQuickTest,
                 'ptpSlaveScalability': IxnQuickTest,
                 'rfc2544back2back': IxnQuickTest,
                 'rfc2544frameLoss': IxnQuickTest,
                 'rfc2544throughput': IxnQuickTest,
                 'rfc2889addressCache': IxnQuickTest,
                 'rfc2889addressRate': IxnQuickTest,
                 'rfc2889broadcastRate': IxnQuickTest,
                 'rfc2889congestionControl': IxnQuickTest,
                 'rfc2889frameErrorFiltering': IxnQuickTest,
                 'rfc2889fullyMeshed': IxnQuickTest,
                 'rfc2889manyToOne': IxnQuickTest,
                 'rfc2889oneToMany': IxnQuickTest,
                 'rfc2889partiallyMeshed': IxnQuickTest,
                 'rfc3918aggregated': IxnQuickTest,
                 'rfc3918burdenedJoinDelay': IxnQuickTest,
                 'rfc3918burdenedLatency': IxnQuickTest,
                 'rfc3918groupCapacity': IxnQuickTest,
                 'rfc3918groupPatternVerification': IxnQuickTest,
                 'rfc3918ipmcMinMaxLat': IxnQuickTest,
                 'rfc3918joinLeaveDelay': IxnQuickTest,
                 'rfc3918joinRate': IxnQuickTest,
                 'rfc3918mixedClassThroughput': IxnQuickTest,
                 'rfc3918scaleGroup': IxnQuickTest,
                 'rfc7747failover': IxnQuickTest,
                 'rfc7747ribIn': IxnQuickTest,
                 'trafficTest': IxnQuickTest,
                 'y1564': IxnQuickTest,
                 }
