import { Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { IFunction } from '@aws-cdk/aws-lambda';
import { RetentionDays } from '@aws-cdk/aws-logs';
import type { IBucket } from '@aws-cdk/aws-s3';
import { Construct, Duration } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
/**
 * Props for `VersionTracker`.
 */
export interface VersionTrackerProps {
    /**
     * The package store bucket.
     */
    readonly bucket: IBucket;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
    /**
     * How frequently should the list of available versions be updated?
     *
     * @default - 1 minute
     */
    readonly updatePeriod?: Duration;
}
/**
 * Periodically updates the `all-versions.json` object in the designated bucket
 * with the list of all ingested package versions.
 */
export declare class VersionTracker extends Construct {
    /**
     * The package store bucket.
     */
    readonly bucket: IBucket;
    /**
     * The Lambda function that periodically updates versions.json.
     */
    readonly handler: IFunction;
    constructor(scope: Construct, id: string, props: VersionTrackerProps);
    metricTrackedPackagesCount(opts?: MetricOptions): Metric;
    metricTrackedVersionsCount(opts?: MetricOptions): Metric;
}
