interface Event {
    readonly key: string;
    readonly description: string;
    readonly widgetContext: WidgetContext;
}
export declare function handler({ key, description, widgetContext }: Event): Promise<string | {
    markdown: string;
}>;
export interface WidgetContext {
    readonly dashboardName: string;
    readonly widgetId: string;
    readonly domain: string;
    readonly accountId: string;
    readonly locale: string;
    readonly timezone: {
        readonly label: string;
        readonly offsetISO: string;
        readonly offsetInMinutes: number;
    };
    readonly period: number;
    readonly isAutoPeriod: true;
    readonly timeRange: {
        readonly mode: 'relative' | 'absolute';
        readonly start: number;
        readonly end: number;
        readonly relativeStart: number;
        readonly zoom: {
            readonly start: number;
            readonly end: number;
        };
    };
    readonly theme: 'light' | 'dark';
    readonly linkCharts: boolean;
    readonly title: string;
    readonly forms: {
        readonly all: {
            readonly [key: string]: string;
        };
    };
    readonly params: {
        readonly [key: string]: string;
    };
    readonly width: number;
    readonly height: number;
}
export {};
