# Copyright 2021 DeepMind Technologies Limited
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Defines convenience constants/functions for converting various units."""

# pylint: disable=invalid-name
vCPU = 1.0  # Virtual CPU

KiB = 2**10  # kibibyte
MiB = 2**20  # mibibyte
GiB = 2**30  # gibibyte
TiB = 2**40  # tebibyte
PiB = 2**50  # pebibyte

KB = 10**3  # kilobyte
MB = 10**6  # megabyte
GB = 10**9  # gigabyte
TB = 10**12  # terabyte
PB = 10**15  # petabyte
# pylint: enable=invalid-name
