'''Global elements to include in HTML pages'''

#- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Copyright (C) 2007-2020 Gaetan Delannay

# This file is part of Appy.

# Appy is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.

# Appy is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.

# You should have received a copy of the GNU General Public License along with
# Appy. If not, see <http://www.gnu.org/licenses/>.

#- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
import base64
from appy.ui.js import Quote
from appy.ui.includer import Includer

#- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
class Iframe:
    '''Represents the unique Appy iframe popup'''

    view = '''
     <div id="iframePopup" class="popup"
          onmousedown="dragStart(event)" onmouseup="dragStop(event)"
          onmousemove="dragIt(event)"
          onmouseover="dragPropose(event)" onmouseout="dragStop(event)">
      <img align="%s" src="%s" class="clickable"
           onclick="closePopup('iframePopup',null,true)"/>
      <iframe id="appyIFrame" name="appyIFrame" frameborder="0"></iframe>
     </div>'''

    # HTML page to render for closing the popup
    back = "<html><head>%s</head><body><script>backFromPopup()</script>" \
           "</body></html>"

    @classmethod
    def goBack(class_, tool, initiator=None):
        '''Returns a HTML page allowing to close the iframe popup and refresh
           the base page.'''
        # The initiator may force to go back to some URL
        if initiator and initiator.backFromPopupUrl:
            close = base64.b64encode(initiator.backFromPopupUrl)
        else:
            close = 'yes'
        resp = tool.resp
        resp.setCookie('closePopup', close)
        # Include appy.js and call a Javascript function that will do the job
        return class_.back % Includer.js(tool.buildUrl('appy.js'))
#- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
