from . import auth, errors, methods, models
from .__version__ import __version__ as version
from .client import Client, EventSourceConfig
from .errors import Error
from .methods import Request, ResponseOrError
from .models import (
    AddedItem,
    Address,
    Comparator,
    Delivered,
    DeliveryStatus,
    Displayed,
    Email,
    EmailAddress,
    EmailBodyPart,
    EmailBodyValue,
    EmailHeader,
    EmailQueryFilter,
    EmailQueryFilterCondition,
    EmailQueryFilterOperator,
    EmailSubmission,
    EmailSubmissionQueryFilter,
    EmailSubmissionQueryFilterCondition,
    EmailSubmissionQueryFilterOperator,
    Envelope,
    Event,
    Identity,
    ListOrRef,
    Mailbox,
    MailboxQueryFilter,
    MailboxQueryFilterCondition,
    MailboxQueryFilterOperator,
    Operator,
    SetError,
    StateChange,
    StrOrRef,
    Thread,
    TypeState,
    UndoStatus,
)
from .ref import Ref, ResultReference

__all__ = [
    "AddedItem",
    "Address",
    "Client",
    "Comparator",
    "Delivered",
    "DeliveryStatus",
    "Displayed",
    "Email",
    "EmailAddress",
    "EmailBodyPart",
    "EmailBodyValue",
    "EmailHeader",
    "EmailQueryFilter",
    "EmailQueryFilterCondition",
    "EmailQueryFilterOperator",
    "EmailSubmission",
    "EmailSubmissionQueryFilter",
    "EmailSubmissionQueryFilterCondition",
    "EmailSubmissionQueryFilterOperator",
    "Envelope",
    "Error",
    "Event",
    "EventSourceConfig",
    "Identity",
    "ListOrRef",
    "Mailbox",
    "MailboxQueryFilter",
    "MailboxQueryFilterCondition",
    "MailboxQueryFilterOperator",
    "Operator",
    "Ref",
    "Request",
    "ResponseOrError",
    "ResultReference",
    "SetError",
    "StateChange",
    "StrOrRef",
    "Thread",
    "TypeState",
    "UndoStatus",
    "auth",
    "errors",
    "log",
    "methods",
    "models",
    "version",
]
