[![CI](https://github.com/fhswf/MLPro/actions/workflows/ci.yml/badge.svg)](https://github.com/fhswf/MLPro/actions/workflows/ci.yml)
[![Documentation Status](https://readthedocs.org/projects/mlpro/badge/?version=latest)](https://mlpro.readthedocs.io/en/latest/?badge=latest)
[![PyPI version](https://badge.fury.io/py/mlpro.svg)](https://badge.fury.io/py/mlpro)
[![Anaconda-Version Badge](https://anaconda.org/mlpro/mlpro/badges/version.svg)](https://anaconda.org/mlpro/mlpro)
[![Anaconda-Downloads Badge](https://img.shields.io/conda/dn/mlpro/mlpro?color=green&label=Anaconda.org%20Total%20downloads&style=flat-square)](https://anaconda.org/mlpro/mlpro)
[![PyPI Total Downloads](https://static.pepy.tech/personalized-badge/mlpro?period=total&units=international_system&left_color=blue&right_color=orange&left_text=PyPI%20Total%20Downloads)](https://pepy.tech/project/mlpro)
[![PyPI Last Month Downloads](https://static.pepy.tech/personalized-badge/mlpro?period=month&units=international_system&left_color=blue&right_color=orange&left_text=PyPI%20Last%20Month%20Downloads)](https://pepy.tech/project/mlpro)


<img src="https://github.com/fhswf/MLPro/blob/main/doc/logo/original/logo.png?raw=True" align="right" width="40%"/>

# MLPro - The Integrative Middleware Framework for Standardized Machine Learning in Python

MLPro provides complete, standardized, and reusable functionalities to support your scientific research, educational tasks or industrial projects in machine learning.

## Key Features

#### a) Open, modular and extensible architecture
- Overarching software infrastructure (mathematics, data management and plotting, UI framework, logging, ...)
- Fundamental ML classes for adaptive models and their training and hyperparameter tuning

#### b) MLPro-RL: Sub-Package for Reinforcement Learning
- Powerful Environment templates for simulation, training and real operation
- Templates for single-agents, model-based agents (MBRL) with action planning to multi-agents (MARL)
- Advanced training/tuning funktionalities with separate evaluation and progress detection
- Growing pool of reuseable environments of automation and robotics

#### c) MLPro-GT: Sub-Package for Cooperative Game Theory
- Templates for (potential based) game boards
- Templates for cooperative multi-players
- Reuse of advanced training/tuning classes and multi-agent environments of sub-package MLPro-RL

#### d) Numerous executable self study examples

#### e) Integration of established 3rd party packages
MLPro provides wrapper classes for:
- Environments of OpenAI Gym and PettingZoo
- Policy Algorithms of Stable Baselines 3
- Hyperparameter tuning with Hyperopt


## Documentation
The Documentation is available here: [https://mlpro.readthedocs.io/](https://mlpro.readthedocs.io/)


## Development
- Consequent object-oriented design and programming (OOD/OOP)
- Quality assurance by test-driven development
- Hosted and managed on GitHub
- Agile CI/CD approach with automated test and deployment
- Clean code paradigma


## Project and Team
Project MLPro was started in 2021 by the [Group for Automation Technology and Learning Systems at the South Westphalia University of Applied Sciences, Germany](https://www.fh-swf.de/de/forschung___transfer_4/labore_3/labs/labor_fuer_automatisierungstechnik__soest_1/standardseite_57.php).

MLPro is currently designed and developed by [Detlef Arend](https://github.com/detlefarend), [M Rizky Diprasetya](https://github.com/rizkydiprasetya), [Steve Yuwono](https://github.com/steveyuwono) and further [contributors](https://github.com/fhswf/MLPro/graphs/contributors). 


## How to contribute
If you want to contribute, please read [CONTRIBUTING.md](https://github.com/fhswf/MLPro/blob/master/CONTRIBUTING.md)
