"""





⚠️ This file was autogenerated
by scripts/inline_mixins.py ⚠️





"""

from copy import deepcopy

from fontTools.pens.recordingPen import RecordingPen
from fontTools.pens.reverseContourPen import ReverseContourPen
from coldtype.color import Color, normalize_color

from coldtype.geometry import Rect, Point, txt_to_edge
from coldtype.runon.runon import Runon

from coldtype.runon.scaffold import Scaffold

import math
from pathlib import Path
from fontTools.pens.recordingPen import RecordingPen
from coldtype.geometry import Rect, Line, Point, Atom
import math
from fontTools.pens.boundsPen import BoundsPen
from fontTools.misc.transform import Transform
from fontTools.pens.transformPen import TransformPen
from fontTools.pens.recordingPen import RecordingPen
from coldtype.geometry import Point, Rect, align
from coldtype.interpolation import norm
from coldtype.color import bw, rgb, hsl
THTV_WARNING = False
from coldtype.color import Color, normalize_color, rgb
from coldtype.geometry import Rect
from coldtype.img.blendmode import BlendMode
"""
Requires Runon.attr contract
"""
from fontTools.pens.recordingPen import RecordingPen
from fontTools.pens.transformPen import TransformPen
from fontTools.misc.transform import Transform
import pickle, json
from pathlib import Path
from fontTools.pens.recordingPen import RecordingPen
from coldtype.geometry import Rect
from coldtype.pens.misc import BooleanOp, calculate_pathop
import math
from fontPens.marginPen import MarginPen
from fontTools.misc.transform import Transform
from coldtype.geometry import Line
from coldtype.beziers import CurveCutter, CurveSample, splitCubicAtT, calcCubicArcLength
import struct, wave
from coldtype.geometry import Rect
from coldtype.geometry.point import Point
from coldtype.geometry.line import Line
import math
from copy import deepcopy
from random import randint
from fontTools.pens.basePen import decomposeQuadraticSegment
from fontTools.pens.recordingPen import RecordingPen
from fontPens.flattenPen import FlattenPen
from coldtype.geometry import Point
from coldtype.pens.outlinepen import OutlinePen
from coldtype.pens.translationpen import TranslationPen, polarCoord
from coldtype.pens.misc import ExplodingPen, SmoothPointsPen
from coldtype.random import random_series

class P(Runon):
    """
    P stands for Path (or Pen)
    """
    def FromPens(pens):
        if hasattr(pens, "_pens"):
            out = P().data(**pens.data)
            for p in pens:
                out.append(P.FromPens(p))
        elif hasattr(pens, "_els") and len(pens._els) > 0:
            out = pens
        elif hasattr(pens, "_val") and pens.val_present():
            out = pens
        else:
            p = pens
            rp = RecordingPen()
            p.replay(rp)
            out = P(rp)
            
            attrs = p.attrs.get("default", {})
            if "fill" in attrs:
                out.f(attrs["fill"])
            if "stroke" in attrs:
                out.s(attrs["stroke"]["color"])
                out.sw(attrs["stroke"]["weight"])

            # TODO also the rest of the styles

            out.data(**pens.data)

            if hasattr(pens, "_frame"):
                out.data(frame=pens._frame)
            if hasattr(pens, "glyphName"):
                out.data(glyphName=pens.glyphName)
        return out
    
    def __init__(self, *vals, **kwargs):
        prenorm = [v.rect if isinstance(v, Scaffold) else v for v in vals]

        super().__init__(*prenorm)

        if isinstance(self._val, RecordingPen):
            pass
        elif isinstance(self._val, Rect):
            r = self._val
            self._val = RecordingPen()
            self.rect(r)
        elif isinstance(self._val, Point):
            p = self._val
            self._val = RecordingPen()
            self.rect(Rect.FromCenter(p, 20))
        else:
            raise Exception("Can’t understand _val", self._val)

        # more backwards compat
        for k, v in kwargs.items():
            if k == "fill":
                self.f(v)
            elif k == "stroke":
                self.s(v)
            elif k == "strokeWidth":
                self.sw(v)
            elif k == "image":
                self.img(**v)
            elif k == "shadow":
                self.shadow(**v)
            else:
                raise Exception("Invalid __init__ kwargs", k)

    def reset_val(self):
        super().reset_val()
        self._val = RecordingPen()
        return self
    
    def val_present(self):
        return self._val is not None and len(self._val.value) > 0
    
    def copy_val(self, val):
        copy = RecordingPen()
        if self.val_present():
            copy.value = deepcopy(self._val.value)
        return copy
    
    def printable_val(self):
        if self.val_present():
            return f"{len(self._val.value)}mvs"
    
    def printable_data(self):
        out = {}
        exclude = ["_last_align_rect", "_notebook_shown"]
        for k, v in self._data.items():
            if k not in exclude:
                out[k] = v
        return out
    
    def normalize_attr_value(self, k, v):
        if k == "fill" and not isinstance(v, Color):
            return normalize_color(v)
        else:
            return super().normalize_attr_value(k, v)

    def style(self, style="_default"):
        """for backwards compatibility with defaults and grouped-stroke-properties"""
        st = {**super().style(style)}
        return self.groupedStyle(st)
    
    def unframe(self):
        def _unframe(el, _, __):
            el.data(frame=None)

        return self.walk(_unframe)
    
    def frame(self, fn_or_rect):
        if isinstance(fn_or_rect, Rect):
            self.data(frame=fn_or_rect)
        elif callable(fn_or_rect):
            self.data(frame=fn_or_rect(self))
        return self
    
    def pen(self):
        """collapse and combine into a single vector"""
        if len(self) == 0:
            return self
        
        frame = self.ambit()
        self.collapse()

        for el in self._els:
            el._val.replay(self._val)
            #self._val.record(el._val)

        self._attrs = {**self._els[0]._attrs, **self._attrs}
            
        self.data(frame=frame)
        self._els = []
        return self
    
    def down(self):
        return self.pen()
    
    def pens(self):
        if self.val_present():
            return self.ups()
        else:
            return self

    # multi-use overrides
    
    def reverse(self, recursive=False, winding=True):
        """Reverse elements; if pen value present, reverse the winding direction of the pen."""
        if winding and self.val_present():
            if self.unended():
                self.closePath()
            dp = RecordingPen()
            rp = ReverseContourPen(dp)
            self.replay(rp)
            self._val.value = dp.value
            return self

        return super().reverse(recursive=recursive, winding=winding)
    
    def index(self, idx, fn=None):
        if not self.val_present():
            return super().index(idx, fn)
        
        return self.mod_contour(idx, fn)
    
    def indices(self, idxs, fn=None):
        if not self.val_present():
            return super().indices(idxs, fn)

        def apply(idx, x, y):
            if idx in idxs:
                return fn(Point(x, y))
        
        return self.map_points(apply)
    
    def wordPens(self, pred=lambda x: x.glyphName == "space"):
        def _wp(p):
            return (p
                .split(pred)
                .map(lambda x: x
                    .data(word="/".join([p.glyphName for p in x]))
                    .pen()))
        
        d = self.depth()
        if d == 1:
            return _wp(self)
        
        out = type(self)()
        for pen in self:
            out.append(_wp(pen))
        return out
    
    def interpolate(self, value, other, frame=False):
        if len(self.v.value) != len(other.v.value):
            raise Exception("Cannot interpolate / diff lens")
        vl = []
        for idx, (mv, pts) in enumerate(self.v.value):
            ipts = []
            for jdx, p in enumerate(pts):
                pta = Point(p)
                try:
                    ptb = Point(other.v.value[idx][-1][jdx])
                except IndexError:
                    print(">>>>>>>>>>>>> Can’t interpolate", idx, mv, "///", other.v.value[idx])
                    raise IndexError
                ipt = pta.interp(value, ptb)
                ipts.append(ipt)
            vl.append((mv, ipts))
        
        np = type(self)()
        np.v.value = vl

        if frame:
            af = self.data("frame")
            bf = other.data("frame")
            ff = af.interp(value, bf)
            np.data(frame=ff)

        return np
    
    def replaceGlyph(self, glyphName, replacement, limit=None):
        return self.replace(lambda p: p.glyphName == glyphName,
            lambda p: (replacement(p) if callable(replacement) else replacement)
                .translate(*p.ambit().xy()))
    
    def findGlyph(self, glyphName, fn=None):
        return self.find(lambda p: p.glyphName == glyphName, fn)
    
    def _repr_html_(self):
        #if self.data("_notebook_shown"):
        #    return None
        
        from coldtype.notebook import show, DEFAULT_DISPLAY
        self.ch(show(DEFAULT_DISPLAY, tx=1, ty=1))
        return None
    
    def text(self,
        text:str,
        style,
        frame:Rect,
        x="mnx",
        y="mny",
        ):
        self.rect(frame)
        self.data(
            text=text,
            style=style,
            align=(txt_to_edge(x), txt_to_edge(y)))
        return self
    
    # backwards compatibility (questionable if should exist)

    def reversePens(self):
        """for backwards compatibility"""
        return self.reverse(recursive=False)
    
    rp = reversePens

    def vl(self, value):
        self.v.value = value
        return self
    
    @property
    def _pens(self):
        return self._els
    
    @property
    def value(self):
        return self.v.value

    @property
    def glyphName(self):
        return self.data("glyphName")
    
    def ffg(self, glyphName, fn=None, index=0):
        return self.find_({"glyphName":glyphName}, fn, index)
    
    @staticmethod
    def Enumerate(enumerable, enumerator):
        return P().enumerate(enumerable, enumerator)
    
    def addFrame(self, frame):
        return self.data(frame=frame)
    
    def xAlignToFrame(self):
        return self.align(self.data("frame"), y=None)
    
    def pvl(self):
        for idx, (_, pts) in enumerate(self.v.value):
            if len(pts) > 0:
                self.v.value[idx] = list(self.v.value[idx])
                self.v.value[idx][-1] = [Point(p) for p in self.v.value[idx][-1]]
        return self
    
    def dots(self, radius=4):
        """(Necessary?) Create circles at moveTo commands"""
        dp = type(self)()
        for t, pts in self.v.value:
            if t == "moveTo":
                x, y = pts[0]
                dp.oval(Rect((x-radius, y-radius, radius, radius)))
        self.v.value = dp.v.value
        return self

    def _normPointSplat(self, p):

        if isinstance(p[0], Point):
            return p[0].xy()
        elif len(p) == 1:
            return p[0]
        else:
            return p


    def __normPointSplat(self, p):
        return self


    def moveTo(self, *p) -> "P":

        p = self._normPointSplat(p)
        self._val.moveTo(p)
        return self
    

    def _moveTo(self, *p) -> "P":
        return self


    def m(self, *p) -> "P":

        return self.moveTo(*p)


    def _m(self, *p) -> "P":
        return self


    def lineTo(self, *p) -> "P":

        p = self._normPointSplat(p)
        if len(self._val.value) == 0:
            self._val.moveTo(p)
        else:
            self._val.lineTo(p)
        return self
    

    def _lineTo(self, *p) -> "P":
        return self


    def l(self, *p) -> "P":

        return self.lineTo(*p)


    def _l(self, *p) -> "P":
        return self


    def qCurveTo(self, *points) -> "P":

        self._val.qCurveTo(*points)
        return self
    

    def _qCurveTo(self, *points) -> "P":
        return self


    def q(self, *p) -> "P":

        return self.qCurveTo(*p)


    def _q(self, *p) -> "P":
        return self


    def curveTo(self, *points) -> "P":

        self._val.curveTo(*points)
        return self
    

    def _curveTo(self, *points) -> "P":
        return self


    def c(self, *p) -> "P":

        return self.curveTo(*p)

    def closePath(self):
        self._val.closePath()
        return self
    
    def cp(self):
        return self.closePath()

    def endPath(self):
        self._val.endPath()
        return self
    
    def ep(self):
        return self.endPath()
    

    def _c(self, *p) -> "P":
        return self


    def replay(self, pen) -> "P":

        self._val.replay(pen)

        for el in self._els:
            el.replay(pen)
        return self
    

    def _replay(self, pen) -> "P":
        return self


    def record(self, pen) -> "P":

        """Play a pen into this pen, meaning that pen will be added to this one’s value."""
        if hasattr(pen, "value"):
            pen.replay(self._val)
            return self

        if len(pen) > 0:
            for el in pen._els:
                self.record(el._val)
        elif pen:
            if isinstance(pen, Path):
                self.withJSONValue(pen)
            else:
                pen.replay(self._val)
        return self
    
    def unended(self):
        if not self.val_present():
            return None

        if len(self._val.value) == 0:
            return True
        elif self._val.value[-1][0] not in ["endPath", "closePath"]:
            return True
        return False
    
    def fully_close_path(self):
        if not self.val_present():
            # TODO log noop?
            return self

        if self._val.value[-1][0] == "closePath":        
            start = self._val.value[0][-1][-1]
            end = self._val.value[-2][-1][-1]

            if start != end:
                self._val.value = self._val.value[:-1]
                self.lineTo(start)
                self.closePath()
        return self
    
    fullyClosePath = fully_close_path


    def _record(self, pen) -> "P":
        return self


    def rect(self, rect) -> "P":

        """Rectangle primitive — `moveTo/lineTo/lineTo/lineTo/closePath`"""
        rect = Rect(rect)
        self.moveTo(rect.point("SW").xy())
        self.lineTo(rect.point("SE").xy())
        self.lineTo(rect.point("NE").xy())
        self.lineTo(rect.point("NW").xy())
        self.closePath()
        return self
    
    r = rect
    

    def _rect(self, rect) -> "P":
        return self


    def roundedRect(self, rect, hr, vr=None) -> "P":

        """Rounded rectangle primitive"""
        if vr is None:
            vr = hr
        l, b, w, h = Rect(rect)
        r, t = l + w, b + h
        K = 4 * (math.sqrt(2)-1) / 3
        circle = hr == 0.5 and vr == 0.5
        if hr <= 0.5:
            hr = w * hr
        if vr <= 0.5:
            vr = h * vr
        self.moveTo((l + hr, b))
        if not circle:
            self.lineTo((r - hr, b))
        self.curveTo((r+hr*(K-1), b), (r, b+vr*(1-K)), (r, b+vr))
        if not circle:
            self.lineTo((r, t-vr))
        self.curveTo((r, t-vr*(1-K)), (r-hr*(1-K), t), (r-hr, t))
        if not circle:
            self.lineTo((l+hr, t))
        self.curveTo((l+hr*(1-K), t), (l, t-vr*(1-K)), (l, t-vr))
        if not circle:
            self.lineTo((l, b+vr))
        self.curveTo((l, b+vr*(1-K)), (l+hr*(1-K), b), (l+hr, b))
        self.closePath()
        return self
    
    rr = roundedRect
    

    def _roundedRect(self, rect, hr, vr=None) -> "P":
        return self


    def oval(self, rect) -> "P":

        """Oval primitive"""
        if isinstance(rect, Point):
            self.roundedRect(Rect.FromCenter(rect, 20, 20), 0.5, 0.5)
        else:
            self.roundedRect(rect, 0.5, 0.5)
        return self
    
    o = oval


    def _oval(self, rect) -> "P":
        return self


    def line(self, points, moveTo=True, endPath=True) -> "P":

        """Syntactic sugar for `moveTo`+`lineTo`(...)+`endPath`; can have any number of points"""
        if isinstance(points, Line):
            points = list(points)
        if len(points) == 0:
            return self
        if len(self._val.value) == 0 or moveTo:
            self.moveTo(points[0])
        else:
            self.lineTo(points[0])
        for p in points[1:]:
            self.lineTo(p)
        if endPath:
            self.endPath()
        return self
    

    def _line(self, points, moveTo=True, endPath=True) -> "P":
        return self


    def hull(self, points) -> "P":

        """Same as `.line` but calls closePath instead of endPath`"""
        self.moveTo(points[0])
        for pt in points[1:]:
            self.lineTo(pt)
        self.closePath()
        return self
    
    def round(self):
        """Round the values of this pen to integer values."""
        return self.round_to(1)


    def _hull(self, points) -> "P":
        return self


    def round_to(self, rounding) -> "P":

        """Round the values of this pen to nearest multiple of rounding."""
        def rt(v, mult):
            rndd = float(round(v / mult) * mult)
            if rndd.is_integer():
                return int(rndd)
            else:
                return rndd
        
        rounded = []
        for t, pts in self._val.value:
            _rounded = []
            for p in pts:
                if p:
                    x, y = p
                    _rounded.append((rt(x, rounding), rt(y, rounding)))
                else:
                    _rounded.append(p)
            rounded.append((t, _rounded))
        
        self._val.value = rounded
        return self
    
    # Compound curve mechanics
    

    def _round_to(self, rounding) -> "P":
        return self


    def interpCurveTo(self, p1, f1, p2, f2, to, inset=0) -> "P":

        a = Point(self._val.value[-1][-1][-1])
        d = Point(to)
        pl = Line(p1, p2).inset(inset)
        b = Line(a, pl.start).t(f1/100)
        c = Line(d, pl.end).t(f2/100)
        return self.curveTo(b, c, d)
    

    def _interpCurveTo(self, p1, f1, p2, f2, to, inset=0) -> "P":
        return self


    def ioc(self, pt, slope=0, fA=0, fB=85) -> "P":

        return self.ioEaseCurveTo(pt, slope, fA, fB)


    def _ioc(self, pt, slope=0, fA=0, fB=85) -> "P":
        return self


    def ioEaseCurveTo(self, pt, slope=0, fA=0, fB=85) -> "P":

        a = Point(self._val.value[-1][-1][-1])
        d = Point(pt)
        box = Rect.FromMnMnMxMx([
            min(a.x, d.x),
            min(a.y, d.y),
            max(a.x, d.x),
            max(a.y, d.y)
        ])

        if a.y < d.y:
            line_vertical = Line(box.ps, box.pn)
        else:
            line_vertical = Line(box.pn, box.ps)

        angle = Line(a, d).angle() - line_vertical.angle()

        try:
            fA1, fA2 = fA
        except TypeError:
            fA1, fA2 = fA, fA
        
        try:
            fB1, fB2 = fB
        except TypeError:
            fB1, fB2 = fB, fB

        rotated = line_vertical.rotate(math.degrees(angle*(slope/100)))
        vertical = Line(rotated.intersection(box.es), rotated.intersection(box.en))

        if a.y > d.y:
            vertical = vertical.reverse()

        c1 = Line(a, vertical.start).t(fA1)
        c2 = Line(vertical.mid, vertical.start).t(fA1)
        self.lineTo(c1)
        self.curveTo(
            Line(c1, vertical.start).t(fB1),
            Line(c2, vertical.start).t(fB1),
            c2)
        c1 = Line(vertical.mid, vertical.end).t(fA2)
        c2 = Line(d, vertical.end).t(fA2)
        self.lineTo(c1)
        self.curveTo(
            Line(c1, vertical.end).t(fB2),
            Line(c2, vertical.end).t(fB2),
            c2)
        self.lineTo(d)
        return self
    
    def bxc(self, pt, point, factor=65, po=(0, 0), mods={}, flatten=False):
        return self.boxCurveTo(pt, point, factor, po, mods, flatten)
    
    def boxCurveTo(self, pt, point, factor=65, po=(0, 0), mods={}, flatten=False):
        #print("BOX", point, factor, pt, po, mods)

        if flatten:
            self.lineTo(pt)
            return self
        
        a = Point(self._val.value[-1][-1][-1])
        d = Point(pt)
        box = Rect.FromMnMnMxMx([
            min(a.x, d.x),
            min(a.y, d.y),
            max(a.x, d.x),
            max(a.y, d.y)
        ])

        try:
            f1, f2 = factor
        except TypeError:
            if isinstance(factor, Atom):
                f1, f2 = (factor[0], factor[0])
            else:
                f1, f2 = (factor, factor)

        if isinstance(point, str):
            #print("POINT", point)
            if point == "cx": # ease-in-out
                if a.y < d.y:
                    p1 = box.pse
                    p2 = box.pnw
                elif a.y > d.y:
                    p1 = box.pne
                    p2 = box.psw
                else:
                    p1 = p2 = a.interp(0.5, d)
            elif point == "e": # ease-in
                if a.y < d.y:
                    p1 = p2 = box.pse
                elif a.y > d.y:
                    p1 = p2 = box.pne
                else:
                    p1 = p2 = a.interp(0.5, d)
            elif point == "w": # ease-out
                if a.y < d.y:
                    p1 = p2 = box.pnw
                elif a.y > d.y:
                    p1 = p2 = box.psw
                else:
                    p1 = p2 = a.interp(0.5, d)
            else:
                if "," in point:
                    pt1, pt2 = [x.strip() for x in point.split(",")]
                    p1 = box.point(pt1)
                    p2 = box.point(pt2)
                else:
                    p = box.point(point)
                    p1, p2 = (p, p)
        elif isinstance(point, Point):
            p1, p2 = point, point
        else:
            p1, p2 = point
            p1 = box.point(p1)
            p2 = box.point(p2)
        
        p1 = p1.offset(*po)
        p2 = p2.offset(*po)
        
        b = a.interp(f1, p1)
        c = d.interp(f2, p2)

        mb = mods.get("b")
        mc = mods.get("c")
        if mb:
            b = mb(b)
        elif mc:
            c = mc(c)
        
        self.curveTo(b, c, d)
        return self
    

    def _ioEaseCurveTo(self, pt, slope=0, fA=0, fB=85) -> "P":
        return self


    def mirror(self, y=0, point=None):

        s = (1, -1) if y else (-1, 1)
        if point == 0:
            point = (0, 0)
        
        return (self.layer(1,
            lambda p: p.scale(*s, point=point or self.ambit().psw)))
    

    def _mirror(self, y=0, point=None):
        return self


    def mirrorx(self, point=None) -> "P":

        return self.mirror(y=0, point=point)
    

    def _mirrorx(self, point=None) -> "P":
        return self


    def mirrory(self, point=None) -> "P":

        return self.mirror(y=1, point=point)
    

    def _mirrory(self, point=None) -> "P":
        return self


    def pattern(self, rect, clip=False) -> "P":

        dp_copy = self.copy()
        #dp_copy.value = self.value

        for y in range(-1, 1):
            for x in range(-1, 1):
                dpp = type(self)()
                dp_copy.replay(dpp)
                dpp.translate(rect.w*x, rect.h*y)
                dpp.replay(self)
        
        self.translate(rect.w/2, rect.h/2)
        if clip:
            clip_box = type(self)().rect(rect)
            return self.intersection(clip_box)
        return self
    

    def _pattern(self, rect, clip=False) -> "P":
        return self


    def withRect(self, rect, fn):

        r = Rect(rect)
        return fn(r, self).data(frame=r)
    

    def _withRect(self, rect, fn):
        return self


    def gridlines(self, rect, x=20, y=None, absolute=False) -> "P":

        """Construct a grid in the pen using `x` and (optionally) `y` subdivisions"""
        xarg = x
        yarg = y or x
        if absolute:
            x = int(rect.w / xarg)
            y = int(rect.h / yarg)
        else:
            x = xarg
            y = yarg
        
        for _x in rect.subdivide(x, "minx"):
            if _x.x > 0 and _x.x > rect.x:
                self.line([_x.point("NW"), _x.point("SW")])
        for _y in rect.subdivide(y, "miny"):
            if _y.y > 0 and _y.y > rect.y:
                self.line([_y.point("SW"), _y.point("SE")])
        return self.f(None).s(0, 0.1).sw(3)
    

    def _gridlines(self, rect, x=20, y=None, absolute=False) -> "P":
        return self


    def ez(self, r, start_y, end_y, s) -> "P":

        self.moveTo(r.edge("W").t(start_y))
        self.gs(s, do_close=False, first_move="lineTo")
        self.lineTo(r.edge("E").t(end_y))
        self.endPath()
        return self
    

    def _ez(self, r, start_y, end_y, s) -> "P":
        return self


    def segments(self, all_curves=False) -> "P":

        if not self.val_present():
            for idx, el in enumerate(self._els):
                self._els[idx] = el.segments()
            return self
        
        segs = []
        last = None
        for contour in self.copy().explode():
            for mv, pts in contour.v.value:
                if last:
                    if mv == "curveTo":
                        segs.append(type(self)().moveTo(last).curveTo(*pts))
                    if mv == "lineTo":
                        if all_curves:
                            ln = Line(last, pts[0])
                            segs.append(type(self)().moveTo(ln.start).curveTo(ln.t(0.25), ln.t(0.75), ln.end))
                        else:
                            segs.append(type(self)().moveTo(last).lineTo(*pts))
                
                if len(pts) > 0:
                    last = pts[-1]
                else:
                    last = None
        
        self._val = None
        self._els = segs
        return self

    def join(self):
        self._val = RecordingPen()

        self._val.moveTo(self._els[0].v.value[0][-1][-1])
        for el in self._els:
            self._val.value.extend(el.v.value[1:])
        
        self._els = []
        return self
    
    def substructure(self):
        indicators = type(self)()
        def append(p):
            substructure = p.data("substructure")
            if substructure:
                indicators.append(substructure)
        self.mapv(append)
        return indicators

    def bounds(self):
        """Calculate the exact bounds of this shape, using a BoundPen"""
        b = Rect(0, 0, 0, 0)
        
        if self.val_present():
            try:
                cbp = BoundsPen(None)
                self._val.replay(cbp)
                mnx, mny, mxx, mxy = cbp.bounds
                b = Rect((mnx, mny, mxx - mnx, mxy - mny))
            except:
                pass
        
        if len(self._els) > 0:
            bs = []
            for el in self._els:
                eb = el.bounds()
                if eb and eb.nonzero():
                    bs.append(eb)
            
            if len(bs) > 0:
                b = bs[0]
                for eb in bs[1:]:
                    b = b.union(eb)
        
        return b
    

    def _segments(self, all_curves=False) -> "P":
        return self


    def _normT(self, th, tv, tx, ty, t) -> "P":

        import traceback
        global THTV_WARNING

        if th is not None:
            #traceback.print_stack()
            tx = th
            if not THTV_WARNING:
                print("! API CHANGE: th/tv are now tx/ty !")
                THTV_WARNING = True
        if tv is not None:
            #traceback.print_stack()
            ty = tv
            if not THTV_WARNING:
                print("! API CHANGE: th/tv are now tx/ty !")
                THTV_WARNING = True

        if t is not None:
            tx = bool(int(t))
            if tx:
                ty = int((t-1)*10) == 1
            else:
                ty = int(t)*10 == 1
        else:
            tx, ty = tx, ty
        return tx, ty
    
    def empty(self):
        return len(self._val.value) == 0
    
    def ambit(self, th=None, tv=None, tx=0, ty=0, t=None) -> Rect:
        """
        Get the calculated rect boundary.
        
        - `tx` means `(t)rue (x)` (i.e. the true width/horizontal dimension (was previously th));
        - `ty` means `(t)rue (y)` (i.e. the true height/vertical dimension (was previously tv));
        
        Passing either ignores a non-bounds-derived frame
        in either dimension
        """
        
        tx, ty = self._normT(th, tv, tx, ty, t)
        f = self._data.get("frame", None)

        # true bounds
        if tx and ty:
            return self.bounds()
        
        # true no-bounds
        elif not tx and not ty and f:
            return f
        
        # partial bounds
        elif f and (self.val_present() or (self.data("glyphName") and len(self) == 0)):
            if self.empty():
                if tx:
                    f = f.setw(0)
                elif ty:
                    f = f.seth(0)
                return f
            else:
                b = self.bounds()
                if tx:
                    return Rect(b.x, f.y, b.w, f.h)
                else:
                    return Rect(f.x, b.y, f.w, b.h)
        
        # pass-to-els
        elif len(self._els) > 0:
            try:
                union = self._els[0].ambit(tx=tx, ty=ty)
                for p in self._els[1:]:
                    a = p.ambit(tx=tx, ty=ty)
                    if a.x == 0 and a.y == 0 and a.w == 0 and a.h == 0:
                        continue
                    union = union.union(a)
                return union
            except Exception as _:
                return Rect(0,0,0,0)
        
        # catch-all
        return self.bounds()
        
        # if f or self._val:
        #     if (th or tv) and not self.empty():
        #         b = self.bounds()
        #         if th and tv:
        #             return b
        #         elif th:
        #             return Rect(b.x, f.y, b.w, f.h)
        #         else:
        #             return Rect(f.x, b.y, f.w, b.h)
        #     else:
        #         if self.empty():
        #             if th:
        #                 f = f.setw(0)
        #             elif tv:
        #                 f = f.seth(0)
        #             return f
        #         return f
        # elif :
        #     return self.bounds()
    
    getFrame = ambit
    

    def __normT(self, th, tv, tx, ty, t) -> "P":
        return self


    def align(self,
        rect,
        x="mdx",
        y="mdy",
        th=None, # deprecated
        tv=None, # deprecated
        tx=1,
        ty=0,
        transformFrame=True,
        h=None,
        returnOffset=False
        ) -> "P":

        """
        Align this pen to another rect, defaults to the center.

        - `tx` means true-x (i.e. will disregard any invisible 'frame'
        set on the pen (as in the case of glyphs returned from StSt/Glyphwise));
        - `ty` means true-y, which is the same but for the vertical dimension
        """

        if not isinstance(rect, Rect):
            rect = rect.rect
        
        tx, ty = self._normT(th, tv, tx, ty, None)
        r = self.ambit(tx=tx, ty=ty)

        if h is not None:
            r = r.seth(h)
        
        self.data(_last_align_rect=rect)
        
        offset = align(r, rect, x, y)
        self.translate(*offset,
            transformFrame=transformFrame)
        
        if returnOffset:
            return offset
        else:
            return self
    
    å = align


    def _align(self,
        rect,
        x="mdx",
        y="mdy",
        th=None, # deprecated
        tv=None, # deprecated
        tx=1,
        ty=0,
        transformFrame=True,
        h=None,
        returnOffset=False
        ) -> "P":
        return self


    def xalign(self, rect=None, x="centerx", th=None, tv=None, tx=1, ty=0) -> "P":

        tx, ty = self._normT(th, tv, tx, ty, None)

        if x == "C":
            x = "CX"
        
        if rect is None:
            rect = self.ambit(tx=tx, ty=ty)
        
        if callable(rect):
            rect = rect(self)
        
        self.align(rect, x=x, y=None, tx=tx, ty=ty)
        for el in self._els:
            el.align(rect, x=x, y=None, tx=tx, ty=ty)
        return self
    
    xå = xalign


    def _xalign(self, rect=None, x="centerx", th=None, tv=None, tx=1, ty=0) -> "P":
        return self


    def yalign(self, rect=None, y="centery", th=None, tv=None, tx=0, ty=1) -> "P":

        tx, ty = self._normT(th, tv, tx, ty, None)

        if rect is None:
            rect = self.ambit(tx=tx, ty=ty)
        
        if callable(rect):
            rect = rect(self)
        
        self.align(rect, x=None, y=y, th=tx, tv=ty)
        return self
    
    xå = xalign


    def _yalign(self, rect=None, y="centery", th=None, tv=None, tx=0, ty=1) -> "P":
        return self


    def _normPoint(self, point=None, th=None, tv=None, tx=0, ty=0, **kwargs) -> "P":

        tx, ty = self._normT(th, tv, tx, ty, kwargs.get("t"))

        if "pt" in kwargs:
            point = kwargs["pt"]
        
        a = self.ambit(tx=tx, ty=ty)
        if point is None:
            return a.pc
        elif point == 0:
            return a.psw
        elif point is False:
            return Point(0, 0)
        elif isinstance(point, str):
            if point.startswith("tx"):
                a = self.ambit(tx=1, ty=0)
                point = point[2:]
            elif point.startswith("ty"):
                a = self.ambit(tx=0, ty=1)
                point = point[2:]
            elif point.startswith("t"):
                a = self.ambit(tx=1, ty=1)
                point = point[1:]
            return a.point(point)
        elif (not (isinstance(point[1], int)
                or isinstance(point[1], float))
            and hasattr(self, "_normPoint")):
            return self[point[0]]._normPoint(point[1])
        else:
            return Point(point)
    

    def __normPoint(self, point=None, th=None, tv=None, tx=0, ty=0, **kwargs) -> "P":
        return self


    def transform(self, transform, transformFrame=True) -> "P":

        """Perform an arbitrary transformation on the pen, using the fontTools `Transform` class."""

        if self.val_present():
            op = RecordingPen()
            tp = TransformPen(op, transform)
            self._val.replay(tp)
            self._val.value = op.value
        
        f = self._data.get("frame")
        if transformFrame and f:
            self.data(frame=f.transform(transform))
        
        for p in self._els:
            p.transform(transform, transformFrame=transformFrame)
        
        substructure = self._data.get("substructure")
        if substructure:
            substructure.transform(transform, transformFrame=transformFrame)
        
        img = self.img()
        if img:
            img["rect"] = img["rect"].transform(transform)
        
        return self
    

    def _transform(self, transform, transformFrame=True) -> "P":
        return self


    def invertYAxis(self, height) -> "P":

        rp = RecordingPen()
        tp = TransformPen(rp, (1, 0, 0, -1, 0, height))
        self.replay(tp)
        self._val.value = rp.value
        return self
    

    def _invertYAxis(self, height) -> "P":
        return self


    def nonlinear_transform(self, fn) -> "P":

        for el in self._els:
            el.nonlinear_transform(fn)
        
        if self.val_present():
            for idx, (move, pts) in enumerate(self._val.value):
                if len(pts) > 0:
                    _pts = []
                    for _pt in pts:
                        x, y = _pt
                        _pts.append(fn(x, y))
                    self._val.value[idx] = (move, _pts)
        
        return self
    
    nlt = nonlinear_transform
    

    def _nonlinear_transform(self, fn) -> "P":
        return self


    def translate(self, x, y=None, transformFrame=True) -> "P":

        """Translate this shape by `x` and `y` (pixel values)."""
        if y is None:
            y = x
        return self.transform(Transform(1, 0, 0, 1, x, y), transformFrame=transformFrame)
    
    offset = translate
    t = translate
    

    def _translate(self, x, y=None, transformFrame=True) -> "P":
        return self


    def zero(self, th=None, tv=None, tx=0, ty=0) -> "P":

        tx, ty = self._normT(th, tv, tx, ty, None)
        x, y, _, _ = self.ambit(tx=tx, ty=ty)
        self.translate(-x, -y)
        return self
    

    def _zero(self, th=None, tv=None, tx=0, ty=0) -> "P":
        return self


    def centerZero(self, th=None, tv=None, tx=0, ty=0):

        tx, ty = self._normT(th, tv, tx, ty, None)

        x, y, w, h = self.ambit(tx=tx, ty=ty)
        nx, ny = -x-w/2, -y-h/2
        return (self
            .t(-x-w/2, -y-h/2)
            .data(centerZeroOffset=(nx, ny)))
    

    def _centerZero(self, th=None, tv=None, tx=0, ty=0):
        return self


    def centerPoint(self, rect, pt, interp=1, th=None, tv=None, tx=1, ty=0, **kwargs) -> "P":

        tx, ty = self._normT(th, tv, tx, ty, None)

        if "i" in kwargs:
            interp = kwargs["i"]
        
        x, y = self._normPoint(pt, tx=tx, ty=ty, **kwargs)

        return self.translate(norm(interp, 0, rect.w/2-x), norm(interp, 0, rect.h/2-y))
    

    def _centerPoint(self, rect, pt, interp=1, th=None, tv=None, tx=1, ty=0, **kwargs) -> "P":
        return self


    def skew(self, x=0, y=0, point=None, th=None, tv=None, tx=1, ty=0, **kwargs) -> "P":

        tx, ty = self._normT(th, tv, tx, ty, None)

        t = Transform()
        px, py = self._normPoint(point, tx=tx, ty=ty, **kwargs)
        t = t.translate(px, py)
        t = t.skew(x, y)
        t = t.translate(-px, -py)
        return self.transform(t)
    

    def _skew(self, x=0, y=0, point=None, th=None, tv=None, tx=1, ty=0, **kwargs) -> "P":
        return self


    def rotate(self, degrees, point=None, th=None, tv=None, tx=1, ty=1, **kwargs) -> "P":

        """Rotate this shape by a degree (in 360-scale, counterclockwise)."""
        tx, ty = self._normT(th, tv, tx, ty, None)

        t = Transform()
        x, y = self._normPoint(point, tx=tx, ty=ty, **kwargs)
        t = t.translate(x, y)
        t = t.rotate(math.radians(degrees))
        t = t.translate(-x, -y)
        return self.transform(t, transformFrame=False)
    
    rt = rotate
    

    def _rotate(self, degrees, point=None, th=None, tv=None, tx=1, ty=1, **kwargs) -> "P":
        return self


    def scale(self, scaleX, scaleY=None, point=None, th=None, tv=None, tx=1, ty=0, **kwargs) -> "P":

        """Scale this shape by a percentage amount (1-scale)."""
        tx, ty = self._normT(th, tv, tx, ty, None)

        t = Transform()
        x, y = self._normPoint(point, tx=tx, ty=ty, **kwargs)
        if point is not False:
            t = t.translate(x, y)
        t = t.scale(scaleX, scaleY or scaleX)
        if point is not False:
            t = t.translate(-x, -y)
        return self.transform(t)
    

    def _scale(self, scaleX, scaleY=None, point=None, th=None, tv=None, tx=1, ty=0, **kwargs) -> "P":
        return self


    def scaleToRect(self, rect, preserveAspect=True, shrink_only=False, tx=1, ty=0) -> "P":

        """Scale this shape into a `Rect`."""
        bounds = self.bounds()
        if not bounds.nonzero():
            return self

        h = rect.w / bounds.w
        v = rect.h / bounds.h
        if preserveAspect:
            scale = h if h < v else v
            if shrink_only and scale >= 1:
                return self
            return self.scale(scale, tx=tx, ty=ty)
        else:
            if shrink_only and (h >= 1 or v >= 1):
                return self
            return self.scale(h, v, tx=tx, ty=ty)
    

    def _scaleToRect(self, rect, preserveAspect=True, shrink_only=False, tx=1, ty=0) -> "P":
        return self


    def scaleToWidth(self, w, shrink_only=False) -> "P":

        """Scale this shape horizontally"""
        b = self.bounds()
        if shrink_only and b.w < w:
            return self
        else:
            return self.scale(w / self.bounds().w, 1)
    

    def _scaleToWidth(self, w, shrink_only=False) -> "P":
        return self


    def scaleToHeight(self, h, shrink_only=False) -> "P":

        """Scale this shape horizontally"""
        b = self.bounds()
        if shrink_only and b.h < h:
            return self
        return self.scale(1, h / self.bounds().h)
    
    # multi-elements


    def _scaleToHeight(self, h, shrink_only=False) -> "P":
        return self


    def distribute(self, v=False, tracks=None, th=None, tv=None, tx=0, ty=0) -> "P":

        tx, ty = self._normT(th, tv, tx, ty, None)

        off = 0
        for idx, p in enumerate(self):
            if tracks is not None and idx > 0:
                t = tracks[idx-1]
                #print(t)
                off += t
            frame = p.ambit(tx=tx, ty=ty)
            if v:
                if frame.y < 0:
                    p.translate(0, -frame.y)
                p.translate(0, off)
                off += frame.h
            else:
                if frame.x < 0:
                    p.translate(-frame.x, 0)
                if frame.x > 0 and th:
                    p.translate(-frame.x, 0)
                p.translate(off, 0)
                off += frame.w
        return self
    

    def _distribute(self, v=False, tracks=None, th=None, tv=None, tx=0, ty=0) -> "P":
        return self


    def spread(self, tracking=0, tx=0, zero=False) -> "P":

        "Horizontal distribution of elements"
        if zero:
            for p in self:
                p.zero()
        ambits = [p.ambit(tx=tx, ty=0).expand(tracking, "E") for p in self._els]
        
        ax = 0
        for idx, p in enumerate(self._els):
            aw = ambits[idx].w
            p.translate(ax, 0)
            ax += aw

        return self
    

    def _spread(self, tracking=0, tx=0, zero=False) -> "P":
        return self


    def stack(self, leading=0, ty=0, zero=False) -> "P":

        "Vertical distribution of elements"
        if zero:
            for p in self:
                p.zero()
        ambits = [p.ambit(tx=0, ty=ty).expand(leading, "N") for p in self._els]
        for idx, p in enumerate(self._els):
            for a in ambits[idx+1:]:
                p.translate(0, a.h)
        return self
    

    def _stack(self, leading=0, ty=0, zero=False) -> "P":
        return self


    def track(self, t, v=False) -> "P":

        """Track-out/distribute elements"""
        for idx, p in enumerate(self._els):
            if v:
                p.translate(0, -t*idx)
            else:
                p.translate(t*idx, 0)
        return self
    

    def _track(self, t, v=False) -> "P":
        return self


    def lead(self, leading) -> "P":

        "Vertical spacing"
        ln = len(self._els)

        try:
            if self._els[-1].ambit().y > self._els[0].ambit().y:
                leading = -leading
        except IndexError:
            pass
        
        for idx, p in enumerate(self._els):
            p.translate(0, leading*(ln-1-idx))
        return self
    

    def _lead(self, leading) -> "P":
        return self


    def grid(self, every, spread=0, stack=0) -> "P":

        top = type(self)()
        row = None
        
        for idx, p in enumerate(self._els):
            if idx%every == 0:
                row = type(self)()
                top.append(row)
            row.append(p)
        
        self._els = top._els

        for row in self:
            row.spread(spread)
        
        self.stack(stack)
        return self
    

    def _grid(self, every, spread=0, stack=0) -> "P":
        return self


    def gridlayer(self, nx, ny=None, track=0, lead=0) -> "P":

        """Spread nx copies and then stack ny copies, w/ optional tracking & leading"""
        return (self
            .layer(nx)
            .spread(track)
            .layer(ny if ny is not None else nx)
            .stack(lead))
    
    def pasteup(self, styler=lambda p: p.f(bw(1)), padding=(5, 5), tx=1, ty=0, x="CX", y="CY"):
        r = self.ambit(tx=tx, ty=ty).inset(*[-x for x in padding]).zero()
        board = type(self)(r).ch(styler)
        self.align(r, tx=tx, ty=ty, x=x, y=y)
        return self.up().insert(0, board)
    

    def _gridlayer(self, nx, ny=None, track=0, lead=0) -> "P":
        return self


    def track_with_width(self, t) -> "P":

        """Track-out/distribute elements"""
        x = 0
        for idx, p in enumerate(self._els):
            frame = p.ambit()
            p.translate(x + t, 0)
            x += frame.w
        return self
    

    def _track_with_width(self, t) -> "P":
        return self


    def track_to_rect(self, rect, pullToEdges=False, r=0) -> "P":

        """Distribute pens evenly within a frame"""
        if len(self) == 1:
            return self.align(rect)
        total_width = 0
        pens = self._els
        if r:
            pens = list(reversed(pens))
        start_x = pens[0].ambit(tx=pullToEdges).x
        end_x = pens[-1].ambit(tx=pullToEdges).point("SE").x
        # TODO easy to knock out apostrophes here based on a callback, last "actual" frame
        total_width = end_x - start_x
        leftover_w = rect.w - total_width
        tracking_value = leftover_w / (len(self)-1)
        if pullToEdges:
            xoffset = rect.x - pens[0].bounds().x
        else:
            xoffset = rect.x - pens[0].ambit().x
        for idx, p in enumerate(pens):
            if idx == 0:
                p.translate(xoffset, 0)
            else:
                p.translate(xoffset+tracking_value*idx, 0)
        return self
    
    trackToRect = track_to_rect


    def _track_to_rect(self, rect, pullToEdges=False, r=0) -> "P":
        return self


    def connect(self, *others) -> "P":

        return (type(self)([self, *others])
            .distribute()
            .pen())

    @property
    def x(self): return self.ambit().x
    @property
    def y(self): return self.ambit().y
    @property
    def w(self): return self.ambit().w
    @property
    def h(self): return self.ambit().h

    @property
    def tx(self): return self.ambit(tx=1).x
    @property
    def ty(self): return self.ambit(ty=1).y
    @property
    def tw(self): return self.ambit(tx=1).w
    @property
    def th(self): return self.ambit(ty=1).h


    def _connect(self, *others) -> "P":
        return self


    def groupedStyle(self, st):

        sf = False
        if "stroke" in st:
            c = st["stroke"]
            sw = st.get("strokeWidth", 1)
            st["stroke"] = dict(color=c, weight=sw, miter=st.get("strokeMiter", None))
        
        if "strokeWidth" in st:
            del st["strokeWidth"]
        if "strokeMiter" in st:
            del st["strokeMiter"]
        if "strokeFirst" in st:
            sf = True
            del st["strokeFirst"]
        

        if "fill" not in st:
            st["fill"] = rgb(1, 0, 0.5)
        
        rest = ["blendmode", "image", "skp", "COLR"]
        if sf:
            order = ["shadow", "stroke", "fill", *rest]
        else:
            order = ["shadow", "fill", "stroke", *rest]
        
        sort = {k:v for k,v in sorted(st.items(), key=lambda kv: order.index(kv[0]))}
        return sort


    def _groupedStyle(self, st):
        return self


    def f(self, *value) -> "P":

        """Get/set a (f)ill"""
        if value:
            if not isinstance(value, Color):
                value = normalize_color(value)
            return self.attr(fill=value)
        else:
            return self.attr(field="fill")
    
    fill = f
    

    def _f(self, *value) -> "P":
        return self


    def s(self, *value) -> "P":

        """Get/set a (s)troke"""
        if value:
            if not isinstance(value, Color):
                value = normalize_color(value)
            return self.attr(stroke=value)
        else:
            return self.attr(field="stroke")
    
    stroke = s
    

    def _s(self, *value) -> "P":
        return self


    def sw(self, value) -> "P":

        """Get/set a (s)troke (w)idth"""
        if value is not None:
            return self.attr(strokeWidth=value)
        else:
            return self.attr(field="strokeWidth")
    
    strokeWidth = sw


    def _sw(self, value) -> "P":
        return self


    def ssw(self, s, sw) -> "P":

        self.s(s)
        self.sw(sw)
        return self
    

    def _ssw(self, s, sw) -> "P":
        return self


    def fssw(self, f, s, sw, sf=0) -> "P":

        self.f(f)
        self.s(s)
        self.sw(sw)
        self.sf(sf)
        return self
    

    def _fssw(self, f, s, sw, sf=0) -> "P":
        return self


    def strokeFirst(self, value=None) -> "P":

        """
        For a rendering engine that has to stroke and fill in two separate passes, perform the stroke _before_ the fill (akin to an `.understroke` but without the duplication overhead)
        """
        if value:
            return self.attr(strokeFirst=value)
        else:
            return self.attr(field="strokeFirst")
    

    def _strokeFirst(self, value=None) -> "P":
        return self


    def sf(self, value=None) -> "P":

        "strokeFirst"
        return self.strokeFirst(value)
    

    def _sf(self, value=None) -> "P":
        return self


    def strokeMiter(self, value=None) -> "P":

        """
        For a rendering engine that can specify stroke-miter
        """
        if value:
            return self.attr(strokeMiter=value)
        else:
            return self.attr(field="strokeMiter")


    def _strokeMiter(self, value=None) -> "P":
        return self


    def sm(self, value=None) -> "P":

        "strokeMiter"
        return self.strokeMiter(value)
    
    def img(self, src=None, rect=Rect(0, 0, 500, 500), pattern=False, opacity=1.0):
        """Get/set an image fill"""
        if src:
            from coldtype.img.datimage import DATImage
            if isinstance(src, DATImage):
                return self.attr(image=dict(src=src.src, rect=rect, pattern=pattern, opacity=opacity))
            return self.attr(image=dict(src=src, rect=rect, pattern=pattern, opacity=opacity))
        else:
            return self.attr(field="image")
    
    image = img

    def shadow(self, radius=10, color=(0, 0.3), clip=None):
        return self.attr(shadow=dict(color=normalize_color(color), radius=radius, clip=clip))
    
    # other


    def _sm(self, value=None) -> "P":
        return self


    def blendmode(self, blendmode=None, show=False) -> "P":

        if isinstance(blendmode, int):
            blendmode = BlendMode.Cycle(blendmode, show=show)
        elif isinstance(blendmode, str):
            blendmode = BlendMode[blendmode]
        
        if blendmode:
            return self.attr(blendmode=blendmode)
        else:
            return self.attr(field="blendmode")


    def _blendmode(self, blendmode=None, show=False) -> "P":
        return self


    def glyph(self, glyph, glyphSet=None, layerComponents=False) -> "P":

        """Play a glyph (like from `defcon`) into this pen."""
        out = type(self)()
        base = type(self)()
        out.append(base)
        glyph.draw(base._val)

        new_val = []
        for mv, pts in base._val.value:
            if mv == "addComponent":
                component_name, matrix = pts
                rp = RecordingPen()
                tp = TransformPen(rp, Transform(*matrix))
                component = glyphSet[component_name]
                # recursively realize any nested components
                realized = type(self)().glyph(component, glyphSet)
                realized.replay(tp)
                p = type(self)()
                p._val = rp
                out.append(p)
                if "addComponent" in str(p._val.value):
                    print("> NESTED COMPONENT", component_name)
            else:
                new_val.append((mv, pts))
        
        base._val.value = new_val
        
        if layerComponents:
            return out
        else:
            try:
                out.pen().replay(self._val)
            except IndexError:
                pass
            return self
    

    def _glyph(self, glyph, glyphSet=None, layerComponents=False) -> "P":
        return self


    def toGlyph(self, name=None, width=None, allow_blank=False):

        """
        Create a glyph (like from `defcon`) using this pen’s value.
        *Warning*: if path is unended, closedPath will be called
        """
        from defcon import Glyph
        if not allow_blank:
            if self.unended():
                self.closePath()
        bounds = self.bounds()
        glyph = Glyph()
        glyph.name = name
        glyph.width = width or bounds.w
        try:
            sp = glyph.getPen()
            self.replay(sp)
        except AssertionError:
            if not allow_blank:
                print(">>>blank glyph:", glyph.name)
        return glyph


    def _toGlyph(self, name=None, width=None, allow_blank=False):
        return self


    def pickle(self, dst) -> "P":

        dst.parent.mkdir(parents=True, exist_ok=True)
        fh = open(str(dst), "wb")
        
        def prune(pen, state, data):
            if state >= 0:
                if hasattr(pen, "_stst"):
                    pen._stst = None
        
        self.walk(prune)
        pickle.dump(self, fh)
        fh.close()
        return self
    

    def _pickle(self, dst) -> "P":
        return self


    def Unpickle(self, src):

        if isinstance(src, str):
            src = Path(src)
        return pickle.load(open(str(src.expanduser()), "rb"))
    

    def _Unpickle(self, src):
        return self


    def withJSONValue(self, path) -> "P":

        self._val.value = json.loads(Path(path)
            .expanduser()
            .read_text())
        return self
    

    def _withJSONValue(self, path) -> "P":
        return self


    def withSVGFile(self, svg_file) -> "P":

        from fontTools.svgLib import SVGPath
        svg = SVGPath.fromstring(svg_file.read_bytes())
        rp = RecordingPen()
        svg.draw(rp)
        self._val.value = rp.value
        return self


    def _withSVGFile(self, svg_file) -> "P":
        return self


    def _pathop(self, otherPen=None, operation=BooleanOp.XOR) -> "P":

        if self.val_present():
            self._val.value = calculate_pathop(self, otherPen, operation)
        
        if otherPen is not None or operation == BooleanOp.Simplify:
            for el in self._els:
                el._pathop(otherPen, operation)
        else:
            curr = self._els[0]
            for el in self._els[1:]:
                curr._pathop(el, operation)
            self._els = [curr]

        # if hasattr(self, "pmap"):
        #     return self.pmap(lambda p: p._pathop(otherPen, operation))
        # self.value = calculate_pathop(self, otherPen, operation)
        return self
    

    def __pathop(self, otherPen=None, operation=BooleanOp.XOR) -> "P":
        return self


    def difference(self, otherPen=None) -> "P":

        """Calculate and return the difference of this shape and another."""
        return self._pathop(otherPen=otherPen, operation=BooleanOp.Difference)
    

    def _difference(self, otherPen=None) -> "P":
        return self


    def union(self, otherPen=None) -> "P":

        """Calculate and return the union of this shape and another."""
        return self._pathop(otherPen=otherPen, operation=BooleanOp.Union)
    

    def _union(self, otherPen=None) -> "P":
        return self


    def xor(self, otherPen=None) -> "P":

        """Calculate and return the XOR of this shape and another."""
        return self._pathop(otherPen=otherPen, operation=BooleanOp.XOR)
    

    def _xor(self, otherPen=None) -> "P":
        return self


    def reverseDifference(self, otherPen=None) -> "P":

        """Calculate and return the reverseDifference of this shape and another."""
        return self._pathop(otherPen=otherPen, operation=BooleanOp.ReverseDifference)
    

    def _reverseDifference(self, otherPen=None) -> "P":
        return self


    def intersection(self, otherPen=None) -> "P":

        """Calculate and return the intersection of this shape and another."""
        return self._pathop(otherPen=otherPen, operation=BooleanOp.Intersection)
    
    def removeOverlap(self):
        """Remove overlaps within this shape and return itself."""
        return self._pathop(otherPen=None, operation=BooleanOp.Simplify)
    
    remove_overlap = removeOverlap
    ro = removeOverlap


    def _intersection(self, otherPen=None) -> "P":
        return self


    def distribute_on_path(self,
        path,
        offset=0,
        cc=None,
        notfound=None,
        center=False
        ) -> "P":

        if len(self) == 0:
            # TODO print error?
            return self

        if cc:
            cutter = cc
        else:
            cutter = CurveCutter(path)
        if center is not False:
            offset = (cutter.length-self.bounds().w)/2 + center
        limit = len(self._els)
        for idx, p in enumerate(self._els):
            f = p.ambit()
            bs = f.y
            ow = offset + f.x + f.w / 2
            #if ow < 0:
            #    if notfound:
            #        notfound(p)
            if ow > cutter.length:
                limit = min(idx, limit)
            else:
                _p, tangent = cutter.subsegmentPoint(end=ow)
                x_shift = bs * math.cos(math.radians(tangent))
                y_shift = bs * math.sin(math.radians(tangent))
                t = Transform()
                t = t.translate(_p[0] + x_shift - f.x, _p[1] + y_shift - f.y)
                t = t.translate(f.x, f.y)
                t = t.rotate(math.radians(tangent-90))
                t = t.translate(-f.x, -f.y)
                t = t.translate(-f.w*0.5)
                p.transform(t)

        if limit < len(self._els):
            self._els = self._els[0:limit]
        return self
    
    distributeOnPath = distribute_on_path


    def _distribute_on_path(self,
        path,
        offset=0,
        cc=None,
        notfound=None,
        center=False
        ) -> "P":
        return self


    def subsegment(self, start=0, end=1) -> "P":

        """Return a subsegment of the pen based on `t` values `start` and `end`"""
        if not self.val_present():
            return
        
        cc = CurveCutter(self)
        start = 0
        end = end * cc.calcCurveLength()
        pv = cc.subsegment(start, end)
        self._val.value = pv
        return self
    

    def _subsegment(self, start=0, end=1) -> "P":
        return self


    def point_t(self, t=0.5):

        """Get point value for time `t`"""
        cc = CurveCutter(self)
        start = 0
        tv = t * cc.calcCurveLength()
        p, tangent = cc.subsegmentPoint(start=0, end=tv)
        return p, tangent
    

    def _point_t(self, t=0.5):
        return self


    def split_t(self, t=0.5):

        if not self.val_present():
            return

        a = self._val.value[0][-1][0]
        b, c, d = self._val.value[-1][-1]
        return splitCubicAtT(a, b, c, d, t)
    

    def _split_t(self, t=0.5):
        return self


    def add_pt_t(self, cuidx, t) -> "P":

        if not self.val_present():
            return

        cidx = 0
        insert_idx = -1
        c1, c2 = None, None

        for idx, (mv, pts) in enumerate(self._val.value):
            if mv == "curveTo":
                if cidx == cuidx:
                    insert_idx = idx
                    a = self._val.value[idx-1][-1][-1]
                    b, c, d = pts
                    c1, c2 = splitCubicAtT(a, b, c, d, t)
                cidx += 1
            elif mv == "lineTo":
                if cidx == cuidx:
                    insert_idx = idx
                    a = self._val.value[idx-1][-1][-1]
                    b = pts[0]
                    l = Line(a, b)
                    c1 = [l.t(0.5)]
                    c2 = [b]
                cidx += 1
        
        if c2:
            if len(c2) > 1:
                self._val.value[insert_idx] = ("curveTo", c1[1:])
                self._val.value.insert(insert_idx+1, ("curveTo", c2[1:]))
            else:
                self._val.value[insert_idx] = ("lineTo", c1)
                self._val.value.insert(insert_idx+1, ("lineTo", c2))
        return self
    

    def _add_pt_t(self, cuidx, t) -> "P":
        return self


    def samples(self, interval=10, even=False):

        cc = CurveCutter(self)
        samples = []
        length = cc.calcCurveLength()
        inc = 1
        idx = 0
        while inc < length:
            pt, tan = cc.subsegmentPoint(start=0, end=inc)
            samples.append(CurveSample(idx, pt, inc / length, tan))
            inc += interval
            idx += 1
        
        for i, s in enumerate(samples):
            next = samples[i+1] if i < len(samples)-1 else s
            prev = samples[i-1] if i > 0 else s
            s.neighbors(prev, next)
        
        return samples
    

    def _samples(self, interval=10, even=False):
        return self


    def onSamples(self, interval=10, even=False, fn=None):

        return (type(self)().enumerate(self.samples(interval=interval, even=even), lambda s: fn(self, s)))
    

    def _onSamples(self, interval=10, even=False, fn=None):
        return self


    def length(self, t=1):

        """Get the length of the curve for time `t`"""
        cc = CurveCutter(self)
        start = 0
        tv = t * cc.calcCurveLength()
        return tv
    

    def _length(self, t=1):
        return self


    def ease_t(self, e, tries=0) -> "P":

        _, _, w, h = self.ambit()
        pen = MarginPen(None, e*w, isHorizontal=False)
        self.replay(pen)
        try:
            return pen.getAll()[0]/h
        except IndexError:
            # HACK for now but I guess works?
            #print("INDEX ERROR", e)
            if tries < 500:
                return self.ease_t(e-0.01, tries=tries+1)
            return 0
        

    def _ease_t(self, e, tries=0) -> "P":
        return self


    def divide(self, length=150, floor=True, count=None, idx=0, max=None) -> "P":

        a = self.v.value[0][-1][-1]
        b, c, d = self.v.value[1][-1]
        l = calcCubicArcLength(a, b, c, d)

        if count is not None:
            length = l / count
            floor = False

        if l < length:
            if max is not None and len(self.v.value) < max:
                self.add_pt_t(0, 0.5)
                self.divide(length=length, floor=False, idx=idx+1, max=max)
            return self
        
        if max is not None and len(self.v.value) >= max:
            return self

        if floor:
            fl = math.floor(l/length)
            length = l/fl
        
        t = 1/(l/length)
        
        if l > length*1.5:
            self.add_pt_t(0, 1-t)
            self.divide(length=length, floor=False, idx=idx+1, max=max)
        elif max is not None:
            self.add_pt_t(0, 0.5)
            self.divide(length=length, floor=False, idx=idx+1, max=max)
            pass
        return self

    # contours?

    def _divide(self, length=150, floor=True, count=None, idx=0, max=None) -> "P":
        return self


    def _prep_for_wave(self, flatten=1, centered=False):

        prepped = self.copy()
        if centered:
            prepped.center(tx=1, ty=1)
        
        if flatten > 0:
            prepped.flatten(flatten)
        
        return prepped


    def __prep_for_wave(self, flatten=1, centered=False):
        return self


    def toAudio(self, flatten=1, centered=False, loops=3, filename=None):

        import numpy as np
        from pedalboard.io import AudioFile

        prepped = self._prep_for_wave(flatten=flatten, centered=centered)

        left, right = [], []
        for (_, pts) in prepped._val.value:
            if len(pts) > 0:
                left.append(pts[0][0] / 1000)
                right.append(pts[0][1] / 1000)

        audio = np.tile(np.array([left, right]), loops)

        if filename:
            with AudioFile(filename, "w", samplerate=48000, num_channels=2) as f:
                f.write(audio)
        
        return audio, len(left)
    

    def _toAudio(self, flatten=1, centered=False, loops=3, filename=None):
        return self


    def fromAudio(self, audio, start=500, end=9500, step=1, mult=1360, scale=2) -> "P":

        for idx in range(start, end, step):
            try:
                x = audio[0][idx]
                y = audio[1][idx]
                self.oval(Rect.FromCenter((x*mult, y*mult), scale))
            except IndexError:
                pass
        return self

    # def wavefile(self, flatten=1, centered=False) -> str:
    #     #from IPython.display import Audio, display

    #     prepped = self._prep_for_wave(flatten=flatten, centered=centered)

    #     left, right = [], []
    #     for (_, pts) in prepped._val.value:
    #         if len(pts) > 0:
    #             left.append(pts[0][0])
    #             right.append(pts[0][1])

    #     samplesPerFrame = 200
    #     sampleRate = 48000.0 # hertz

    #     filename = "test_1.wav"

    #     obj = wave.open(filename, 'w')
    #     obj.setnchannels(2)
    #     obj.setsampwidth(2)
    #     obj.setframerate(sampleRate)

    #     for x in range(0, samplesPerFrame):
    #         for idx, l in enumerate(left):
    #             data = struct.pack('<h', int(l)*24)
    #             obj.writeframesraw(data)
    #             data = struct.pack('<h', int(right[idx])*24)
    #             obj.writeframesraw(data)

    #     # silence
    #     for _ in range(0, 5000):
    #         obj.writeframesraw(struct.pack("<h", 0))
    #         obj.writeframesraw(struct.pack("<h", 0))

    #     obj.close()

    #     return filename

    def nsew(self):
        pts = [el[1][-1] for el in self.v.value if len(el[1]) > 0]
        
        lines = []
        for i, p in enumerate(pts):
            if i + 1 == len(pts):
                lines.append(Line(p, pts[0]))
            else:
                lines.append(Line(p, pts[i+1]))
        
        mnx, mny, mxx, mxy = self.bounds().mnmnmxmx()
        min_ang = min([l.ang for l in lines])
        max_ang = max([l.ang for l in lines])
        #for idx, l in enumerate(lines):
        #    print(idx, ">", l.ang, min_ang, max_ang)
        xs = [l for l in lines if l.ang < 0.25 or l.ang > 2.5]
        ys = [l for l in lines if 1 < l.ang < 2]

        if len(ys) == 2 and len(xs) < 2:
            xs = [l for l in lines if l not in ys]
        elif len(ys) < 2 and len(xs) == 2:
            ys = [l for l in lines if l not in xs]
        
        #for l in ys:
        #    print(l.ang)

        #print(len(xs), len(ys))
        #print("--------------------")

        n = [l for l in xs if l.start.y == mxy or l.end.y == mxy][0]
        s = [l for l in xs if l.start.y == mny or l.end.y == mny][0]
        e = [l for l in ys if l.start.x == mxx or l.end.x == mxx][0]
        w = [l for l in ys if l.start.x == mnx or l.end.x == mnx][0]
        return n, s, e, w
    
    def avg(self):
        self.pvl()
        pts = []
        for _, _pts in self.v.value:
            if len(_pts) > 0:
                pts.extend(_pts)
        n = len(pts)
        return Point(
            sum([p.x for p in pts])/n,
            sum([p.y for p in pts])/n)

    @property
    def ecx(self):
        n, s, e, w = self.nsew()
        return e.interp(0.5, w.reverse())
    
    @property
    def ecy(self):
        n, s, e, w = self.nsew()
        return n.interp(0.5, s.reverse())
    

    def _fromAudio(self, audio, start=500, end=9500, step=1, mult=1360, scale=2) -> "P":
        return self


    def edge(self, e) -> "P":

        e = e.lower()
        if e == "n":
            return self.en
        elif e == "s":
            return self.es
        elif e == "e":
            return self.ee
        elif e == "w":
            return self.ew


    def _edge(self, e) -> "P":
        return self


    def point(self, pt) -> "P":

        n, s, e, w = self.nsew()
        if pt == "NE":
            return n.pe
        elif pt == "NW":
            return n.pw
        elif pt == "SE":
            return s.pe
        elif pt == "SW":
            return s.pw
        elif pt == "N":
            return n.mid
        elif pt == "S":
            return s.mid
        elif pt == "E":
            return e.mid
        elif pt == "W":
            return w.mid

    @property
    def pne(self): return self.point("NE")
    @property
    def pnw(self): return self.point("NW")
    @property
    def psw(self): return self.point("SW")
    @property
    def pse(self): return self.point("SE")
    @property
    def pn(self): return self.point("N")
    @property
    def ps(self): return self.point("S")
    @property
    def pe(self): return self.point("E")
    @property
    def pw(self): return self.point("W")
    @property
    def en(self): return self.nsew()[0]
    @property
    def es(self): return self.nsew()[1]
    @property
    def ee(self): return self.nsew()[2]
    @property
    def ew(self): return self.nsew()[3]

    def q2c(self):
        new_vl = []
        for mv, pts in self.v.value:
            if mv == "qCurveTo":
                decomposed = decomposeQuadraticSegment(pts)
                for dpts in decomposed:
                    qp1, qp2 = [Point(pt) for pt in dpts]
                    qp0 = Point(new_vl[-1][-1][-1])
                    cp1 = qp0 + (qp1 - qp0)*(2.0/3.0)
                    cp2 = qp2 + (qp1 - qp2)*(2.0/3.0)
                    new_vl.append(["curveTo", (cp1, cp2, qp2)])
            else:
                new_vl.append([mv, pts])
        self.v.value = new_vl
        return self


    def _point(self, pt) -> "P":
        return self


    def flatten(self, length=10, segmentLines=True) -> "P":

        """
        Runs a fontTools `FlattenPen` on this pen
        """
        for el in self._els:
            el.flatten(length, segmentLines)

        if self.val_present():
            rp = RecordingPen()
            fp = FlattenPen(rp, approximateSegmentLength=length, segmentLines=segmentLines)
            self.replay(fp)
            self._val.value = rp.value

        return self
    
    def smooth(self):
        for el in self._els:
            el.smooth()
        
        if self.val_present():
            rp = RecordingPen()
            fp = SmoothPointsPen(rp)
            self.replay(fp)
            self._val.value = rp.value
        
        return self
    

    def _flatten(self, length=10, segmentLines=True) -> "P":
        return self


    def catmull(self, points, close=False) -> "P":

        """Run a catmull spline through a series of points"""
        p0 = points[0]
        p1, p2, p3 = points[:3]
        pts = [p0]
        i = 1
        while i < len(points):
            pts.append([
                ((-p0[0] + 6 * p1[0] + p2[0]) / 6),
                ((-p0[1] + 6 * p1[1] + p2[1]) / 6),
                ((p1[0] + 6 * p2[0] - p3[0]) / 6),
                ((p1[1] + 6 * p2[1] - p3[1]) / 6),
                p2[0],
                p2[1]
            ])
            p0 = p1
            p1 = p2
            p2 = p3
            try:
                p3 = points[i + 2]
            except:
                p3 = p3
            i += 1
        self.moveTo(pts[0])
        for p in pts[1:]:
            self.curveTo((p[0], p[1]), (p[2], p[3]), (p[4], p[5]))
        if close:
            self.closePath()
        return self
    

    def _catmull(self, points, close=False) -> "P":
        return self


    def roughen(self, amplitude=10, threshold=10, ignore_ends=False, seed=None) -> "P":

        """Randomizes points in skeleton"""
        if seed is not None:
            rs = random_series(0, amplitude, seed=seed)
        else:
            rs = random_series(0, amplitude, seed=randint(0, 5000))
        randomized = []
        _x = 0
        _y = 0
        for idx, (t, pts) in enumerate(self.v.value):
            if idx == 0 and ignore_ends:
                randomized.append([t, pts])
                continue
            if idx == len(self.v.value) - 1 and ignore_ends:
                randomized.append([t, pts])
                continue
            if t == "lineTo" or t == "curveTo":
                #jx = pnoise1(_x) * amplitude # should actually be 1-d on the tangent (maybe? TODO)
                #jy = pnoise1(_y) * amplitude
                jx = rs[idx*2] - amplitude/2
                jy = rs[idx*2+1] - amplitude/2
                randomized.append([t, [(x+jx, y+jy) for x, y in pts]])
                _x += 0.2
                _y += 0.3
            else:
                randomized.append([t, pts])
        self.v.value = randomized
        return self
    
    def explode(self):
        """Convert all contours to individual paths"""
        for el in self._els:
            el.explode()

        if self.val_present():
            rp = RecordingPen()
            ep = ExplodingPen(rp)
            self.replay(ep)

            for p in ep._pens:
                el = type(self)()
                el._val.value = p
                el._attrs = deepcopy(self._attrs)
                self.append(el)
            
            self._val = RecordingPen()
        
        return self
    
    def implode(self):
        # TODO preserve frame from some of this?
        #self.reset_val()
        self._val = RecordingPen()
        
        for el in self._els:
            self.record(el._val)

        self._els = []
        return self
    

    def _roughen(self, amplitude=10, threshold=10, ignore_ends=False, seed=None) -> "P":
        return self


    def map_points(self, fn, filter_fn=None) -> "P":

        idx = 0
        for cidx, c in enumerate(self._val.value):
            move, pts = c
            pts = list(pts)
            for pidx, p in enumerate(pts):
                x, y = p
                if filter_fn and not filter_fn(Point(p)):
                    continue
                result = fn(idx, x, y)
                if result:
                    pts[pidx] = result
                idx += 1
            self._val.value[cidx] = (move, pts)
        return self
    

    def _map_points(self, fn, filter_fn=None) -> "P":
        return self


    def mod_contour(self, contour_index, mod_fn=None) -> "P":

        exploded = self.copy().explode()
        if mod_fn:
            mod_fn(exploded[contour_index])
            self._val.value = exploded.implode()._val.value
            return self
        else:
            return exploded[contour_index]
    

    def _mod_contour(self, contour_index, mod_fn=None) -> "P":
        return self


    def filterContours(self, filter_fn) -> "P":

        if self.val_present():
            exploded = self.explode()
            keep = []
            for idx, c in enumerate(exploded):
                if filter_fn(idx, c):
                    keep.append(c)
            self._val.value = type(self)(keep).implode()._val.value
        return self
    

    def _filterContours(self, filter_fn) -> "P":
        return self


    def repeat(self, times=1) -> "P":

        for el in self._els:
            el.repeat(times)

        if self.val_present():
            copy = self.copy()._val.value
            _, copy_0_data = copy[0]
            copy[0] = ("moveTo", copy_0_data)
            self._val.value = self._val.value[:-1] + copy
            if times > 1:
                self.repeat(times-1)
        
        return self


    def _repeat(self, times=1) -> "P":
        return self


    def outline(self,
        offset=1,
        drawInner=True,
        drawOuter=True,
        cap="square",
        miterLimit=None,
        closeOpenPaths=True
        ) -> "P":

        """AKA expandStroke"""
        for el in self._els:
            el.outline(offset, drawInner, drawOuter, cap, miterLimit, closeOpenPaths)
        
        if self.val_present():
            op = OutlinePen(None
                , offset=offset
                , optimizeCurve=True
                , cap=cap
                , miterLimit=miterLimit
                , closeOpenPaths=closeOpenPaths)
            
            self._val.replay(op)
            op.drawSettings(drawInner=drawInner
                , drawOuter=drawOuter)
            g = op.getGlyph()
            self._val.value = []
            g.draw(self._val)
        
        return self
    
    ol = outline
    

    def _outline(self,
        offset=1,
        drawInner=True,
        drawOuter=True,
        cap="square",
        miterLimit=None,
        closeOpenPaths=True
        ) -> "P":
        return self


    def project(self, angle, width) -> "P":

        offset = polarCoord((0, 0), math.radians(angle), width)
        self.translate(offset[0], offset[1])
        return self


    def _project(self, angle, width) -> "P":
        return self


    def castshadow(self,
        angle=-45,
        width=100,
        ro=1,
        fill=True
        ) -> "P":

        for el in self._els:
            el.castshadow(angle, width, ro, fill)
        
        if self.val_present():
            out = RecordingPen()
            tp = TranslationPen(out
                , frontAngle=angle
                , frontWidth=width)
            
            self._val.replay(tp)
            if fill:
                self.copy().project(angle, width)._val.replay(out)
                #out.record()
            
            self._val.value = out.value
            if ro:
                self.removeOverlap()
        
        return self
    

    def _castshadow(self,
        angle=-45,
        width=100,
        ro=1,
        fill=True
        ) -> "P":
        return self


    def understroke(self,
        s=0,
        sw=5,
        outline=False,
        dofill=0,
        miterLimit=None
        ) -> "P":

        if sw == 0:
            return self
        
        def mod_fn(p):
            if not outline:
                return p.fssw(s, s, sw)
            else:
                if dofill:
                    pf = p.copy()
                p.f(s).outline(sw*2, miterLimit=miterLimit)
                if dofill:
                    p.reverse().record(pf)
                return p

        return self.layerv(mod_fn, 1)
    def _understroke(self,
        s=0,
        sw=5,
        outline=False,
        dofill=0,
        miterLimit=None
        ) -> "P":
        return self



def runonCast():
    def _runonCast(p):
        return P.FromPens(p)
    return _runonCast

PS = P
DATPens = P
DATPen = P
DPS = P
DP = P