# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from .services.certificate_authority_service import (
    CertificateAuthorityServiceAsyncClient,
    CertificateAuthorityServiceClient,
)
from .types.resources import (
    CaPool,
    Certificate,
    CertificateAuthority,
    CertificateConfig,
    CertificateDescription,
    CertificateExtensionConstraints,
    CertificateIdentityConstraints,
    CertificateRevocationList,
    CertificateTemplate,
    KeyUsage,
    ObjectId,
    PublicKey,
    RevocationReason,
    Subject,
    SubjectAltNames,
    SubjectRequestMode,
    SubordinateConfig,
    X509Extension,
    X509Parameters,
)
from .types.service import (
    ActivateCertificateAuthorityRequest,
    CreateCaPoolRequest,
    CreateCertificateAuthorityRequest,
    CreateCertificateRequest,
    CreateCertificateTemplateRequest,
    DeleteCaPoolRequest,
    DeleteCertificateAuthorityRequest,
    DeleteCertificateTemplateRequest,
    DisableCertificateAuthorityRequest,
    EnableCertificateAuthorityRequest,
    FetchCaCertsRequest,
    FetchCaCertsResponse,
    FetchCertificateAuthorityCsrRequest,
    FetchCertificateAuthorityCsrResponse,
    GetCaPoolRequest,
    GetCertificateAuthorityRequest,
    GetCertificateRequest,
    GetCertificateRevocationListRequest,
    GetCertificateTemplateRequest,
    ListCaPoolsRequest,
    ListCaPoolsResponse,
    ListCertificateAuthoritiesRequest,
    ListCertificateAuthoritiesResponse,
    ListCertificateRevocationListsRequest,
    ListCertificateRevocationListsResponse,
    ListCertificatesRequest,
    ListCertificatesResponse,
    ListCertificateTemplatesRequest,
    ListCertificateTemplatesResponse,
    OperationMetadata,
    RevokeCertificateRequest,
    UndeleteCertificateAuthorityRequest,
    UpdateCaPoolRequest,
    UpdateCertificateAuthorityRequest,
    UpdateCertificateRequest,
    UpdateCertificateRevocationListRequest,
    UpdateCertificateTemplateRequest,
)

__all__ = (
    "CertificateAuthorityServiceAsyncClient",
    "ActivateCertificateAuthorityRequest",
    "CaPool",
    "Certificate",
    "CertificateAuthority",
    "CertificateAuthorityServiceClient",
    "CertificateConfig",
    "CertificateDescription",
    "CertificateExtensionConstraints",
    "CertificateIdentityConstraints",
    "CertificateRevocationList",
    "CertificateTemplate",
    "CreateCaPoolRequest",
    "CreateCertificateAuthorityRequest",
    "CreateCertificateRequest",
    "CreateCertificateTemplateRequest",
    "DeleteCaPoolRequest",
    "DeleteCertificateAuthorityRequest",
    "DeleteCertificateTemplateRequest",
    "DisableCertificateAuthorityRequest",
    "EnableCertificateAuthorityRequest",
    "FetchCaCertsRequest",
    "FetchCaCertsResponse",
    "FetchCertificateAuthorityCsrRequest",
    "FetchCertificateAuthorityCsrResponse",
    "GetCaPoolRequest",
    "GetCertificateAuthorityRequest",
    "GetCertificateRequest",
    "GetCertificateRevocationListRequest",
    "GetCertificateTemplateRequest",
    "KeyUsage",
    "ListCaPoolsRequest",
    "ListCaPoolsResponse",
    "ListCertificateAuthoritiesRequest",
    "ListCertificateAuthoritiesResponse",
    "ListCertificateRevocationListsRequest",
    "ListCertificateRevocationListsResponse",
    "ListCertificateTemplatesRequest",
    "ListCertificateTemplatesResponse",
    "ListCertificatesRequest",
    "ListCertificatesResponse",
    "ObjectId",
    "OperationMetadata",
    "PublicKey",
    "RevocationReason",
    "RevokeCertificateRequest",
    "Subject",
    "SubjectAltNames",
    "SubjectRequestMode",
    "SubordinateConfig",
    "UndeleteCertificateAuthorityRequest",
    "UpdateCaPoolRequest",
    "UpdateCertificateAuthorityRequest",
    "UpdateCertificateRequest",
    "UpdateCertificateRevocationListRequest",
    "UpdateCertificateTemplateRequest",
    "X509Extension",
    "X509Parameters",
)
