"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const events = require("@aws-cdk/aws-events");
const defaults = require("../index");
require("@aws-cdk/assert/jest");
const aws_events_1 = require("@aws-cdk/aws-events");
const core_2 = require("@aws-cdk/core");
const utils_1 = require("../lib/utils");
test('test EventsRuleProps override ruleName and description', () => {
    const stack = new core_1.Stack();
    const lambdaFunc = {
        bind: () => ({
            id: '',
            arn: 'ARN'
        })
    };
    const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([lambdaFunc]);
    const eventsRuleProps = utils_1.overrideProps(defaultEventsRuleProps, {
        ruleName: 'test',
        description: 'hello world',
        schedule: aws_events_1.Schedule.rate(core_2.Duration.minutes(5))
    });
    new events.Rule(stack, 'Events', eventsRuleProps);
    expect(stack).toHaveResource('AWS::Events::Rule', {
        Description: "hello world",
        Name: "test",
        ScheduleExpression: "rate(5 minutes)",
        State: "ENABLED",
        Targets: [
            {
                Arn: "ARN",
                Id: "Target0"
            }
        ]
    });
});
test('test EventsRuleProps add more event targets', () => {
    const stack = new core_1.Stack();
    const lambdaFunc1 = {
        bind: () => ({
            id: '',
            arn: 'ARN1'
        })
    };
    const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([lambdaFunc1]);
    const lambdaFunc2 = {
        bind: () => ({
            id: '',
            arn: 'ARN2'
        })
    };
    const eventsRuleProps = utils_1.overrideProps(defaultEventsRuleProps, {
        targets: [lambdaFunc2],
        schedule: aws_events_1.Schedule.rate(core_2.Duration.minutes(5))
    }, true);
    new events.Rule(stack, 'Events', eventsRuleProps);
    expect(stack).toHaveResource('AWS::Events::Rule', {
        ScheduleExpression: "rate(5 minutes)",
        State: "ENABLED",
        Targets: [
            {
                Arn: "ARN1",
                Id: "Target0"
            },
            {
                Arn: "ARN2",
                Id: "Target1"
            }
        ]
    });
});
//# sourceMappingURL=data:application/json;base64,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