/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cloudfront from '@aws-cdk/aws-cloudfront';
import * as s3 from '@aws-cdk/aws-s3';
import * as api from '@aws-cdk/aws-apigateway';
import * as mediastore from '@aws-cdk/aws-mediastore';
import { Construct } from '@aws-cdk/core';
export declare function CloudFrontDistributionForApiGateway(scope: Construct, apiEndPoint: api.RestApi, cloudFrontDistributionProps?: cloudfront.DistributionProps | any, httpSecurityHeaders?: boolean): [cloudfront.Distribution, cloudfront.Function?, s3.Bucket?];
export declare function CloudFrontDistributionForS3(scope: Construct, sourceBucket: s3.IBucket, cloudFrontDistributionProps?: cloudfront.DistributionProps | any, httpSecurityHeaders?: boolean): [cloudfront.Distribution, cloudfront.Function?, s3.Bucket?];
export declare function CloudFrontDistributionForMediaStore(scope: Construct, mediaStoreContainer: mediastore.CfnContainer, cloudFrontDistributionProps?: cloudfront.DistributionProps | any, httpSecurityHeaders?: boolean): [cloudfront.Distribution, s3.Bucket | undefined, cloudfront.OriginRequestPolicy, cloudfront.Function?];
export declare function CloudFrontOriginAccessIdentity(scope: Construct, comment?: string): cloudfront.OriginAccessIdentity;
