import torch
from torch import nn

class add_coord(nn.Module):
    def __init__(self):
        super(add_coord, self).__init__()

    def forward(self, x):
        bs, ch, h, w = x.size()
        h_coord = torch.range(start=0, end=h - 1).unsqueeze(0).unsqueeze(0).unsqueeze(-1).repeat([bs, 1, 1, w]) / (
                    h / 2) - 1
        w_coord = torch.range(start=0, end=w - 1).unsqueeze(0).unsqueeze(0).unsqueeze(0).repeat([bs, 1, h, 1]) / (
                    w / 2) - 1
        x = torch.cat([x, h_coord, w_coord], dim=1)
        return x


class Coord2d(nn.Module):
    def __init__(self, in_channels, out_channels, kernel_size, stride=1, padding=0, dilation=1, groups=1, bias=True):
        """
        Coord Convolution Module
        """
        super(Coord2d, self).__init__()
        self.add_coord = add_coord()
        self.conv = nn.Conv2d(in_channels=in_channels + 2,
                              out_channels=out_channels,
                              kernel_size=kernel_size, stride=stride, padding=padding, dilation=dilation, groups=groups,
                              bias=bias)

    def forward(self, x):
        x = self.add_coord(x)
        x = self.conv(x)
        return x

def MiniBatchDiscrimination(x):
    """
    To create mini batch diversity
    applyied in discriminator in GAN
    :param x: projected (bs,hs) tensor
    :return: tensor in size (bs,hs)
    """
    bs = x.size(0)
    return -(x.unsqueeze(0).repeat([bs,1,1])-x.unsqueeze(-1).repeat([1,1,bs]).permute(0,2,1)).sum(1)