# CRVL.BAS

PROGRAM WRITTEN BY R.L.SEIFERT, TENNESSEE GAS PIPELINE COMPANY, IN MICROSOFT BASIC AND OPERABLE ON VARIOUS PERSONAL COMPUTERS.

FEBRUARY 6, 1982, MODIFIED SEPTEMBER 1984.

EVALUATE EXTERNALLY CORRODED HIGH PRESSURE GAS PIPING TO DETERMINE THE MAXIMUM PRESSURE THAT IT CAN SAFELY CONTAIN.
THIS SYSTEM WAS DEVELOPED AT BATTELLE MEMORIAL INSTITUTE, COLUMBUS OHIO.

PLEASE NOTE, THAT IF THE CORRODED SURFACE AREA EXTENDS ONTO OR ACROSS A WELD, THEN THIS METHOD IS NOT VALID.
THE CORROSION MUST THEN BE EVALUATED BY COMPANY-DESIGNATED SPECIALISTS.

COMPUTER WILL DISPLAY AN "ILLEGAL FUNCTION ERROR" IF MAOP IS SET HIGHER THAN 1.1 X P,
BECAUSE AN ATTEMPT TO FIND THE SQUARE ROOT OF A NEGATIVE NUMBER WILL RESULT.
IN PRACTICE, THE MAOP WOULD NEVER BE SET THAT HIGH.

IF MAOP IS SET SLIGHTLY BELOW 1.1 X P, AND CORROSION DEPTH IS ALMOST 10% OF WALL THICKNESS,
COMPUTER MAY CALL FOR A REDUCTION OF PRESSURE, BUT IT WILL ALSO STATE THAT THERE IS NO RESTRICTION OF OPERATION DUE TO d < 0.1t.

MAOP IS NEVER SET THAT HIGH IN PRACTICE, SO THIS SHOULD BE NO PROBLEM. THE 10% ALLOWABLE DEPTH WITH NO OPERATING RESTRICTIONS SHOULD APPLY.

IF DEPTH OR LENGTH ARE SET TO ZERO, A RESPECTIVE SAFE LENGTH OR SAFE DEPTH WILL BE DETERMINED, EVEN THOUGH THAT IS AN IMPOSSIBILITY.
REGARD THE ZEROS AS IN FINITESIMAL5 RATHER THAN ZEROS. (0 = 0.000001, FOR EXAMPLE).

IF CORROSION DEPTH (d) IS ENTERED >1.5 X WALL THICKNESS (t), THEN THE EXPRESSION (2/3 * (t/d)) WILL BE => 1.0.
THIS WILL CAUSE A "DIVISION BY ZERO" ERROR IN THE CALCULATIONS.
DEPTH OF CORROSION CAN NEVER BE > WALL THICKNESS ANYWAY.

```BASIC
72 SCREEN O,O,O:WIDTH BO:COLOR 14,1.0
75 DEFDBL A-Z

80 CLS: INPUT "MAXIMUM ALLOWABLE PRESSURE (MAOP) #/Sq.In.";M
90 INPUT "ENTER OUTSIDE DIAMETER OF PIPE (D) Inches";D
100 INPUT "ENTER PIPE WALL THICKNESS (t) Inch(es)";T
110 INPUT "ENTER STRENGTH OF STEEL (SMYS) Lbs/sq.in.";S
120 INPUT "ENTER DESIGN FACTOR (F) (.72,.60,.50,.40)";F
130 INPUT "ENTER MAXIMUM CORROSION DEPTH (d) Inch";DE
140 INPUT "MAX.LONGITDNAL, LGTH OF CORRODED AREA (L) Inches";L

150 PRINT: IF DE > 0.8 * T THEN INPUT "DEPTH OF CORROSION EXCEEDS 80% OF PIPEWALL. PIPE MUST BE REPLACED. PRESS <ENTER> FOR FURTHER EVALUATION.";EN
160 IF DE =< 0.1 * T THEN INPUT "CORROSION DEPTH IS LESS THAN 10% OF PIPE WALL. NO RESTRICTIONS ON OPERATION. PRESS <ENTER> FOR FURTHER EVALUATION.";EN

170 P = INT((2 * S * T * F / D) + 0.5)
: A = (0.B93 * L) / (D * T)^0.5
: A = (INT(1OOO * A)) * 0.001
180 IF A <= 4 THEN PS = INT(1.1 * P * ((1 - ((2 * DE) / (3 * T))) / (1 - ((2 / 3) * ( DE / (T * (A^2 + 1)^0.5 ))))) + 0.5)
190 IF A > 4 THEN PS = INT(1.1 * P * (1 - (DE / T)) + 0.5)
195 IF PS > P THEN PS = P

200 CLS:PRINT "--- INPUTTED DATA ---"
210 PRINT "PIPE DIAMETER (D) = " D " In."; "DESIGN FACTOR (F) =" F
220 PRINT "WALL THICKNESS (t) = " T " In."; "MAX.COR.DPTH (d) =" DE "In."
230 PRINT "SMYS =" S " PSI"; "MAX.COR.LBTH (L) =" L "In."
240 PRINT "MAOP =" M " PSI"

250 PRINT "-- CALCULATED DATA --"
260 PRINT "INTERMEDIATE FACTOR (A)= ";: PRINT USINB "##.###"; INT(1000 + A) * 0.001
270 PRINT "DESISN PRESS. (P) =" P " PSI"; "SAFE PRESS. (P') =" PS " PSI"

280 IF DE > 0.8 * T THEN PRINT "REPAIR OR REPLACE PIPE BECAUSE CORROSION DEPTH EXCEEDS 0.8t."
290 IF PS => M THEN PRINT "PIPE MAY BE OPERATED SAFELY AT MAOP." M "PSI"
300 IF M > P THEN PRINT "MAOP EXCEEDS DESIGN PRESSURE (P). VERIFY THAT THIS VARIANCE IS VALID."
310 IF M > PS THEN PRINT "REDUCE OPERATlNG PRESSURE SO IT WIll NOT EXCEEO" PS "PSI, SO THAT PIPE": PRINT "WILL OPERATE LEGALLV AND SAFELY."
330 IF A =< 4 THEN DP = ((M - (1.1 * P)) * ((3 * T) * ((A^2 + 1)^0.5))) / (2 * (M - (1.1 * P) * ((A^2 + 1)^0.5)))): DP = (INT(1000 * DP)) * 0.OO1
340 IF DP > 0.8 * T THEN DP = 0.8 * T
350 IF A =< 4 THEN PRINT "WITH CORR.LNGTH." L "In., MAX. DEPTH IS ";: PRINT USING "##.###"; (INT ((A * 1000) + 0.5)) * 0.001
360 IF A > 4 THEN DP = ((M / (1.1 * P)) - 1) * (-T)
370 IF DP > 0.8 * T THEN DP = 0.8 * T
38O IF A > 4 THEN PRINT "WITH CORR.LNGTH." L "In., MAX.DEPTH IS ";: PRINT USING "##.###"; (INT ((DP * 1000) + 0.5)) * 0.001;: PRINT "Inch. A = ";: PRINT USING "##.###"; (INT ((A * 1000) + 0.5)) * 0.001
390 AP = 5: PS = INT(1.1 * P * (1 - (DE / T)) + 0.5): IF PS > P THEN PS = P
400 IF M > PS THEN 420
410 PRINT "WITH CORR.DEPTH" DE "In., MAX. LENGTH IS INFINITY. A = ";: PRINT USING "##.###"; AP: GOSUB 530: GOTO 470

420 J = (2 * DE) / (3 * T)
: AP = (((J / (1 - (((1.1 * P) * (1 - J)) / M)))^2) - 1)^0.5
: AP = (INT((AP * 1000) + 0.5)) * 0.001
: PS = INT(1.1 * P *((1 - J) / (1 - ((2 / 3) * (DE / (T * AP^2 + 1)^0.5)))) + 0.5
: LP = INT(1000 * ((D * T)^0.5) * 1.12 * AP)) * 0.001
: IF PS > P THEN PS = P

430 IF PS > M OR AP > 4 THEN 450

440 PRINT "WlTH CORR.DEPTH" DE "In., MAX. LENGTH IS ";
: PRINT USING "##.###": INT(1000 * ((D * T)^0.5) * 1.12 * AP)) * 0.001;
: PRINT USING "##.###": (INT(1000 * AP)) * 0.001;
: GOSUB 530
: GOTO 478

450 AP = 4
: PS = 1.1 * P * ((1 - ((2 * DE) / (3 * T))) / (1 - ((2 / 3) * (DE / (T * (AP^2 + 1)^0.5)))))
: PS = INT(PS + 0.5)
: IF PS > P THEN PS = P

460 GOTO 440

470 PRINT: INPUT "PRESS <1> FOR MORE CORROSION EVALUATIONS ON SAME PIPE,
OR (2) FOR CORROSION EVALUATIONS ON DIFFERENT PIPE."; EN
: IF EN <> 1 THEN 20

480 CLS: PRINT "MAXlMUM ALLOWABLE OPERATING PRESSURE (MAOP) " M "#/sq.ln."
490 PRINT "OUTSIDE DIAMETER OF PIPE (D) ": D "Inches"
500 PRINT "PIPE WALL THICKNESS (t) = ": T "Inch"
510 PRINT "SPECIFIEO MIN. YIELD STRENGTH OF PIPE (SMVS) = " S "#/sq.ln."
520 PRINT "DESIGN FACTOR (F) = ": F 
: GOTO 130

530 IF DE > 0.8 * T THEN PRINT "!!! BUT" DE "Inch EXCEEDS ALLOWABLE CORROSION DEPTH !!!"
540 RETURN 
```
