# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['html2tei', 'html2tei.article_body_converters']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.9.0,<5.0.0',
 'lxml>=4.5.0,<5.0.0',
 'pyyaml>=6.0.0,<7.0.0',
 'warcio>=1.7.0,<2.0.0',
 'webarticlecurator>=1.4.0,<2.0.0']

extras_require = \
{'full': ['justext>=3.0.0,<4.0.0', 'newspaper3k>=0.2.8,<0.3.0'],
 'justext': ['justext>=3.0.0,<4.0.0'],
 'newspaper3k': ['newspaper3k>=0.2.8,<0.3.0']}

entry_points = \
{'console_scripts': ['html2tei = html2tei.__main__:main']}

setup_kwargs = {
    'name': 'html2tei',
    'version': '1.2.3',
    'description': 'Map the HTML schema of portals to valid TEI XML with the tags and structures used in them using small manual portal-specific configurations.',
    'long_description': '# HTML2TEI\n\nMap the HTML schema of portals to valid [TEI XML](https://tei-c.org/) with the tags and structures used in them using\n small manual portal-specific configurations.\n\nThe portal-specific configuration is created manually with the help of three different tools which aid evaluating\n the inventory of the tags and structures used in the HTML code. The manual evaluation of such structures\n enables one to create a valid TEI XML from the HTML source keeping all desired (text) schema elements\n in a fine-grained way carefully supervised by the user. In addition to converting the article body,\n the metadata can be converted to the [Schema.org](https://schema.org/) standard.\n\nThe conversion process is automatic and scales well on large portals with the same schema\n\n## Requirements\n\n- Python 3.8+\n- For Newspaper3k, the installation of the following packages must precede the installation of this program:\n  `python3-dev libxml2-dev libxslt-dev libjpeg-dev zlib1g-dev libpng12-dev`\n\n## Install\n\n### pip\n\n`pip3 install html2tei`\n\n### Manual\n\n1. `git clone https://github.com/ELTE-DH/HTML2TEI.git`\n2. Run `make venv build install`\n\n## Usage\n\nThis program is designed to be used with [WebArticleCurator](https://github.com/elte-dh/WebArticleCurator/).\nThe article WARC files should be placed in a directory (`warc-dir`) and a configuration YAML must\n map the WARC files to the specific portal configuration.\nThe program can be run from command line or from the Python API see the details below \n\n### Modes\n\nThere are five modes of the program:\n\n- Create _HTML Content Tree_ (`content-tree`): Read all the articles to summarize all the structures that occur\n  in the portal schema. Finally, the accumulated information represents the tree structure as a nested YAML dictionary\n  (for manual inspection)\n- The _Tag Inventory Maker_ (`inventory-maker`): Create the tag tables from the articles with their\n  gathered information (it will be the basis for manual configuration of renaming)\n- The _Tag Bigrams Maker_ (`bigram-maker`): Create the bigram tag table from the articles with their\n  gathered information (this table is an add-on that can be used to map the schema)\n- The _Portal Article Cleaner_ (`cleaner`): Create the TEI XMLs from the site-specific configuration and\n  from the tables supplemented with new label names\n- _Diff Tag Tables_ (`diff-tables`): Compare and update the generated (and modified) tables if there are new data\n  for the same portal\n\n### Command Line Arguments \n\n#### Common Arguments\n\n- `-i`, `--input-config`: WARC filename to portal name mapping in YAML\n- `-c`, `--configs-dir`: The directory for portal-specific configs\n- `-l`, `--log-dir`: The directory for putting logs\n- `-w`, `--warc-dir`: The directory to read WARCs from\n- `-o`, `--output-dir`: The directory to put output files\n- `-L`, `--log-level`: Log verbosity level (default: INFO)\'\n\nThe files and directories must present. All arguments except `log-level` are mandatory for the following four modes\n\n#### HTML Content Tree (`content-tree`)\n\n- `-t`, `--task-name`: The name of the task to appear in the logs (default: HTML Content Tree)\n\n#### Tag Inventory Maker (`inventory-maker`)\n\n- `-t`, `--task-name`: The name of the task to appear in the logs (default: Tag Inventory Maker)\n- `-r`, `--recursive`: Use just direct descendants or all (default: True)\n\n#### Tag Bigrams Maker (`bigram-maker`)\n\n- `-t`, `--task-name`: The name of the task to appear in the logs (default: Tag Bigrams Maker)\n- `-r`, `--recursive`: Use just direct descendants or all (default: True)\n\n#### Portal Article Cleaner (`cleaner`)\n\n- `-m`, `--write-out-mode`: The schema removal tool to use (ELTEDH, JusText, Newspaper3k) (default: eltedh)\n- `-t`, `--task-name`: The name of the task to appear in the logs (default: Portal Article Cleaner)\n- `-O`, `--output-debug`: Normal output generation (validate-hash-compress and UUID file names) or print into\n  the output directory without validation using human-friendly names (default: False, normal output)\n- `-p`, `--run-parallel`: Run processing in parallel or all operation must be used sequentially\n  (default: True, parallel)\n- `-d`, `--with-specific-dicts`: Load portal-specific dictionaries (tables) (default: True)\n- `-b`, `--with-specific-base-tei`: Load portal-specific base TEI XML (default: True)\n\n#### Diff Tag Tables (`diff-tables`)\n\n- `--diff-dir`: The directory which contains the directories\n- `--old-filename`: The filename for the old table \n- `--new-filename`: The filename for the new table\n- `--merge-filename`: The filename for the merged table\n\n### Python API\n\n#### Helper functions for the Configs\n\n- `parse_date(date_raw, date_format, locale=\'hu_HU.UTF-8\')`: Parse date according to the parameters\n  (locale and date format) \n- `BASIC_LINK_ATTRS`: A basic list of html tags that contain attributes to preserve. It can be overwritten based on\n  the set of the given portal\n- `decompose_listed_subtrees_and_mark_media_descendants(article_dec, decomp, media_list)`: \n  Mark the lower level of the media blocks and delete tags to be deleted\n- `tei_defaultdict(mandatory_keys=(\'sch:url\', \'sch:name\'), missing_value=None)`:\n  Create a defaultdict preinitialized with the mandatory Schema.org keys set to default\n\n# For the Main Python API\n\n- `run_main(warc_filename, configs_dir, log_dir, warc_dir, output_dir, init_portal_fun,\n            run_params=None, logfile_level=\'INFO\', console_level=\'INFO\')`: Main runner function\n- `WRITE_OUT_MODES`: A dictionary to add custom write-out modes when needed\n- `diff_all_tag_table(diff_dir, old_filename, new_filename, out_filename)`: The main function to update tables\n- `tag_bigrams_init_portal(log_dir, output_dir, run_params, portal_name, tei_logger, warc_level_params,\n                           rest_config_params)`: The portal initator function as called from CLI argument\n- `content_tree_init_portal(log_dir, output_dir, run_params, portal_name, tei_logger, warc_level_params,\n                            rest_config_params)`: The portal initator function as called from CLI argument\n- `tag_inventory_init_portal(log_dir, output_dir, run_params, portal_name, tei_logger, warc_level_params,\n                             rest_config_params)`: The portal initator function as called from CLI argument\n- `portal_article_cleaner_init_portal(log_dir, output_dir, run_params, portal_name, tei_logger, warc_level_params,\n                                      rest_config_params)`: The portal initator function as called from CLI argument\n\n# For the Low-level API: Defining Custom Modes\n\n- `init_output_writer(output_dir, portal_name, output_debug, tei_logger)`: Initialises the class for writing output\n  (into a zipfile or a directory)\n- `create_new_tag_with_string(beauty_xml, tag_string, tag_name, append_to=None)`: Helper function to create\n  a new XML tag containing string in it. If provided append the newly created tag to a parent tag\n- `immediate_text(tag)`: Count the number of words (non-whitespace text) immediately under\n  the parameter tag excluding comments\n- `to_friendly(ch, excluded_tags_fun)`: Convert tag name and sorted attributes to string in order to use it later\n  (e.g. tag_freezer in the tables)\n- `run_single_process(warc_filename, file_names_and_modes, main_function, sub_functions, after_function, after_params)`:\n  Read a WARC file and sequentially process all articles in it with main_function (multi-page articles are handled\n  as one entry) and yield the result after filtered through `after_function`\n- `run_multiple_process(warc_filename, file_names_and_modes, main_function, sub_functions, after_function,\n  after_params)`: Read a WARC file and sequentially process all articles in it with main_function in parallel preserving\n  ordering (multi-page articles are handled as one entry) and yield the result after filtered through `after_function`\n- `dummy_fun(*_)`: A function always returns None no matter how many arguments were given\n- `process_article`: A generic article processing skeleton used by multiple targets\n\n# Licence\n\nThis project is licensed under the terms of the GNU LGPL 3.0 license.\n\n# References\n\nThe DOI of the code is: TODO\n\nIf you use this program, please cite the following paper:\n\n[__The ELTE.DH Pilot Corpus – Creating a Handcrafted Gigaword Web Corpus with Metadata__ Balázs Indig, Árpád Knap, \nZsófia Sárközi-Lindner, Mária Timári, Gábor Palkó _In the Proceedings of the 12th Web as Corpus Workshop (WAC XII)_,\npages 33-41 Marseille, France 2020](https://www.aclweb.org/anthology/2020.wac-1.5.pdf)\n\n```\n@inproceedings{indig-etal-2020-elte,\n    title = "The {ELTE}.{DH} Pilot Corpus {--} Creating a Handcrafted {G}igaword Web Corpus with Metadata",\n    author = {Indig, Bal{\\\'a}zs  and\n      Knap, {\\\'A}rp{\\\'a}d  and\n      S{\\\'a}rk{\\"o}zi-Lindner, Zs{\\\'o}fia  and\n      Tim{\\\'a}ri, M{\\\'a}ria  and\n      Palk{\\\'o}, G{\\\'a}bor},\n    booktitle = "Proceedings of the 12th Web as Corpus Workshop",\n    month = may,\n    year = "2020",\n    address = "Marseille, France",\n    publisher = "European Language Resources Association",\n    url = "https://www.aclweb.org/anthology/2020.wac-1.5",\n    pages = "33--41",\n    abstract = "In this article, we present the method we used to create a middle-sized corpus using\n     targeted web crawling. Our corpus contains news portal articles along with their metadata, that can be useful\n     for diverse audiences, ranging from digital humanists to NLP users. The method presented in this paper applies\n     rule-based components that allow the curation of the text and the metadata content. The curated data can thereon\n     serve as a reference for various tasks and measurements. We designed our workflow to encourage modification and\n     customisation. Our concept can also be applied to other genres of portals by using the discovered patterns\n     in the architecture of the portals. We found that for a systematic creation or extension of a similar corpus,\n     our method provides superior accuracy and ease of use compared to The Wayback Machine, while requiring minimal\n     manpower and computational resources. Reproducing the corpus is possible if changes are introduced\n     to the text-extraction process. The standard TEI format and Schema.org encoded metadata is used\n     for the output format, but we stress that placing the corpus in a digital repository system is recommended\n     in order to be able to define semantic relations between the segments and to add rich annotation.",\n    language = "English",\n    ISBN = "979-10-95546-68-9",\n}\n```\n',
    'author': 'dlazesz',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ELTE-DH/HTML2TEI',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
