## Tools Overview

**Tools** allow an assistant to interact directly with external systems, data sources, or perform specific tasks in the real world. For example, a tool could enable interactions with a developer-defined database, API, or service.

There are two distinct categories of tools:

- **Core Platform Tools** (commonly referred to as "tools"): These are built-in functionalities provided by the assistant platform itself.
- **Developer-defined Tools** (commonly known as "function calls"): These are custom extensions created by developers to augment the assistant's capabilities according to specific application needs.


### Platform Tools
| Tool                 | Description                                                                                                                      |
|----------------------|----------------------------------------------------------------------------------------------------------------------------------|
| **computer**         | The assistant has use of a Linux computer connected to the internet. Very powerful.                                              |
| **waves**            | The assistant has access to a vectorized database that acts as long-term memory, document parsing, and cross-conversation recall.|
| **web_search**       | The assistant can use a search engine and other aggregated content on the internet to synthesize responses.                      |
| **file_search**      | The assistant can search, retrieve, and utilize files stored within its accessible storage systems.                              |
| **code_interpreter** | The assistant can execute arbitrary Python code, draft documents, and perform data analysis in a secure sandbox environment.     |



**Attach a tool to an assistant**

Platform tools work on an opt in basis.

```python




assistant = client.assistant_service.create_assistant(
                name='Mathy',
                description='Test assistant',
                model=model,
                instructions='You are an AI assistant',
                assistant_id="id_123",
                tools=[{"type":"code_interpreter"}]


            )


```

No further code needed, platform will now handle the code_interpreter tool lifecycle and future development,


