import * as cw from '@aws-cdk/aws-cloudwatch';
import { Construct } from '@aws-cdk/core';
import { Watchful } from 'cdk-watchful';
import { AlarmActions } from '../api';
import { IMonitoring } from './api';
/**
 * Props for the monitoring construct.
 */
export interface MonitoringProps {
    /**
     * ARNs of alarm actions to take for various severities.
     */
    readonly alarmActions?: AlarmActions;
}
/**
 * Construct hub monitoring.
 *
 * This construct uses cdk-watchful to automatically generate a dashboard and a
 * set of standard alarms for common resources.
 *
 * Components should use the APIs of this module to add watchful monitors,
 * and add canaries and alarms as needed.
 */
export declare class Monitoring extends Construct implements IMonitoring {
    private alarmActions?;
    /**
     * Allows adding automatic monitoring to standard resources. Note that
     * watchful alarms are always treated as _normal_ severity. You can add
     * high-severity alarm via `addHighSeverityAlarm()`.
     */
    readonly watchful: Watchful;
    private readonly highSeverityDashboard;
    constructor(scope: Construct, id: string, props?: MonitoringProps);
    /**
     * Adds a high-severity alarm. If this alarm goes off, the action specified in `highSeverityAlarmActionArn`
     * @param alarm
     */
    addHighSeverityAlarm(title: string, alarm: cw.Alarm): void;
    addLowSeverityAlarm(_title: string, alarm: cw.Alarm): void;
    /**
     * Adds a canary that pings a certain URL and raises an alarm in case the URL
     * responds with an error over 80% of the times.
     *
     * Canary failures are always considered high-severity (at this point).
     *
     * @param name The name of the canary
     * @param url The URL to ping
     */
    addWebCanary(name: string, url: string): void;
}
