/// <reference types="node" />
export interface CodeArtifactProps {
    /**
     * The endpoint for the CodeArtifact NPM registry. It is a complete URL
     * (including protocol, and path).
     */
    readonly endpoint: string;
    /**
     * The name of the CodeArtifact domain that contains the NPM registry.
     */
    readonly domain: string;
    /**
     * The owner of the CodeArtifact domain that contains the NPM registry.
     */
    readonly domainOwner?: string;
    /**
     * The CodeArtifact API endpoints to be used (e.g: VPC Endpoints).
     */
    readonly apiEndpoint?: string;
}
/**
 * Logs into the provided CodeArtifact registry, and makes it the default NPM
 * registry for this environment.
 */
export declare function logInWithCodeArtifact({ endpoint, domain, domainOwner, apiEndpoint }: CodeArtifactProps): Promise<void>;
/**
 * Publishes the provided tarball to the specified CodeArtifact repository.
 *
 * @param tarball a Buffer containing the tarball for the published package.
 * @param opts    the informations about the CodeArtifact repository.
 */
export declare function codeArtifactPublishPackage(tarball: Buffer, opts: CodeArtifactProps): Promise<void>;
