#!/usr/bin/env python

from distutils.core import setup

setup(**{'name': 'MDocument', 'version': '1.0.1584884718', 'description': 'Simple DRM for motor client', 'author': 'Yurzs', 'author_email': 'yurzs+MDocument@yurzs.dev', 'packages': ['MDocument'], 'install_requires': ['motor'], 'license': 'MIT', 'keywords': ['mongo', 'motor', 'Document', 'ORM'], 'url': 'https://git.yurzs.dev/yurzs/MDocument', 'classifiers': ['Development Status :: 3 - Alpha', 'License :: OSI Approved :: MIT License', 'Programming Language :: Python :: 3.6', 'Programming Language :: Python :: 3.7', 'Programming Language :: Python :: 3.8'], 'long_description': 'MDocument\n=========\n\nSimple DRM for async mongo motor client\n\nUsage\n-----\n\n.. code-block:: python\n\n    import asyncio\n\n    from MDocument import Document\n\n    class Comment(Document):\n        __collection__ = "comments"\n\n\n    class Video(Document):\n        __collection__ = "videos"\n\n        @Document.related(self_field="_id", other_field="video")\n        def comments(self):\n            return Comment\n\n\n    loop = asyncio.get_event_loop()\n    Document.setup(loop, "localhost", "test_database")\n\n    async def main():\n        video = await Video.create(\n            title="Test",\n        )\n\n        comment1 = await Comment.create(\n            video=video._id,\n            message="First!",\n        )\n\n        comment2 = await Comment.create(\n            video=video._id,\n            message="Second!"\n        )\n\n    loop.run_until_complete(main())\n\nNow we can easily access our comments using our related documents\n\n.. code-block:: python\n\n    print(await video.comments)\n    [\n        Comment(_id=5e7533d55eb6a8c6d24d3cc7, video=5e7533d55eb6a8c6d24d3cc6, message=First!),\n        Comment(_id=5e7533d55eb6a8c6d24d3cc8, video=5e7533d55eb6a8c6d24d3cc6, message=Second!)\n    ]\n\nPlay from console\n-----------------\n\nIf you want changes made from console immediately you can use `update_immediately` argument\n\n.. code-block:: python\n\n    run = loop.run_until_complete\n\n    video = run(Video.create(update_immediately=True,\n        title="Test"))\n    video.length = "1:10"\n\nNow we can find that original document was changed\n\n.. code-block:: python\n\n    print(run(Video.collection.find_one({"length": "1:10"})))\n    {\'_id\': ObjectId(\'5e75373e5eb6a8c6d24d3cce\'), \'title\': \'Test\', \'length\': \'1:10\'}\n\n\nDocument methods\n================\n\nHere is a list of Document basic methods\n\n.create\n-------\n.. code-block:: python\n\n    async def create(cls, loop=None, update_immediately=False, **kwargs):\n\nIf you want to create a new document you can do it easily with .create method.\nExample:\n\n.. code-block:: python\n\n    import asyncio\n\n    from MDocument import Document\n\n\n    class Message(Document):\n        __collection__ = "messages"\n\n    Document.setup(loop, "localhost", "test_database")\n\n    loop.run_until_complete(\n        Message.create(from_user="admin", text="Test message!")\n    )\n\nThis will create document in database:\n\n.. code-block:: python\n\n    {\n        \'_id\': ObjectId(\'5e75373e5eb6a8c6d14d3ccd\'),\n        \'from_user\': \'admin\',\n        \'text\': "Test message!"\n    }\n\n.delete\n-------\n\nDeletion of document from database. Based on your set @related rules all related documents will be modified too.\n\n.. code-block:: python\n\n    message = await Message.one(from_user="admin")\n\n    await message.delete()\n\n'})