import { CodeDeploy } from "../CodeDeploy";
import { CodeDeployClient } from "../CodeDeployClient";
import { ListDeploymentGroupsCommand, } from "../commands/ListDeploymentGroupsCommand";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListDeploymentGroupsCommand(input), ...args);
};
const makePagedRequest = async (client, input, ...args) => {
    return await client.listDeploymentGroups(input, ...args);
};
export async function* paginateListDeploymentGroups(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.nextToken = token;
        if (config.client instanceof CodeDeploy) {
            page = await makePagedRequest(config.client, input, ...additionalArguments);
        }
        else if (config.client instanceof CodeDeployClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CodeDeploy | CodeDeployClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
