"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeDeploy = void 0;
const CodeDeployClient_1 = require("./CodeDeployClient");
const AddTagsToOnPremisesInstancesCommand_1 = require("./commands/AddTagsToOnPremisesInstancesCommand");
const BatchGetApplicationRevisionsCommand_1 = require("./commands/BatchGetApplicationRevisionsCommand");
const BatchGetApplicationsCommand_1 = require("./commands/BatchGetApplicationsCommand");
const BatchGetDeploymentGroupsCommand_1 = require("./commands/BatchGetDeploymentGroupsCommand");
const BatchGetDeploymentInstancesCommand_1 = require("./commands/BatchGetDeploymentInstancesCommand");
const BatchGetDeploymentsCommand_1 = require("./commands/BatchGetDeploymentsCommand");
const BatchGetDeploymentTargetsCommand_1 = require("./commands/BatchGetDeploymentTargetsCommand");
const BatchGetOnPremisesInstancesCommand_1 = require("./commands/BatchGetOnPremisesInstancesCommand");
const ContinueDeploymentCommand_1 = require("./commands/ContinueDeploymentCommand");
const CreateApplicationCommand_1 = require("./commands/CreateApplicationCommand");
const CreateDeploymentCommand_1 = require("./commands/CreateDeploymentCommand");
const CreateDeploymentConfigCommand_1 = require("./commands/CreateDeploymentConfigCommand");
const CreateDeploymentGroupCommand_1 = require("./commands/CreateDeploymentGroupCommand");
const DeleteApplicationCommand_1 = require("./commands/DeleteApplicationCommand");
const DeleteDeploymentConfigCommand_1 = require("./commands/DeleteDeploymentConfigCommand");
const DeleteDeploymentGroupCommand_1 = require("./commands/DeleteDeploymentGroupCommand");
const DeleteGitHubAccountTokenCommand_1 = require("./commands/DeleteGitHubAccountTokenCommand");
const DeleteResourcesByExternalIdCommand_1 = require("./commands/DeleteResourcesByExternalIdCommand");
const DeregisterOnPremisesInstanceCommand_1 = require("./commands/DeregisterOnPremisesInstanceCommand");
const GetApplicationCommand_1 = require("./commands/GetApplicationCommand");
const GetApplicationRevisionCommand_1 = require("./commands/GetApplicationRevisionCommand");
const GetDeploymentCommand_1 = require("./commands/GetDeploymentCommand");
const GetDeploymentConfigCommand_1 = require("./commands/GetDeploymentConfigCommand");
const GetDeploymentGroupCommand_1 = require("./commands/GetDeploymentGroupCommand");
const GetDeploymentInstanceCommand_1 = require("./commands/GetDeploymentInstanceCommand");
const GetDeploymentTargetCommand_1 = require("./commands/GetDeploymentTargetCommand");
const GetOnPremisesInstanceCommand_1 = require("./commands/GetOnPremisesInstanceCommand");
const ListApplicationRevisionsCommand_1 = require("./commands/ListApplicationRevisionsCommand");
const ListApplicationsCommand_1 = require("./commands/ListApplicationsCommand");
const ListDeploymentConfigsCommand_1 = require("./commands/ListDeploymentConfigsCommand");
const ListDeploymentGroupsCommand_1 = require("./commands/ListDeploymentGroupsCommand");
const ListDeploymentInstancesCommand_1 = require("./commands/ListDeploymentInstancesCommand");
const ListDeploymentsCommand_1 = require("./commands/ListDeploymentsCommand");
const ListDeploymentTargetsCommand_1 = require("./commands/ListDeploymentTargetsCommand");
const ListGitHubAccountTokenNamesCommand_1 = require("./commands/ListGitHubAccountTokenNamesCommand");
const ListOnPremisesInstancesCommand_1 = require("./commands/ListOnPremisesInstancesCommand");
const ListTagsForResourceCommand_1 = require("./commands/ListTagsForResourceCommand");
const PutLifecycleEventHookExecutionStatusCommand_1 = require("./commands/PutLifecycleEventHookExecutionStatusCommand");
const RegisterApplicationRevisionCommand_1 = require("./commands/RegisterApplicationRevisionCommand");
const RegisterOnPremisesInstanceCommand_1 = require("./commands/RegisterOnPremisesInstanceCommand");
const RemoveTagsFromOnPremisesInstancesCommand_1 = require("./commands/RemoveTagsFromOnPremisesInstancesCommand");
const SkipWaitTimeForInstanceTerminationCommand_1 = require("./commands/SkipWaitTimeForInstanceTerminationCommand");
const StopDeploymentCommand_1 = require("./commands/StopDeploymentCommand");
const TagResourceCommand_1 = require("./commands/TagResourceCommand");
const UntagResourceCommand_1 = require("./commands/UntagResourceCommand");
const UpdateApplicationCommand_1 = require("./commands/UpdateApplicationCommand");
const UpdateDeploymentGroupCommand_1 = require("./commands/UpdateDeploymentGroupCommand");
class CodeDeploy extends CodeDeployClient_1.CodeDeployClient {
    addTagsToOnPremisesInstances(args, optionsOrCb, cb) {
        const command = new AddTagsToOnPremisesInstancesCommand_1.AddTagsToOnPremisesInstancesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchGetApplicationRevisions(args, optionsOrCb, cb) {
        const command = new BatchGetApplicationRevisionsCommand_1.BatchGetApplicationRevisionsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchGetApplications(args, optionsOrCb, cb) {
        const command = new BatchGetApplicationsCommand_1.BatchGetApplicationsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchGetDeploymentGroups(args, optionsOrCb, cb) {
        const command = new BatchGetDeploymentGroupsCommand_1.BatchGetDeploymentGroupsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchGetDeploymentInstances(args, optionsOrCb, cb) {
        const command = new BatchGetDeploymentInstancesCommand_1.BatchGetDeploymentInstancesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchGetDeployments(args, optionsOrCb, cb) {
        const command = new BatchGetDeploymentsCommand_1.BatchGetDeploymentsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchGetDeploymentTargets(args, optionsOrCb, cb) {
        const command = new BatchGetDeploymentTargetsCommand_1.BatchGetDeploymentTargetsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchGetOnPremisesInstances(args, optionsOrCb, cb) {
        const command = new BatchGetOnPremisesInstancesCommand_1.BatchGetOnPremisesInstancesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    continueDeployment(args, optionsOrCb, cb) {
        const command = new ContinueDeploymentCommand_1.ContinueDeploymentCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createApplication(args, optionsOrCb, cb) {
        const command = new CreateApplicationCommand_1.CreateApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createDeployment(args, optionsOrCb, cb) {
        const command = new CreateDeploymentCommand_1.CreateDeploymentCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createDeploymentConfig(args, optionsOrCb, cb) {
        const command = new CreateDeploymentConfigCommand_1.CreateDeploymentConfigCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createDeploymentGroup(args, optionsOrCb, cb) {
        const command = new CreateDeploymentGroupCommand_1.CreateDeploymentGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteApplication(args, optionsOrCb, cb) {
        const command = new DeleteApplicationCommand_1.DeleteApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteDeploymentConfig(args, optionsOrCb, cb) {
        const command = new DeleteDeploymentConfigCommand_1.DeleteDeploymentConfigCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteDeploymentGroup(args, optionsOrCb, cb) {
        const command = new DeleteDeploymentGroupCommand_1.DeleteDeploymentGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteGitHubAccountToken(args, optionsOrCb, cb) {
        const command = new DeleteGitHubAccountTokenCommand_1.DeleteGitHubAccountTokenCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteResourcesByExternalId(args, optionsOrCb, cb) {
        const command = new DeleteResourcesByExternalIdCommand_1.DeleteResourcesByExternalIdCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deregisterOnPremisesInstance(args, optionsOrCb, cb) {
        const command = new DeregisterOnPremisesInstanceCommand_1.DeregisterOnPremisesInstanceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getApplication(args, optionsOrCb, cb) {
        const command = new GetApplicationCommand_1.GetApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getApplicationRevision(args, optionsOrCb, cb) {
        const command = new GetApplicationRevisionCommand_1.GetApplicationRevisionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getDeployment(args, optionsOrCb, cb) {
        const command = new GetDeploymentCommand_1.GetDeploymentCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getDeploymentConfig(args, optionsOrCb, cb) {
        const command = new GetDeploymentConfigCommand_1.GetDeploymentConfigCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getDeploymentGroup(args, optionsOrCb, cb) {
        const command = new GetDeploymentGroupCommand_1.GetDeploymentGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getDeploymentInstance(args, optionsOrCb, cb) {
        const command = new GetDeploymentInstanceCommand_1.GetDeploymentInstanceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getDeploymentTarget(args, optionsOrCb, cb) {
        const command = new GetDeploymentTargetCommand_1.GetDeploymentTargetCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getOnPremisesInstance(args, optionsOrCb, cb) {
        const command = new GetOnPremisesInstanceCommand_1.GetOnPremisesInstanceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listApplicationRevisions(args, optionsOrCb, cb) {
        const command = new ListApplicationRevisionsCommand_1.ListApplicationRevisionsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listApplications(args, optionsOrCb, cb) {
        const command = new ListApplicationsCommand_1.ListApplicationsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listDeploymentConfigs(args, optionsOrCb, cb) {
        const command = new ListDeploymentConfigsCommand_1.ListDeploymentConfigsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listDeploymentGroups(args, optionsOrCb, cb) {
        const command = new ListDeploymentGroupsCommand_1.ListDeploymentGroupsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listDeploymentInstances(args, optionsOrCb, cb) {
        const command = new ListDeploymentInstancesCommand_1.ListDeploymentInstancesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listDeployments(args, optionsOrCb, cb) {
        const command = new ListDeploymentsCommand_1.ListDeploymentsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listDeploymentTargets(args, optionsOrCb, cb) {
        const command = new ListDeploymentTargetsCommand_1.ListDeploymentTargetsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listGitHubAccountTokenNames(args, optionsOrCb, cb) {
        const command = new ListGitHubAccountTokenNamesCommand_1.ListGitHubAccountTokenNamesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listOnPremisesInstances(args, optionsOrCb, cb) {
        const command = new ListOnPremisesInstancesCommand_1.ListOnPremisesInstancesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listTagsForResource(args, optionsOrCb, cb) {
        const command = new ListTagsForResourceCommand_1.ListTagsForResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putLifecycleEventHookExecutionStatus(args, optionsOrCb, cb) {
        const command = new PutLifecycleEventHookExecutionStatusCommand_1.PutLifecycleEventHookExecutionStatusCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    registerApplicationRevision(args, optionsOrCb, cb) {
        const command = new RegisterApplicationRevisionCommand_1.RegisterApplicationRevisionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    registerOnPremisesInstance(args, optionsOrCb, cb) {
        const command = new RegisterOnPremisesInstanceCommand_1.RegisterOnPremisesInstanceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    removeTagsFromOnPremisesInstances(args, optionsOrCb, cb) {
        const command = new RemoveTagsFromOnPremisesInstancesCommand_1.RemoveTagsFromOnPremisesInstancesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    skipWaitTimeForInstanceTermination(args, optionsOrCb, cb) {
        const command = new SkipWaitTimeForInstanceTerminationCommand_1.SkipWaitTimeForInstanceTerminationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    stopDeployment(args, optionsOrCb, cb) {
        const command = new StopDeploymentCommand_1.StopDeploymentCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    tagResource(args, optionsOrCb, cb) {
        const command = new TagResourceCommand_1.TagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    untagResource(args, optionsOrCb, cb) {
        const command = new UntagResourceCommand_1.UntagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateApplication(args, optionsOrCb, cb) {
        const command = new UpdateApplicationCommand_1.UpdateApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateDeploymentGroup(args, optionsOrCb, cb) {
        const command = new UpdateDeploymentGroupCommand_1.UpdateDeploymentGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
}
exports.CodeDeploy = CodeDeploy;
