"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logger = void 0;
class Logger {
    constructor() {
        this.persistentAttributes = {};
    }
    info(message, ...attributes) {
        process.stdout.write(this.formatMessage(message, { level: 'INFO' }, ...attributes) + '\n');
    }
    warn(message, ...attributes) {
        process.stdout.write(this.formatMessage(message, { level: 'WARN' }, ...attributes) + '\n');
        //console.log(this.formatMessage(message, {level: 'WARN'}, ...attributes));
    }
    error(message, ...attributes) {
        process.stdout.write(this.formatMessage(message, { level: 'ERROR' }, ...attributes) + '\n');
        //console.log(this.formatMessage(message, {level: 'ERROR'}, ...attributes));
    }
    appendKeys(attributes) {
        this.persistentAttributes = { ...this.persistentAttributes, ...attributes };
    }
    formatMessage(message, ...attributes) {
        const formattedMessage = [this.persistentAttributes, ...attributes].reduce((combined, current) => {
            return { ...combined, ...current };
        }, { message });
        return JSON.stringify(formattedMessage);
    }
}
exports.Logger = Logger;
//# sourceMappingURL=data:application/json;base64,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