This report contains the security assessment results from Cloudsplaining, which maps out the IAM risk landscape in a report, identifies where resource ARN constraints are not used, and identifies other risks in IAM policies like Privilege Escalation<a href="#definition-privilege-escalation"><small>[1]</small></a>,  Resource Exposure<a href="#definition-resource-exposure"><small>[2]</small></a>, Infrastructure Modification<a href="#definition-infrastructure-modification"><small>[3]</small></a>, and Data Exfiltration<a href="#definition-data-exfiltration"><small>[4]</small></a>.
  Remediating these issues, where necessary, will help to limit the blast radius in the case of compromised AWS credentials.

These policies do not practice the principle of least privilege by leveraging resource ARN constraints where possible.

For example, `s3:PutObject` should be restricted to a specific bucket and object path - such as Resource: `arn:aws:s3:::my-bucket/path/*`. IAM Resource ARN constraints are preferable to allowing access to all resources, like `"Resource": "*"`, which would allow the IAM principal to upload an S3 object to any bucket at any path.

This security control is not just limited to the context of S3, however. Other IAM actions, such as `s3:PutObject`, `iam:PassRole`, and `ssm:GetParameter` should always be scoped down to only the resources that they need access to. In the case of a compromise, overly permissive IAM policies can lead to the compromised principal having access to more resources than necessary, which can result in data exfiltration or other damaging post-exploitation activities. To limit the blast radius of compromised credentials, it is imperative to restrict access to only the IAM actions and resource ARNs that are necessary for the IAM principal to function properly.
