"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const bundling_1 = require("../lib/bundling");
jest.mock('@aws-cdk/aws-lambda');
const existsSyncOriginal = fs.existsSync;
const existsSyncMock = jest.spyOn(fs, 'existsSync');
beforeEach(() => {
    jest.clearAllMocks();
});
test('Bundling', () => {
    bundling_1.bundle({
        entry: '/project/folder',
        runtime: aws_lambda_1.Runtime.PYTHON_3_7,
    });
    // Correctly bundles
    expect(aws_lambda_1.Code.fromAsset).toHaveBeenCalledWith('/project/folder', {
        bundling: expect.objectContaining({
            command: [
                'bash', '-c',
                'rsync -r . /asset-output',
            ],
        }),
    });
    // Searches for requirements.txt in entry
    expect(existsSyncMock).toHaveBeenCalledWith('/project/folder/requirements.txt');
});
test('Bundling with requirements.txt installed', () => {
    existsSyncMock.mockImplementation((p) => {
        if (/requirements.txt/.test(p.toString())) {
            return true;
        }
        return existsSyncOriginal(p);
    });
    bundling_1.bundle({
        entry: '/project/folder',
        runtime: aws_lambda_1.Runtime.PYTHON_3_7,
    });
    // Correctly bundles with requirements.txt pip installed
    expect(aws_lambda_1.Code.fromAsset).toHaveBeenCalledWith('/project/folder', {
        bundling: expect.objectContaining({
            command: [
                'bash', '-c',
                'pip3 install -r requirements.txt -t /asset-output && rsync -r . /asset-output',
            ],
        }),
    });
});
test('Bundling Python 2.7 with requirements.txt installed', () => {
    existsSyncMock.mockImplementation((p) => {
        if (/requirements.txt/.test(p.toString())) {
            return true;
        }
        return existsSyncOriginal(p);
    });
    bundling_1.bundle({
        entry: '/project/folder',
        runtime: aws_lambda_1.Runtime.PYTHON_2_7,
    });
    // Correctly bundles with requirements.txt pip installed
    expect(aws_lambda_1.Code.fromAsset).toHaveBeenCalledWith('/project/folder', {
        bundling: expect.objectContaining({
            command: [
                'bash', '-c',
                'pip install -r requirements.txt -t /asset-output && rsync -r . /asset-output',
            ],
        }),
    });
});
//# sourceMappingURL=data:application/json;base64,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