from typing import cast
from ..base import RESTManager, RESTObject, RequiredOptional
from ..mixin import GetMixin, CreateMixin, UpdateMixin, SaveMixin, ListMixin
from ..utils import handle_client_exception


__all__ = [
    "Pointer",
    "PointerManager",
]


class Pointer(SaveMixin, RESTObject):
    _id_attr = "uid"
    # pass


# NOTE: even tho Delete Mixin is integrated, since pointer is a look up table,
# our API does not support DELETE for it
class PointerManager(GetMixin, CreateMixin, UpdateMixin, ListMixin, RESTManager):
    _path = "benchmarks/pointer"
    _obj_cls = Pointer
    _create_attrs = RequiredOptional(required=("name",)) 
    #TODO: figure out if the auth section should be passed in here, 

    def get(self, uid=None, params=None):
        # NOTE: the casting allows each object to follow the logic implemented in the
        # MIXIN utils w/o the need to repeating it each time. it also allows customization
        # in each obj
        return cast(Pointer, super(PointerManager, self).get(uid=uid, params=params))


