# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['integration_abstraction',
 'kle',
 'mox_helpers',
 'os2mo_data_import',
 'os2mo_helpers',
 'os2mo_helpers.tests']

package_data = \
{'': ['*']}

install_requires = \
['XlsxWriter>=3.0.3,<4.0.0',
 'aiohttp>=3.8.1,<4.0.0',
 'anytree>=2.8.0,<3.0.0',
 'certifi>=2021.10.8,<2022.0.0',
 'chardet>=4.0.0,<5.0.0',
 'click>=8.0.4,<9.0.0',
 'idna>=3.3,<4.0',
 'more-itertools>=8.12.0,<9.0.0',
 'openpyxl>=3.0.9,<4.0.0',
 'requests>=2.27.1,<3.0.0',
 'xmltodict>=0.12.0,<0.13.0']

setup_kwargs = {
    'name': 'os2mo-data-import',
    'version': '2.34.8',
    'description': 'A set of tools for OS2MO data import and export',
    'long_description': '.. _ImportHelper:\n\n**********************\nOS2MO data import tool\n**********************\n\nA small higher level utility for os2mo data import.\n\nThe utility provides functionality to create organisation units\nand employees and to create all of the types to which these can be assigned.\n\nAdditonally the utility can be used to insert data objects\ninto a running instance of os2mo.\n\n\nInstalling\n==========\n\nInstall the os2mo_data_import package as follows:\n\n.. code-block:: bash\n\n    # Checkout the mora source repository\n    https://github.com/OS2mo/os2mo-data-import-and-export\n\n    # Navigate to the local copy of the repository\n    cd /path/to/os2mo-data-import-and-export\n\n    # Install package with pip\n    pip install -e os2mo_data_import\n\n\nGetting started\n===============\nThe main entry point (for most use cases) is the Organisation class,\nwhich functions as a wrapper for all the sub classes.\n\n.. code-block:: python\n\n    # Imports\n    from os2mo_data_import import ImportHelper\n\n    # Init helper\n    os2mo = ImportHelper(create_defaults=True, store_integration_data=True)\n\n    # Add organisation\n    os2mo.add_organisation(\n        identifier="Magenta Aps",\n        user_key="Magenta",\n        municipality_code=101\n    )\n\n\nOrganisation Units\n------------------\nBefore organisation units can be created,\na type for the unit must be added:\n\n.. code-block:: python\n\n    # Add klasse with reference to facet "org_unit_type"\n    os2mo.add_klasse(\n        identifier="Hovedenhed",\n        facet_type_ref="org_unit_type",\n        user_key="D1ED90C5-643A-4C12-8889-6B4174EF4467",\n        title="Hovedenhed"  # This is the displayed value\n    )\n\n\nNow an organisation unit can be added with "org_unit_type_ref" referencing\nthe user defined identifier of the newly created unit type by name:\n\n.. code-block:: python\n\n    # Root unit: Magenta\n    # Belongs to unit type: "Hovedenhed"\n    os2mo.add_organisation_unit(\n        identifier="Magenta",\n        name="Magenta Aps",\n        type_ref="Hovedenhed",  # Reference to the unit type\n        date_from="1986-01-01"\n    )\n\nOrganisation unit "Magenta" is a root unit in this example.\nTo add children/sub units, "Magenta" must be referenced as parent:\n\n.. code-block:: python\n\n    # Add unit type "Afdeling"\n    os2mo.add_klasse(\n        identifier="Afdeling",\n        facet_type_ref="org_unit_type",\n        user_key="91154D1E-E7CA-439B-B910-D4622FD3FD21",\n        title="Afdeling"\n    )\n\n    # Add sub unit "Pilestræde"\n    os2mo.add_organisation_unit(\n        identifier="Pilestræde",\n        type_ref="Afdeling",  # This unit is of type: Afdeling\n        parent_ref="Magenta",  # Sub unit of/Belongs to Magenta\n        date_from="1986-01-01"\n    )\n\n\nOptional data or "details" can be associated with an organisation unit.\n\n.. note::\n\n    At least 2 "Klasse" objects must be created,\n    an object for the primary phone number and\n    an object for the primary mailing address (residence).\n\n    The validation in the (os2mo) frontend application requires:\n\n    The user_key on the the primary phone number object\n    must be specified as "PhoneUnit"\n\n    The user_key on the primary mail address object\n    must be specified as "AddressMailUnit"\n\n    Hence either the "identifier" or the "user_key"\n    must be set to:\n\n        - PhoneUnit\n        - AddressMailUnit\n\n    (The "user_key" is derived from the value of the "identifier\n    if not explicitly set)\n\n    See the example below:\n\n\n.. code-block:: python\n\n    # Add klasse type "AdressePost"\n    # Which belongs to facet type "org_unit_address_type"\n\n    # user_key is not explicitly set, identifier must be "AddressMailUnit"\n    os2mo.add_klasse(\n        identifier="AddressMailUnit",\n        facet_type_ref="org_unit_address_type",\n        title="Adresse",\n        scope="DAR",\n        example="<UUID>"\n    )\n\n    # Add klasse type "Telefon"\n    # Which belongs to facet type "org_unit_address_type"\n\n    # user_key is set to "PhoneUnit", hence the identifier can be anything\n    os2mo.add_klasse(\n        identifier="Telefon",\n        facet_type_ref="org_unit_address_type",\n        user_key="PhoneUnit",\n        title="Tlf",\n        scope="PHONE",\n        example="20304060"\n    )\n\n    # Add "AdressePost" detail to the unit "Magenta"\n    os2mo.add_address_type(\n        organisation_unit="Magenta",\n        value="0a3f50c4-379f-32b8-e044-0003ba298018",\n        type_ref="AdressePost",\n        date_from="1986-01-01"\n    )\n\n    # Add "Telefon" detail to the unit "Magenta"\n    os2mo.add_address_type(\n        organisation_unit="Magenta",\n        value="11223344",\n        type_ref="Telefon",\n        date_from="1986-01-01",\n    )\n\nEmployees\n---------\nEmployees are not directly attached to an organisation unit,\nbut can have a job function which is linked to a unit.\n\nCreate employees first:\n\n.. code-block:: python\n\n    os2mo.add_employee(\n        identifier="Susanne Chæf",\n        cpr_no="0101862233"\n    )\n\n    os2mo.add_employee(\n        identifier="Odin Perskov",\n        cpr_no="0102862234"\n    )\n\nJob function\n------------\nAdd the job function types:\n\n.. code-block:: python\n\n    # Job: CEO ("Direktør")\n    os2mo.add_klasse(\n        identifier="Direktør",\n        facet_type_ref="engagement_type",\n        user_key="Direktør",\n        title="Direktør"\n    )\n\n    # Job: Projectmanager ("Projektleder")\n    os2mo.add_klasse(\n        identifier="Projektleder",\n        facet_type_ref="engagement_type",\n        user_key="Projektleder",\n        title="Projektleder"\n    )\n\n\nAdd job functions to the newly created employees\nwith the "add_type_engagement" method:\n\n.. code-block:: python\n\n    # Susanne Chæf is CEO\n    os2mo.add_engagement(\n        employee="Susanne Chæf",\n        organisation_unit="Magenta",\n        job_function_ref="Direktør",\n        engagement_type_ref="Ansat",\n        date_from="1986-01-01"\n    )\n\n    # Odin Perskov is projectmanager\n    os2mo.add_engagement(\n        employee="Odin Perskov",\n        organisation_unit="Pilestræde",\n        job_function_ref="Projektleder",\n        engagement_type_ref="Ansat",\n        date_from="1986-02-01"\n    )\n\n\nAssociation\n-----------\nIn this example the employee "Odin Perskov" is an external consultant,\nand to reflect this an association type can be assigned:\n\n.. code-block:: python\n\n    os2mo.add_klasse(\n        identifier="Ekstern Konsulent",\n        facet_type_ref="association_type",\n        user_key="F997F306-71DF-477C-AD42-E753F9C21B42",\n        title="Ekstern Konsulent"\n    )\n\n    # Add the consultant association to "Odin Perskov":\n    os2mo.add_association(\n        employee="Odin Perskov",\n        organisation_unit="Pilestræde",\n        job_function_ref="Projektleder",\n        association_type_ref="Ekstern Konsulent",\n        address_uuid="0a3f50c4-379f-32b8-e044-0003ba298018",\n        date_from="1986-10-01"\n    )\n\nIn the following example an address is assigned to employee "Odin Perskov".\nFor residential addresses, valid UUID\'s are used to reference an address\nfrom the "Danish registry of addresses" (DAR):\n\n.. code-block:: python\n\n    # Add address type "AdressePostEmployee"\n    os2mo.add_klasse(\n        identifier="AdressePostEmployee",\n        facet_type_ref="employee_address_type",\n        user_key="2F29C717-5D78-4AA9-BDAE-7CDB3A378018",\n        title="Adresse",\n        scope="DAR",\n        example="<UUID>"\n    )\n\n    # Detail AdressePostEmployee assigned to "Odin Perskov"\n    os2mo.add_address_type(\n        employee="Odin Perskov",\n        value="0a3f50a0-ef5a-32b8-e044-0003ba298018",\n        type_ref="AdressePostEmployee",\n        date_from="1986-11-01",\n    )\n\n\nRoles\n-----\nTo add a role type:\n\n.. code-block:: python\n\n    # A role as contact for external projects\n    os2mo.add_klasse(\n        identifier="Nøgleansvarlig",\n        facet_type_ref="role_type",\n        user_key="0E078F23-A5B4-4FB4-909B-60E49295C5E9",\n        title="Nøgleansvarlig"\n    )\n\n    # Role assigned to "Odin Perskov"\n    os2mo.add_role(\n        employee="Odin Perskov",\n        organisation_unit="Pilestræde",\n        role_type_ref="Nøgleansvarlig",\n        date_from="1986-12-01"\n    )\n\nIt systems\n----------\nGeneric IT systems can be created and assigned to employees with a specified "user_key",\nwhich functions as a reference to a username, pin code etc.:\n\n.. code-block:: python\n\n  # Create IT system: Database\n    os2mo.new_itsystem(\n        identifier="Database",\n        system_name="Database"\n    )\n\n    # Assign access to the database\n    # with username "odpe@db"\n    os2mo.join_itsystem(\n        employee="Odin Perskov",\n        user_key="odpe@db",\n        itsystem_ref="Database",\n        date_from="1987-10-01"\n    )\n\n\nManager type, level and responsibilities\n----------------------------------------\nIn order to assign employees as managers to an organisation unit,\nthe following types must be created:\n\n - manager type\n - manager level\n - A type for each responsibility\n\nCreate manager type:\n\n.. code-block:: python\n\n    os2mo.add_klasse(\n        identifier="Leder",\n        facet_type_ref="manager_type",\n        user_key="55BD7A09-86C3-4E15-AF5D-EAD20EB12F81",\n        title="Virksomhedens direktør"\n    )\n\nCreate manager level:\n\n.. code-block:: python\n\n    os2mo.add_klasse(\n        identifier="Højeste niveau",\n        facet_type_ref="manager_level",\n        user_key="6EAA7DA7-212D-4FD0-A068-BA3F932FDB10",\n        title="Højeste niveau"\n    )\n\nCreate several responsibilities:\n\n.. code-block:: python\n\n    os2mo.add_klasse(\n        identifier="Tage beslutninger",\n        facet_type_ref="responsibility",\n        user_key="A9ABDCCB-EC83-468F-AB7D-175B95E94956",\n        title="Tage beslutninger"\n    )\n\n    os2mo.add_klasse(\n        identifier="Motivere medarbejdere",\n        facet_type_ref="responsibility",\n        user_key="DC475AF8-21C9-4112-94AE-E9FB13FE8D14",\n        title="Motivere medarbejdere"\n    )\n\n    os2mo.add_klasse(\n        identifier="Betale løn",\n        facet_type_ref="responsibility",\n        user_key="0A929060-3392-4C07-8F4E-EF5F9B6AFDE2",\n        title="Betale løn"\n    )\n\nAssign the manager position of Magenta to "Susanne Chæf":\n\n.. code-block:: python\n\n    os2mo.add_manager(\n        employee="Susanne Chæf",\n        organisation_unit="Magenta",\n        manager_type_ref="Leder",\n        manager_level_ref="Højeste niveau",\n        responsibility_list=["Tage beslutninger", "Motivere medarbejdere", "Betale løn"],\n        date_from="1987-12-01",\n    )\n\n\n\nPreservation of UUIDs\n=====================\nIf the system to be imported into MO contains UUIDs that should be preserved in MO,\nit is possible to import the UUIDs for employees, organisational units, classes and\nclassifications. This is achieved by adding an extra uuid argument when creating the\nobject, eg:\n\n.. code-block:: python\n\n    os2mo.add_klasse(\n        identifier="Betale løn",\n        facet_type_ref="responsibility",\n        uuid="195da2b6-e648-4bdc-add1-e22654996997",\n        user_key="0A929060-3392-4C07-8F4E-EF5F9B6AFDE2",\n        title="Betale løn"\n    )\n\n\nContinuous integration\n======================\nIt is possible to run the importer in a mode where the internal identifiers will\nbe stored in the special field \'integration_data\' in LoRa. This identifier will\nbe recognized upon the next import and the object will be re-imported in contrast to\nbeing created again. In effect this will turn the importer into a one-way integration\nof the imported system.\n\n\nExample\n=======\nIf a "real" os2mo application is available,\na practial example is provided with contains similar import data\nas the given examples above.\n\nFeel free to run the "import_example.py" included in the repository:\n\nExample: $os2mo-data-import-and-export/os2mo_data_import/import_example.py\n\nRun example:\n\n.. code-block:: bash\n\n  cd os2mo_data_import\n  python import_example.py\n\n\nReference\n=========\nFor more information on the os2mo project,\nplease refer to the official documentation.\n\nRead the docs: https://os2mo.readthedocs.io\n\n\nKnown Issues\n============\nCurrently it is not possible to assign "Leave" (e.g. various types of leave of absence).\n\nThis issue is related to the validation of type assignments.\n',
    'author': 'Magenta',
    'author_email': 'info@magenta.dk',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://git.magenta.dk/rammearkitektur/os2mo-data-import-and-export',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
