# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['lcdoc',
 'lcdoc.operations',
 'lcdoc.plugins.doc_lcdoc',
 'lcdoc.plugins.doc_lcdoc.arch',
 'lcdoc.py_test']

package_data = \
{'': ['*'],
 'lcdoc': ['assets/mkdocs/lcd/assets/*',
           'assets/mkdocs/lcd/assets/css/*',
           'assets/mkdocs/lcd/assets/javascript/*',
           'assets/mkdocs/lcd/assets/plantuml/*',
           'assets/mkdocs/lcd/partials/*',
           'assets/mkdocs/lcd/src/_snippets/*',
           'assets/mkdocs/lcd/src/_snippets/.code/*',
           'assets/mkdocs/lcd/src/md/keepachangelog/*']}

install_requires = \
['anybadge>=1.7.0,<2.0.0', 'devapps>=2021.5.10,<2022.0.0']

entry_points = \
{'console_scripts': ['doc = devapp.plugin_tools:main']}

setup_kwargs = {
    'name': 'docutools',
    'version': '2021.5.12',
    'description': 'Documentation Tools for the Devapp Framework',
    'long_description': '#  docutools\n\n<p attr="autogenerated by make_badges"></p>\n\n[![docs][img_docs]][lnk_docs]&nbsp; [![package][img_package]][lnk_package]&nbsp; [![discuss][img_discuss]][lnk_discuss]&nbsp; [![pipeline][img_pipeline]][lnk_pipeline]&nbsp; [![coverage][img_coverage]][lnk_coverage]&nbsp; [![statements][img_statements]][lnk_statements]&nbsp; [![code style][img_code style]][lnk_code style]\n\n[lnk_docs]: http://github.pages.com/docutools/\n[img_docs]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/documentation.svg\n[lnk_package]: https://artifacts.github.com/artifactory/pypi-ax-sources/docutools/2021.1.21.dev14+g13aab44.d20210418/docutools-2021.1.21.dev14+g13aab44.d20210418.tar.gz\n[img_package]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/pypi_package.svg\n[lnk_discuss]: https://join.skype.com/krSNYZqvEmJm\n[img_discuss]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/discuss.svg\n[lnk_pipeline]: https://axiros.github.com/devapps/docutools/-/commits/master\n[img_pipeline]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/pipeline.svg\n[lnk_coverage]: http://github.pages.com/docutools//coverage/index.html\n[img_coverage]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/coverage.svg\n[lnk_statements]: http://github.pages.com/docutools//coverage/index.html\n[img_statements]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/statements.svg\n[lnk_code style]: https://github.com/axiros/axblack\n[img_code style]: https://badges.github.com/scm/hg/noauth/badges/raw-file/62eef82452cb/docutools/code_style_ax_black.svg\n\n<p attr="autogenerated by make_badges"></p>\n\n\n## Documentation building tools\n\n![](img/page-teaser.png){: style="width:1550px" }\n\n## Requirements\n\ndocutools requires Python 3.6 or above.\n\n<details>\n<summary>To install Python 3.6, I recommend using <a href="https://github.com/pyenv/pyenv"><code>pyenv</code></a>.</summary>\n\n```bash\n# install pyenv\ngit clone https://github.com/pyenv/pyenv ~/.pyenv\n\n# setup pyenv (you should also put these three lines in .bashrc or similar)\nexport PATH="${HOME}/.pyenv/bin:${PATH}"\nexport PYENV_ROOT="${HOME}/.pyenv"\neval "$(pyenv init -)"\n\n# install Python 3.6\npyenv install 3.6.12\n\n# make it available globally\npyenv global system 3.6.12\n```\n</details>\n\n## Installation\n\nWith `pip`:\n```bash\npython3.6 -m pip install docutools\n```\n\nWith [`pipx`](https://github.com/pipxproject/pipx):\n```bash\npython3.6 -m pip install --user pipx\n\npipx install --python python3.6 docutools\n```\n\n----\nLast modified: Fri Dec 18 13:32:05 2020\n<!-- pre_proc_marker -->\n\n\n----\n\n\nLast modified: Sun Apr 18 22:48:03 2021\n\n\n',
    'author': 'Gunther Klessinger',
    'author_email': 'gunther.klessinger@axiros.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://github.pages.com/docutools/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
