# SPDX-License-Identifier: MIT
# Copyright (c) 2020 The Pybricks Authors

from typing import Dict, Optional, Tuple

from .parameters import Port

class PUPDevice:
    def __init__(self, port: Port): ...
    def info(self) -> Dict[str, str]: ...
    def read(self, mode: int) -> Tuple: ...
    def write(self, mode: int, data: Tuple) -> None: ...

class LUMPDevice:
    def __init__(self, port: Port): ...
    def read(self, mode: int) -> Tuple: ...

class Ev3devSensor:
    sensor_index: int
    port_index: int
    def __init__(self, port: Port): ...
    def read(self, mode: int) -> Tuple: ...

class AnalogSensor:
    def __init__(self, port: Port): ...
    def voltage(self) -> int: ...
    def resistance(self) -> int: ...
    def active(self) -> None: ...
    def passive(self) -> None: ...

class I2CDevice:
    def __init__(self, port: Port, address: int): ...
    def read(self, reg: Optional[int], length: Optional[int] = 1) -> bytes: ...
    def write(self, reg: Optional[int], data: Optional[bytes] = None) -> None: ...

class UARTDevice:
    def __init__(self, port: Port, baudrate: int, timeout: Optional[int] = None): ...
    def read(self, length: int = 1) -> bytes: ...
    def read_all(self) -> bytes: ...
    def write(self, data: bytes) -> None: ...
    def waiting(self) -> int: ...
    def clear(self) -> None: ...
