# SPDX-License-Identifier: MIT
# Copyright (c) 2020 The Pybricks Authors

from typing import List, Optional, Tuple

from .parameters import Color, Direction, Port, Button
from ._common import Motor  # noqa E402

class TouchSensor:
    def __init__(self, port: Port): ...
    def pressed(self) -> bool: ...

class ColorSensor:
    def __init__(self, port: Port): ...
    def color(self) -> Optional[Color]: ...
    def ambient(self) -> int: ...
    def reflection(self) -> int: ...
    def rgb(self) -> Tuple[int, int, int]: ...

class InfraredSensor:
    def __init__(self, port: Port): ...
    def distance(self) -> int: ...
    def beacon(self, channel: int) -> Tuple[Optional[int], Optional[int]]: ...
    def buttons(self, channel: int) -> List[Button]: ...
    def keypad(self) -> List[Button]: ...

class GyroSensor:
    def __init__(
        self, port: Port, positive_direction: Direction = Direction.CLOCKWISE
    ): ...
    def speed(self) -> int: ...
    def angle(self) -> int: ...
    def reset_angle(self, angle: int) -> None: ...

class UltrasonicSensor:
    def __init__(self, port: Port): ...
    def distance(self, silent: bool = False) -> int: ...
    def presence(self) -> bool: ...
