"""The setuptools based setup module for cloogle."""

from setuptools import setup, find_packages
from codecs import open
from os import path

here = path.abspath(path.dirname(__file__))

with open(path.join(here, 'README.rst'), encoding='utf-8') as f:
    long_description = f.read()

setup(
    name='cloogle',
    version='1.0.9',
    description='Basic interface to the Cloogle API',
    long_description=long_description,
    url='https://gitlab.com/cloogle/periphery/cloogle.py',
    author='Camil Staps',
    author_email='info@camilstaps.nl',
    license='GPLv3',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'Intended Audience :: Information Technology',
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3 :: Only',
        'Topic :: Software Development :: Documentation',
        'Topic :: Utilities',
    ],
    keywords='cloogle api search clean',
    py_modules=['cloogle']
)
