from setuptools import find_packages, setup

setup(
    name="isar",
    description="Integration and Supervisory control of Autonomous Robots",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    author="Equinor ASA",
    author_email="fg_robots_dev@equinor.com",
    url="https://github.com/equinor/isar",
    packages=find_packages(where="src"),
    package_dir={"": "src"},
    classifiers=[
        "Environment :: Other Environment",
        "Intended Audience :: Developers",
        "Intended Audience :: Science/Research",
        "Programming Language :: Python",
        "Topic :: Scientific/Engineering",
        "Topic :: Scientific/Engineering :: Physics",
        "Topic :: Software Development :: Libraries",
    ],
    include_package_data=True,
    install_requires=[
        "alitra>=1.1.0",
        "azure-identity",
        "azure-keyvault-secrets",
        "azure-storage-blob",
        "backoff",
        "click",
        "dacite",
        "fastapi-azure-auth",
        "fastapi",
        "injector",
        "numpy",
        "paho-mqtt",
        "pydantic",
        "PyJWT",
        "python-dotenv",
        "PyYAML",
        "requests-toolbelt",
        "requests",
        "transitions",
        "uvicorn",
    ],
    extras_require={
        "dev": [
            "black",
            "flake8",
            "mypy",
            "myst-parser",
            "pytest-dotenv",
            "pytest-mock",
            "pytest-xdist",
            "pytest",
            "requests-mock",
            "sphinx",
            "pre-commit",
        ]
    },
    python_requires=">=3.9",
)
