"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MappingTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
/**
 * (experimental) MappingTemplates for AppSync resolvers.
 *
 * @experimental
 */
class MappingTemplate {
    /**
     * (experimental) Create a mapping template from the given string.
     *
     * @experimental
     */
    static fromString(template) {
        return new StringMappingTemplate(template);
    }
    /**
     * (experimental) Create a mapping template from the given file.
     *
     * @experimental
     */
    static fromFile(fileName) {
        return new StringMappingTemplate(fs_1.readFileSync(fileName).toString('utf-8'));
    }
    /**
     * (experimental) Mapping template for a result list from DynamoDB.
     *
     * @experimental
     */
    static dynamoDbResultList() {
        return this.fromString('$util.toJson($ctx.result.items)');
    }
    /**
     * (experimental) Mapping template for a single result item from DynamoDB.
     *
     * @experimental
     */
    static dynamoDbResultItem() {
        return this.fromString('$util.toJson($ctx.result)');
    }
    /**
     * (experimental) Mapping template to scan a DynamoDB table to fetch all entries.
     *
     * @experimental
     */
    static dynamoDbScanTable() {
        return this.fromString('{"version" : "2017-02-28", "operation" : "Scan"}');
    }
    /**
     * (experimental) Mapping template to query a set of items from a DynamoDB table.
     *
     * @param cond the key condition for the query.
     * @experimental
     */
    static dynamoDbQuery(cond, indexName) {
        return this.fromString(`{"version" : "2017-02-28", "operation" : "Query", ${indexName ? `"index" : "${indexName}", ` : ''}${cond.renderTemplate()}}`);
    }
    /**
     * (experimental) Mapping template to get a single item from a DynamoDB table.
     *
     * @param keyName the name of the hash key field.
     * @param idArg the name of the Query argument.
     * @experimental
     */
    static dynamoDbGetItem(keyName, idArg) {
        return this.fromString(`{"version": "2017-02-28", "operation": "GetItem", "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * (experimental) Mapping template to delete a single item from a DynamoDB table.
     *
     * @param keyName the name of the hash key field.
     * @param idArg the name of the Mutation argument.
     * @experimental
     */
    static dynamoDbDeleteItem(keyName, idArg) {
        return this.fromString(`{"version": "2017-02-28", "operation": "DeleteItem", "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * (experimental) Mapping template to save a single item to a DynamoDB table.
     *
     * @param key the assigment of Mutation values to the primary key.
     * @param values the assignment of Mutation values to the table attributes.
     * @experimental
     */
    static dynamoDbPutItem(key, values) {
        return this.fromString(`
      ${values.renderVariables()}
      {
        "version": "2017-02-28",
        "operation": "PutItem",
        ${key.renderTemplate()},
        ${values.renderTemplate()}
      }`);
    }
    /**
     * (experimental) Mapping template to invoke a Lambda function.
     *
     * @param payload the VTL template snippet of the payload to send to the lambda.
     * @experimental
     */
    static lambdaRequest(payload = '$util.toJson($ctx)') {
        return this.fromString(`{"version": "2017-02-28", "operation": "Invoke", "payload": ${payload}}`);
    }
    /**
     * (experimental) Mapping template to return the Lambda result to the caller.
     *
     * @experimental
     */
    static lambdaResult() {
        return this.fromString('$util.toJson($ctx.result)');
    }
}
exports.MappingTemplate = MappingTemplate;
_a = JSII_RTTI_SYMBOL_1;
MappingTemplate[_a] = { fqn: "@aws-cdk/aws-appsync.MappingTemplate", version: "1.106.1" };
class StringMappingTemplate extends MappingTemplate {
    constructor(template) {
        super();
        this.template = template;
    }
    renderTemplate() {
        return this.template;
    }
}
//# sourceMappingURL=data:application/json;base64,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