import { ITable } from '@aws-cdk/aws-dynamodb';
import { IDomain } from '@aws-cdk/aws-elasticsearch';
import { IFunction } from '@aws-cdk/aws-lambda';
import { IServerlessCluster } from '@aws-cdk/aws-rds';
import { ISecret } from '@aws-cdk/aws-secretsmanager';
import { CfnResource, IResource, Resource } from '@aws-cdk/core';
import { DynamoDbDataSource, HttpDataSource, LambdaDataSource, NoneDataSource, RdsDataSource, AwsIamConfig, ElasticsearchDataSource } from './data-source';
import { Resolver, ExtendedResolverProps } from './resolver';
/**
 * (experimental) Optional configuration for data sources.
 *
 * @experimental
 */
export interface DataSourceOptions {
    /**
     * (experimental) The name of the data source, overrides the id given by cdk.
     *
     * @default - generated by cdk given the id
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) The description of the data source.
     *
     * @default - No description
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) Optional configuration for Http data sources.
 *
 * @experimental
 */
export interface HttpDataSourceOptions extends DataSourceOptions {
    /**
     * (experimental) The authorization config in case the HTTP endpoint requires authorization.
     *
     * @default - none
     * @experimental
     */
    readonly authorizationConfig?: AwsIamConfig;
}
/**
 * (experimental) Interface for GraphQL.
 *
 * @experimental
 */
export interface IGraphqlApi extends IResource {
    /**
     * (experimental) an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
     *
     * @experimental
     * @attribute true
     */
    readonly apiId: string;
    /**
     * (experimental) the ARN of the API.
     *
     * @experimental
     * @attribute true
     */
    readonly arn: string;
    /**
     * (experimental) add a new dummy data source to this API.
     *
     * Useful for pipeline resolvers
     * and for backend changes that don't require a data source.
     *
     * @param id The data source's id.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addNoneDataSource(id: string, options?: DataSourceOptions): NoneDataSource;
    /**
     * (experimental) add a new DynamoDB data source to this API.
     *
     * @param id The data source's id.
     * @param table The DynamoDB table backing this data source.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addDynamoDbDataSource(id: string, table: ITable, options?: DataSourceOptions): DynamoDbDataSource;
    /**
     * (experimental) add a new http data source to this API.
     *
     * @param id The data source's id.
     * @param endpoint The http endpoint.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addHttpDataSource(id: string, endpoint: string, options?: HttpDataSourceOptions): HttpDataSource;
    /**
     * (experimental) add a new Lambda data source to this API.
     *
     * @param id The data source's id.
     * @param lambdaFunction The Lambda function to call to interact with this data source.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addLambdaDataSource(id: string, lambdaFunction: IFunction, options?: DataSourceOptions): LambdaDataSource;
    /**
     * (experimental) add a new Rds data source to this API.
     *
     * @param id The data source's id.
     * @param serverlessCluster The serverless cluster to interact with this data source.
     * @param secretStore The secret store that contains the username and password for the serverless cluster.
     * @param databaseName The optional name of the database to use within the cluster.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addRdsDataSource(id: string, serverlessCluster: IServerlessCluster, secretStore: ISecret, databaseName?: string, options?: DataSourceOptions): RdsDataSource;
    /**
     * (experimental) add a new elasticsearch data source to this API.
     *
     * @param id The data source's id.
     * @param domain The elasticsearch domain for this data source.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addElasticsearchDataSource(id: string, domain: IDomain, options?: DataSourceOptions): ElasticsearchDataSource;
    /**
     * (experimental) creates a new resolver for this datasource and API using the given properties.
     *
     * @experimental
     */
    createResolver(props: ExtendedResolverProps): Resolver;
    /**
     * (experimental) Add schema dependency if not imported.
     *
     * @param construct the dependee.
     * @experimental
     */
    addSchemaDependency(construct: CfnResource): boolean;
}
/**
 * (experimental) Base Class for GraphQL API.
 *
 * @experimental
 */
export declare abstract class GraphqlApiBase extends Resource implements IGraphqlApi {
    /**
     * (experimental) an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
     *
     * @experimental
     */
    abstract readonly apiId: string;
    /**
     * (experimental) the ARN of the API.
     *
     * @experimental
     */
    abstract readonly arn: string;
    /**
     * (experimental) add a new dummy data source to this API.
     *
     * Useful for pipeline resolvers
     * and for backend changes that don't require a data source.
     *
     * @param id The data source's id.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addNoneDataSource(id: string, options?: DataSourceOptions): NoneDataSource;
    /**
     * (experimental) add a new DynamoDB data source to this API.
     *
     * @param id The data source's id.
     * @param table The DynamoDB table backing this data source.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addDynamoDbDataSource(id: string, table: ITable, options?: DataSourceOptions): DynamoDbDataSource;
    /**
     * (experimental) add a new http data source to this API.
     *
     * @param id The data source's id.
     * @param endpoint The http endpoint.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addHttpDataSource(id: string, endpoint: string, options?: HttpDataSourceOptions): HttpDataSource;
    /**
     * (experimental) add a new Lambda data source to this API.
     *
     * @param id The data source's id.
     * @param lambdaFunction The Lambda function to call to interact with this data source.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addLambdaDataSource(id: string, lambdaFunction: IFunction, options?: DataSourceOptions): LambdaDataSource;
    /**
     * (experimental) add a new Rds data source to this API.
     *
     * @param id The data source's id.
     * @param serverlessCluster The serverless cluster to interact with this data source.
     * @param secretStore The secret store that contains the username and password for the serverless cluster.
     * @param databaseName The optional name of the database to use within the cluster.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addRdsDataSource(id: string, serverlessCluster: IServerlessCluster, secretStore: ISecret, databaseName?: string, options?: DataSourceOptions): RdsDataSource;
    /**
     * (experimental) add a new elasticsearch data source to this API.
     *
     * @param id The data source's id.
     * @param domain The elasticsearch domain for this data source.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addElasticsearchDataSource(id: string, domain: IDomain, options?: DataSourceOptions): ElasticsearchDataSource;
    /**
     * (experimental) creates a new resolver for this datasource and API using the given properties.
     *
     * @experimental
     */
    createResolver(props: ExtendedResolverProps): Resolver;
    /**
     * (experimental) Add schema dependency if not imported.
     *
     * @param construct the dependee.
     * @experimental
     */
    addSchemaDependency(construct: CfnResource): boolean;
}
