/***************************************************************************
  **************************************************************************
    
  Spherical Harmonic Transform Kit 2.7
    
  Copyright 1997-2003  Sean Moore, Dennis Healy,
                       Dan Rockmore, Peter Kostelec
  Copyright 2004  Peter Kostelec, Dan Rockmore

  This file is part of SpharmonicKit.

  SpharmonicKit is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  SpharmonicKit is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
  See the accompanying LICENSE file for details.

  ************************************************************************
  ************************************************************************/

/* quadrature weights file */

/* contains precomputed arrays of Legendre quadrature weight values */

/***

  The interface function to these arrays is defined at the end
  of this file. It is

  const double *get_weights( int bw )

  ***/


static const double w4[8] = 
{0.06698294569888951, 0.222987933015572, 0.3241525190659486, 
 0.3858766022239052, 0.3858766022242057, 0.3241525190660357, 
 0.222987933015605, 0.06698294569889861};

static const double w8[16] = 
{0.0168027552304648, 0.058336464069326, 0.0917183132052142, 
  0.1251296181582697, 0.1513924616369861, 0.1734194117717632, 
  0.1877497281148386, 0.1954512478118618, 0.1954512478124817, 
  0.187749728115036, 0.1734194117718737, 0.1513924616370552, 
  0.1251296181583115, 0.0917183132052395, 0.0583364640693394, 
  0.0168027552304693};

static const double w16[32] = 
{0.004204256199901001, 0.014748328130096, 0.023629778419644, 
  0.033237125953057, 0.041849747749195, 0.050571719994984, 0.05840156832621, 
  0.065996706406676, 0.07268790949655301, 0.078899622945272, 
  0.084170977199815, 0.088777632866959, 0.092414154989675, 0.095247804861176, 
  0.097103167890767, 0.09805949856685, 0.098059498568105, 0.09710316789118, 
  0.095247804861419, 0.092414154989843, 0.088777632867086, 0.084170977199914, 
  0.07889962294535, 0.07268790949661499, 0.06599670640672201, 
  0.05840156832624701, 0.050571719995013, 0.04184974774921601, 
  0.033237125953072, 0.023629778419653, 0.014748328130102, 0.004204256199904};

static const double w32[64] = 
{0.001051287070134, 0.00369738253841, 0.005951729000078, 0.00843412760248, 
  0.010722073632584, 0.013119273230032, 0.015375045276171, 0.017685873258142, 
  0.019875170205663, 0.022085297687726, 0.02418169220008, 0.026273624541033, 
  0.028254130235429, 0.03020985118730501, 0.032053730303588, 
  0.033855733201296, 0.035544150136538, 0.037175968389769, 0.038691923240227, 
  0.040138463486499, 0.04146682983648501, 0.042714610025193, 
  0.04384221112648501, 0.044879543239542, 0.045795238152625, 
  0.04661237251476801, 0.047307138466904, 0.04789637733659801, 
  0.048363381016468, 0.048719165059896, 0.048953818726571, 0.049072788071371, 
  0.04907278807389301, 0.048953818727408, 0.04871916506039601, 
  0.048363381016822, 0.04789637733687, 0.047307138467123, 0.046612372514951, 
  0.04579523815278, 0.044879543239676, 0.043842211126604, 
  0.04271461002529901, 0.04146682983657701, 0.04013846348658201, 
  0.0386919232403, 0.037175968389834, 0.035544150136597, 0.033855733201345, 
  0.032053730303631, 0.030209851187344, 0.028254130235463, 0.026273624541062, 
  0.024181692200106, 0.022085297687748, 0.019875170205683, 0.017685873258158, 
  0.015375045276184, 0.013119273230042, 0.010722073632593, 0.008434127602487, 
  0.005951729000084, 0.003697382538416, 0.001051287070135};

static const double w64[128] = 
{0.000262835707197, 0.000924989999111, 0.001490708223128, 0.002116377084453, 
  0.002696897333212, 0.003309996179437, 0.003893120261077, 0.004497543115599, 
  0.005078810319213, 0.005675008203167, 0.00625174592528, 0.006839175137552, 
  0.007409342588573999, 0.007987078618147001, 0.008548922859887, 
  0.009115873663663, 0.009667799842016, 0.010222796978386, 0.010763311740366, 
  0.011305155615914, 0.01183284018059, 0.012360325369511, 0.012873822157835, 
  0.013385753079517, 0.013883759122364, 0.014378960637318, 0.01486022460612, 
  0.015337549735279, 0.015800871005997, 0.016259206915535, 0.016703435812042, 
  0.017141708689126, 0.017565747421518, 0.017982926599289, 0.018385730608967, 
  0.018780832153766, 0.019161411686675, 0.019533501577973, 0.019890923371016, 
  0.020239120355893, 0.020572509359939, 0.020895987534359, 0.021204528621207, 
  0.021502519771847, 0.021785459387897, 0.022057255116519, 0.022313902856023, 
  0.022558856500676, 0.022788586578443, 0.023006114940762, 0.023208367548925, 
  0.023397952433377, 0.023572234970434, 0.023733424539198, 0.023879312701991, 
  0.02401172264761, 0.024128861378958, 0.024232175915971, 0.02432028020224, 
  0.024394252878361, 0.02445310839246, 0.024497562719501, 0.024527026305793, 
  0.0245418562091, 0.024541856214155, 0.024527026307477, 0.02449756272051, 
  0.024453108393178, 0.024394252878919, 0.024320280202694, 0.024232175916354, 
  0.024128861379288, 0.0240117226479, 0.023879312702248, 0.023733424539429, 
  0.023572234970644, 0.023397952433567, 0.0232083675491, 0.023006114940923, 
  0.022788586578593, 0.022558856500815, 0.022313902856155, 0.022057255116642, 
  0.021785459388013, 0.021502519771957, 0.021204528621309, 0.020895987534455, 
  0.020572509360028, 0.020239120355979, 0.019890923371095, 0.019533501578048, 
  0.019161411686746, 0.018780832153833, 0.018385730609031, 0.01798292659935, 
  0.017565747421574, 0.017141708689177, 0.01670343581209, 0.016259206915579, 
  0.015800871006039, 0.015337549735318, 0.014860224606157, 0.014378960637354, 
  0.013883759122397, 0.013385753079548, 0.012873822157864, 0.012360325369538, 
  0.011832840180615, 0.011305155615937, 0.010763311740387, 0.010222796978406, 
  0.009667799842034, 0.00911587366368, 0.008548922859902, 
  0.007987078618162001, 0.007409342588588, 0.006839175137563, 
  0.00625174592529, 0.005675008203175001, 0.005078810319221, 
  0.004497543115606001, 0.003893120261083, 0.003309996179442, 
  0.002696897333215, 0.002116377084455, 0.00149070822313, 0.000924989999113, 
  0.000262835707198};

static const double w128[256] = 
{0.00006570979804700001, 0.000231287781681, 0.000372850682377, 
  0.0005295852579860001, 0.000675250395855, 0.000829391556843, 
  0.000976379874001, 0.001129170626245, 0.001276635350415, 0.001428455530568, 
  0.00157599404156, 0.001726971566243, 0.001874335528027, 0.002024499068583, 
  0.002171507648, 0.002320839159993, 0.002467345803675, 0.002615802533704, 
  0.00276168005361, 0.002909205089103, 0.003054338176375, 0.003200866029983, 
  0.003345147175454, 0.003490606977160999, 0.003633934105273, 
  0.003778251544106, 0.00392052657317, 0.004063625141538, 
  0.004204753074832001, 0.004346554902770001, 0.004486443238699001, 
  0.004626869676061001, 0.004765428017920001, 0.004904400055734, 
  0.005041539850622, 0.005178978436418001, 0.005314612800191, 
  0.005450439081433, 0.005584482682361001, 0.005718618199879, 
  0.005850987183271, 0.005983354029097999, 0.006113965971002, 
  0.006244486920353, 0.006373260802234001, 0.006501859426327, 
  0.006628715625060999, 0.00675531638946, 0.006880176678639, 
  0.007004705030490001, 0.007127492590122, 0.007249875036680999, 
  0.007370514469181, 0.007490678649426, 0.007609096000292, 0.007726970750944, 
  0.007843093532933999, 0.007958608949848, 0.008072366169753, 
  0.00818545366546, 0.008296775852748, 0.008407368210702, 0.008516187447504, 
  0.008624218873466, 0.008730468825455, 0.008835874996376, 0.00893949094419, 
  0.009042209054839, 0.009143127925774, 0.009243096733323, 0.009341257133065, 
  0.009438416999793, 0.009533759243988, 0.009628052178236, 0.009720518323772, 
  0.009811888019229, 0.009901421895061, 0.009989813768489, 0.010076361005926, 
  0.01016172223336, 0.010245230295698, 0.010327509847181, 0.01040792805862, 
  0.010487076731504, 0.01056435630527, 0.010640326756109, 0.010714420821715, 
  0.010787167596789, 0.010858031226384, 0.010927510790845, 0.010995101024613, 
  0.01106127179028, 0.011125547660837, 0.011188370012642, 0.011249292568396, 
  0.011308728889492, 0.011366261216937, 0.011422275912458, 0.011476383157352, 
  0.011528942676846, 0.011579592064295, 0.011628664922806, 0.011675825776166, 
  0.011721382573983, 0.011765026332604, 0.011807039773664, 0.011847140009442, 
  0.011885584918387, 0.0119221173511, 0.011956970688993, 0.011989913200414, 
  0.01202115407909, 0.012050486725864, 0.012078096420934, 0.012103801446196, 
  0.012127763408697, 0.012149825252426, 0.012170125119097, 0.012188530427205, 
  0.012205156029404, 0.012219893661527, 0.012232835032782, 0.012243896068789, 
  0.012253145450964, 0.01226052319614, 0.012266075044157, 0.012269765032797, 
  0.012271616015418, 0.012271616025538, 0.012269765036171, 0.01226607504618, 
  0.012260523197585, 0.012253145452086, 0.012243896069705, 0.012232835033557, 
  0.012219893662197, 0.012205156029995, 0.012188530427732, 0.012170125119574, 
  0.012149825252861, 0.012127763409096, 0.012103801446564, 0.012078096421277, 
  0.012050486726183, 0.012021154079388, 0.011989913200695, 0.011956970689258, 
  0.01192211735135, 0.011885584918625, 0.011847140009668, 0.011807039773878, 
  0.011765026332809, 0.011721382574178, 0.011675825776353, 0.011628664922986, 
  0.011579592064467, 0.011528942677012, 0.01147638315751, 0.011422275912611, 
  0.011366261217084, 0.011308728889633, 0.011249292568532, 0.011188370012774, 
  0.011125547660964, 0.011061271790402, 0.010995101024731, 0.01092751079096, 
  0.010858031226495, 0.010787167596897, 0.01071442082182, 0.010640326756211, 
  0.010564356305369, 0.0104870767316, 0.010407928058713, 0.010327509847272, 
  0.010245230295784, 0.010161722233445, 0.010076361006008, 0.009989813768569, 
  0.009901421895139, 0.009811888019304, 0.009720518323844, 0.009628052178306, 
  0.009533759244057, 0.00943841699986, 0.009341257133129, 0.009243096733387, 
  0.009143127925836, 0.009042209054899, 0.008939490944248, 0.008835874996432, 
  0.008730468825509, 0.008624218873518, 0.008516187447556, 0.008407368210752, 
  0.008296775852796, 0.008185453665507, 0.008072366169798, 
  0.007958608949892002, 0.007843093532976999, 0.007726970750985, 
  0.007609096000332, 0.007490678649464999, 0.007370514469219001, 
  0.007249875036717001, 0.007127492590157001, 0.007004705030525001, 
  0.006880176678672, 0.006755316389493001, 0.006628715625090999, 
  0.006501859426356999, 0.006373260802263001, 0.006244486920381, 
  0.006113965971028001, 0.005983354029124, 0.005850987183295999, 
  0.005718618199903001, 0.005584482682384, 0.005450439081455001, 
  0.005314612800212, 0.005178978436438, 0.005041539850642, 0.004904400055753, 
  0.004765428017938001, 0.004626869676079, 0.004486443238715, 
  0.004346554902785, 0.004204753074847, 0.004063625141552, 0.003920526573184, 
  0.003778251544119, 0.003633934105285, 0.003490606977173, 0.003345147175465, 
  0.003200866029994, 0.003054338176383, 0.002909205089113, 0.002761680053618, 
  0.002615802533712, 0.002467345803683, 0.00232083916, 0.002171507648006, 
  0.00202449906859, 0.001874335528032, 0.001726971566249, 0.001575994041564, 
  0.001428455530574, 0.001276635350418, 0.001129170626249, 0.000976379874003, 
  0.000829391556847, 0.000675250395855, 0.00052958525799, 0.000372850682373, 
  0.000231287781669, 0.00006570979804800002};

static const double w256[512] = 
{0.000016427503969, 0.000057824463176, 0.000093223524253, 0.000132427011547, 
  0.000168876765095, 0.000207466271305, 0.000244288939511, 0.000282592182481, 
  0.0003195930246610001, 0.0003577218931030001, 0.00039481716083, 
  0.0004328205129590001, 0.00046996497087, 0.0005078667900809999, 
  0.000545032008038, 0.000582844522457, 0.000620010557182, 0.000657739728682, 
  0.00069489138259, 0.0007325395316460002, 0.000769664468754, 
  0.000807231658003, 0.000844319371608, 0.000881804191424, 0.000918845400182, 
  0.000956245441742, 0.0009932317174, 0.001030543871494, 0.001067467399453, 
  0.001104688052859, 0.001141541472578, 0.001178666641542, 0.001215442936965, 
  0.001252468360569, 0.001289160782934, 0.001326081990093, 0.001362684002397, 
  0.001399496360993, 0.001436001597243, 0.001472700350903, 0.001509102585759, 
  0.001545682881865, 0.001581976007687, 0.001618432919092, 0.001654610928387, 
  0.001690939470468, 0.001726996442331, 0.001763191586607, 0.00179912167614, 
  0.001835178361276, 0.001870975791298, 0.001906888932103, 0.001942547986597, 
  0.001978312481493, 0.002013827500412, 0.002049438237672, 0.00208480361283, 
  0.002120255475876, 0.00215546564766, 0.002190753519593, 0.00222580297437, 
  0.002260921741886, 0.00229580500995, 0.002330749566754, 0.002365461220714, 
  0.002400226470536, 0.002434761124065, 0.002469341983335, 0.002503694290216, 
  0.002538085690463, 0.002572250343879, 0.002606447233903, 0.002640418965931, 
  0.002674416313774, 0.002708189895049, 0.002741982689808, 0.002775552929325, 
  0.002809136182823, 0.002842497927869, 0.002875866676207, 0.002909014812378, 
  0.002942164117387, 0.002975093568704, 0.003008018519307, 0.003040724248398, 
  0.0030734199619, 0.003105896970238, 0.003138358593542, 0.003170601921752, 
  0.003202824632518999, 0.003234829360708, 0.003266808368473, 
  0.003298569616617, 0.003330300163847999, 0.003361813092194, 
  0.003393290455317, 0.00342455026483, 0.003455769755219, 0.003486771688035, 
  0.003517728652959, 0.003548467992873, 0.003579157816428, 0.003609629889387, 
  0.003640047993388, 0.003670248168005, 0.00370039001286, 0.003730313700935, 
  0.003760174786501, 0.003789817443554, 0.003819393309955999, 
  0.003848750435768, 0.003878036664213, 0.003907103803373001, 
  0.003936096016942, 0.003964868759394, 0.003993562623816, 
  0.004022036605419001, 0.004050427829826001, 0.004078598732904, 
  0.004106683070578, 0.004134546624483, 0.004162319873579001, 
  0.004189871855248001, 0.004217329859513001, 0.004244566094025001, 
  0.004271704743495001, 0.004298621104627, 0.004325436336318, 
  0.004352028747102, 0.004378516545684001, 0.004404780978957001, 
  0.004430937377421001, 0.004456869856377, 0.004482690936682001, 
  0.004508287535417001, 0.004533769429134, 0.004559026273189, 
  0.004584165162129, 0.004609078429030001, 0.004633870545864, 
  0.004658436465650001, 0.004682878094518001, 0.004707092950275, 
  0.00473118042738, 0.004755040555759999, 0.004778770269959001, 
  0.004802272061704, 0.004825640455081, 0.004848780355527, 0.00487178392396, 
  0.004894558433549001, 0.004917193727272, 0.004939599402047001, 
  0.004961863026186001, 0.004983896478286, 0.005005785093406, 
  0.005027442991551001, 0.005048953314173001, 0.005070232384145, 
  0.005091361187270001, 0.005112258212384, 0.005133002325996001, 
  0.005153514147559001, 0.005173870459121, 0.005193993976897, 
  0.005213959431841, 0.005233691604496001, 0.005253263206698, 
  0.005272601052242, 0.005291775864488, 0.005310716460711001, 
  0.005329491605157, 0.005348032090048001, 0.005366404748669, 
  0.005384542320838001, 0.005402509735862, 0.005420241654952001, 
  0.005437801129286001, 0.005455124716366, 0.005472273614022, 
  0.005489186251984, 0.00550592199848, 0.005522421132419999, 
  0.005538741215183, 0.005554824352777001, 0.005570726321529001, 
  0.005586391033396, 0.005601872500531, 0.005617116420594, 0.005632175061549, 
  0.005646995887380001, 0.005661629440992001, 0.005676024934150002, 
  0.005690231203007001, 0.005704199189367, 0.005717976040144, 
  0.00573151441022, 0.005744859774007, 0.005757966483261999, 
  0.005770878355882001, 0.005783551425027001, 0.005796027867347, 
  0.005808265382635001, 0.005820304520862001, 0.005832104634372, 
  0.005843704660338, 0.005855065590243001, 0.00586622476169, 
  0.005877144792525001, 0.005887861433364999, 0.005898338916278, 
  0.005908611416851, 0.005918644769848001, 0.005928471587176, 
  0.005938059295355, 0.005947438953369001, 0.005956579569142, 
  0.005965510658911, 0.005974202802222001, 0.005982683982174, 
  0.0059909263407, 0.005998956336821, 0.006006747666167, 0.0060143252722, 
  0.006021664396086001, 0.006028788473711001, 0.006035674284143, 
  0.006042343763159, 0.006048775220592, 0.006054989099073001, 
  0.00606096523257, 0.006066722577022001, 0.006072242484397, 
  0.006077542429899001, 0.006082605277847, 0.006087447028186, 
  0.006092052052407001, 0.006096434880196, 0.006100581385514001, 
  0.006104504632306, 0.006108191992765001, 0.006111655069151, 
  0.006114882728112, 0.006117885113813, 0.006120652584033, 
  0.006123193827978001, 0.006125500691682, 0.006127580412073001, 
  0.006129426321014999, 0.006131044205378, 0.006132428880873001, 
  0.006133584686079, 0.006134507918985001, 0.006135201471109, 
  0.006135663121189001, 0.006135894310104, 0.006135894330353001, 
  0.006135663127938001, 0.006135201475158, 0.006134507921876999, 
  0.006133584688328999, 0.006132428882714001, 0.006131044206935, 
  0.006129426322363001, 0.006127580413262001, 0.006125500692746, 
  0.006123193828938, 0.006120652584909, 0.006117885114619, 
  0.006114882728857002, 0.006111655069845, 0.006108191993413001, 
  0.006104504632915, 0.006100581386088, 0.006096434880738001, 
  0.006092052052921, 0.006087447028675, 0.006082605278313001, 
  0.006077542430344001, 0.006072242484822001, 0.006066722577429001, 
  0.006060965232962001, 0.006054989099448001, 0.006048775220953, 
  0.006042343763507, 0.006035674284479001, 0.006028788474036001, 
  0.0060216643964, 0.006014325272504, 0.006006747666462, 0.005998956337106, 
  0.005990926340977, 0.005982683982443, 0.005974202802484001, 
  0.005965510659166, 0.005956579569389, 0.005947438953609, 
  0.005938059295590001, 0.005928471587405, 0.005918644770072001, 
  0.005908611417070001, 0.00589833891649, 0.005887861433571999, 
  0.005877144792727, 0.005866224761888001, 0.005855065590437001, 
  0.005843704660528, 0.005832104634556, 0.005820304521043, 
  0.005808265382813001, 0.005796027867521002, 0.005783551425197001, 
  0.005770878356049001, 0.005757966483426001, 0.005744859774168, 
  0.005731514410377, 0.005717976040299, 0.005704199189518001, 
  0.005690231203156, 0.005676024934296001, 0.005661629441134999, 
  0.005646995887520001, 0.005632175061686999, 0.005617116420729001, 
  0.005601872500663, 0.005586391033526001, 0.005570726321654, 
  0.005554824352903, 0.005538741215304001, 0.005522421132542, 
  0.005505921998597, 0.005489186252101, 0.005472273614135001, 
  0.005455124716480001, 0.005437801129395, 0.005420241655062, 
  0.005402509735968, 0.005384542320946001, 0.005366404748772001, 
  0.005348032090152001, 0.005329491605258001, 0.005310716460812, 
  0.005291775864586001, 0.005272601052340001, 0.005253263206792001, 
  0.005233691604590001, 0.005213959431933001, 0.005193993976988, 
  0.005173870459209001, 0.005153514147648, 0.005133002326081, 
  0.005112258212471001, 0.005091361187355002, 0.00507023238423, 
  0.005048953314254, 0.005027442991634001, 0.005005785093485001, 
  0.004983896478366001, 0.004961863026263, 0.004939599402124001, 
  0.004917193727347, 0.004894558433625001, 0.004871783924034001, 
  0.004848780355600001, 0.004825640455152, 0.004802272061775, 
  0.004778770270028, 0.004755040555829, 0.004731180427446001, 
  0.004707092950341, 0.004682878094582, 0.004658436465715, 0.004633870545927, 
  0.004609078429093, 0.004584165162189999, 0.004559026273251, 
  0.004533769429193, 0.004508287535477001, 0.004482690936739, 
  0.004456869856435001, 0.004430937377477001, 0.004404780979013001, 
  0.004378516545739, 0.004352028747156, 0.004325436336371, 0.004298621104681, 
  0.004271704743546001, 0.004244566094077001, 0.004217329859563001, 
  0.004189871855299, 0.004162319873628001, 0.004134546624532, 
  0.004106683070625, 0.004078598732951001, 0.004050427829872, 
  0.004022036605464, 0.00399356262386, 0.003964868759439, 0.003936096016985, 
  0.003907103803416, 0.003878036664255, 0.00384875043581, 0.003819393309996, 
  0.003789817443595, 0.00376017478654, 0.003730313700974, 0.003700390012898, 
  0.003670248168042, 0.003640047993424, 0.003609629889423, 0.003579157816463, 
  0.003548467992908, 0.003517728652994, 0.00348677168807, 0.003455769755252, 
  0.003424550264864, 0.00339329045535, 0.003361813092226, 0.003330300163878, 
  0.003298569616648, 0.003266808368503, 0.003234829360738, 0.003202824632547, 
  0.003170601921781, 0.00313835859357, 0.003105896970266, 0.003073419961927, 
  0.003040724248424, 0.003008018519334, 0.00297509356873, 0.002942164117411, 
  0.002909014812403, 0.002875866676231, 0.002842497927893, 0.002809136182847, 
  0.002775552929348, 0.00274198268983, 0.002708189895071, 0.002674416313795, 
  0.002640418965952, 0.002606447233923999, 0.0025722503439, 
  0.002538085690483, 0.002503694290235, 0.002469341983354, 0.002434761124084, 
  0.002400226470554, 0.002365461220732, 0.002330749566771, 0.002295805009966, 
  0.002260921741902, 0.002225802974386, 0.002190753519609, 0.002155465647675, 
  0.002120255475891, 0.002084803612844, 0.002049438237686, 0.002013827500426, 
  0.001978312481505, 0.00194254798661, 0.001906888932116, 0.001870975791311, 
  0.001835178361288, 0.001799121676152, 0.001763191586619, 0.001726996442342, 
  0.001690939470479, 0.001654610928397, 0.001618432919102, 0.001581976007697, 
  0.001545682881875, 0.001509102585768, 0.001472700350912, 0.001436001597252, 
  0.001399496361002, 0.001362684002406, 0.001326081990101, 0.001289160782941, 
  0.001252468360575, 0.001215442936972, 0.001178666641549, 0.001141541472585, 
  0.001104688052865, 0.001067467399459, 0.0010305438715, 0.000993231717406, 
  0.000956245441748, 0.000918845400187, 0.000881804191429, 0.000844319371613, 
  0.000807231658007, 0.000769664468757, 0.00073253953165, 0.000694891382594, 
  0.000657739728686, 0.0006200105571850001, 0.00058284452246, 
  0.00054503200804, 0.0005078667900840001, 0.0004699649708719999, 
  0.000432820512961, 0.000394817160832, 0.0003577218931049999, 
  0.000319593024663, 0.000282592182483, 0.000244288939512, 0.000207466271306, 
  0.000168876765096, 0.000132427011548, 0.000093223524253, 0.000057824463176, 
  0.00001642750396799999};

static const double w512[1024] = 
{0.000004106879400, 0.000014456273158, 0.000023306559435, 
  0.000033108671611, 0.00004222320224200001, 0.00005187396827500001, 
  0.00006108436171500001, 0.00007066677338799999, 0.00007992540675699999, 
  0.000089468498074, 0.000098755495817, 0.000108272542349, 0.000117577656232, 
  0.000127075713915, 0.000136392895909, 0.000145876080638, 0.000155201403121, 
  0.000164672262839, 0.000174002983096, 0.000183463153807, 0.000192797242849, 
  0.000202247794306, 0.000211583678538, 0.0002210253104269999, 
  0.000230361720507, 0.000239794880528, 0.000249130758092, 0.000258555716462, 
  0.000267890154061, 0.000277307052401, 0.000286639253414, 0.000296048137923, 
  0.000305377388964, 0.000314778233575, 0.000324103884993, 0.000333496607917, 
  0.000342818059722, 0.000352202535531, 0.000361519227009, 0.000370895295652, 
  0.000380206697583, 0.0003895741711779999, 0.0003988797798979999, 
  0.000408238447972, 0.000417537780798, 0.0004268874143590001, 
  0.000436180005999, 0.0004455203607440001, 0.0004548057604690001, 
  0.0004641365793420001, 0.000473414348713, 0.0004827353639690001, 
  0.0004920050750080001, 0.000501316009885, 0.0005105772435880001, 
  0.0005198778136810001, 0.000529130158804, 0.0005384200731900001, 
  0.000547663125237, 0.0005569420874319999, 0.0005661754478159999, 
  0.000575443156556, 0.0005846664319000001, 0.0005939225818200001, 
  0.0006031353833700001, 0.0006123796655580001, 0.0006215816086820001, 
  0.0006308137111759999, 0.0006400044149439999, 0.00064922402314, 
  0.0006584031099620001, 0.0006676099069780001, 0.0006767770022980001, 
  0.0006859706692809999, 0.0006951254013070001, 0.0007043056177120001, 
  0.0007134476171900001, 0.0007226140610170001, 0.000731742961034, 
  0.0007408953090330001, 0.0007500107448440002, 0.000759148672704, 
  0.0007682502815870001, 0.000777373464104, 0.000786460885222, 
  0.0007955689964400002, 0.000804641870736, 0.000813734584083, 
  0.000822792554179, 0.000831869542581, 0.000840912252691, 0.000849973188684, 
  0.000859000284534, 0.000868044840356, 0.000877055969128, 0.000886083816808, 
  0.000895078627073, 0.000904089438512, 0.00091306758018, 0.000922061027225, 
  0.000931022151505, 0.000939997906011, 0.00094894166537, 0.000957899399267, 
  0.000966825447395, 0.000975764832744, 0.000984672824523, 0.000993593533568, 
  0.001002483125052, 0.00101138483027, 0.001020255678654, 0.0010291380528, 
  0.001037989816413, 0.001046852532563, 0.001055684870837, 0.001064527602429, 
  0.001073340175901, 0.001082162596774, 0.001090955067055, 0.001099756851485, 
  0.001108528881269, 0.001117309703996, 0.001126060957045, 0.001134820493313, 
  0.001143550634444, 0.001152288560031, 0.001160997255122, 0.001169713246361, 
  0.001178400162341, 0.001187093896159, 0.001195758701007, 0.001204429854942, 
  0.001213072217686, 0.001221720469919, 0.001230340060635, 0.001238965090009, 
  0.001247561579823, 0.001256163065871, 0.001264736126961, 0.001273313749924, 
  0.001281863055519, 0.001290416496373, 0.001298941720758, 0.001307470661232, 
  0.001315971479751, 0.001324475602346, 0.001332951691408, 0.001341430679422, 
  0.001349881716502, 0.001358335254045, 0.00136676091769, 0.001375188689703, 
  0.001383588659542, 0.001391990351817, 0.001400364308559, 0.001408739607758, 
  0.001417087233201, 0.00142543582687, 0.001433756803915, 0.001442078380501, 
  0.001450372393146, 0.001458666642021, 0.001466933375377, 0.001475199986844, 
  0.001483439127139, 0.001491677792454, 0.001499889027044, 0.001508099438431, 
  0.001516282455802, 0.001524464306469, 0.00153261879625, 0.001540771780403, 
  0.001548897433369, 0.001557021246228, 0.001565117754316, 0.001573212092127, 
  0.001581279148436, 0.001589343708489, 0.001597381007296, 0.001605415487939, 
  0.001613422724701, 0.00162142682535, 0.001629403696718, 0.00163737711788, 
  0.001645323321701, 0.001653265764974, 0.001661181000313, 0.001669092168413, 
  0.001676976135549, 0.001684855732315, 0.001692708132754, 0.001700555863164, 
  0.001708376399653, 0.001716191969838, 0.001723980346365, 0.001731763463621, 
  0.001739519385435, 0.001747269758236, 0.001754992931848, 0.001762710269857, 
  0.001770400403054, 0.001778084417137, 0.00178574121899, 0.00179339162123, 
  0.001801014802101, 0.001808631305809, 0.001816220577366, 0.001823802897091, 
  0.001831357972312, 0.001838905823856, 0.001846426417043, 0.001853939517471, 
  0.001861425344255, 0.001868903411911, 0.001876354189264, 0.001883796943776, 
  0.001891212390023, 0.00189861955232, 0.001905999387143, 0.001913370679464, 
  0.001920714623916, 0.001928049769824, 0.001935357546337, 0.001942656270725, 
  0.001949927603119, 0.00195718963223, 0.001964424245723, 0.001971649307152, 
  0.00197884692837, 0.00198603475108, 0.001993195108067, 0.002000345422399, 
  0.002007468244622, 0.002014580782309, 0.002021665800673, 0.002028740294844, 
  0.002035787241701001, 0.002042823426899, 0.002049832036052, 
  0.002056829648238001, 0.002063799654957, 0.002070758431527, 
  0.002077689572554, 0.002084609252345, 0.002091501265903, 0.002098381589205, 
  0.002105234215014, 0.00211207492358, 0.002118887902856, 0.002125688739913, 
  0.002132461815384, 0.002139222525644, 0.002145955441558, 0.002152675771225, 
  0.002159368273357, 0.002166047970139, 0.002172699805806, 0.002179338618926, 
  0.002185949536986, 0.002192547217188, 0.00219911696806, 0.002205673267626, 
  0.002212201603288999, 0.002218716276042, 0.002225202950052, 
  0.002231675751366, 0.002238120518862, 0.002244551205676, 0.002250953823386, 
  0.002257342154212, 0.002263702380465, 0.002270048115394, 0.002276365710129, 
  0.002282668610845, 0.002288943335617, 0.002295203165403, 0.002301434783394, 
  0.002307651307143, 0.002313839583172, 0.002320012567394, 0.002326157267921, 
  0.002332286480757, 0.002338387373893, 0.002344472585119, 0.002350529440638, 
  0.002356570421675, 0.002362583011019, 0.002368579534943, 0.002374547631231, 
  0.002380499472783, 0.002386422850817, 0.002392329786409, 0.002398208222688, 
  0.002404070030411, 0.002409903303136, 0.002415719762774, 0.002421507651852, 
  0.002427278544883, 0.002433020831944, 0.002438745941556, 0.002444442409952, 
  0.002450121521044, 0.002455771955864, 0.002461404855062, 0.002467009043133, 
  0.002472595518791, 0.002478153248694999, 0.002483693090907, 
  0.002489204152978, 0.002494697153588, 0.002500161339928, 0.002505607292534, 
  0.002511024397017, 0.002516423096978, 0.00252179291526, 0.00252714415971, 
  0.002532466489232, 0.002537770077083, 0.002543044717085, 0.002548300449034, 
  0.002553527200556, 0.002558734879097, 0.002563913544989, 0.002569072974418, 
  0.002574203359348, 0.002579314345768, 0.002584396256233, 0.002589458607566, 
  0.002594491851887, 0.002599505377879, 0.002604489766221, 0.002609454278451, 
  0.002614389622823, 0.002619304934707, 0.00262419104897, 0.002629056975773, 
  0.002633893675649999, 0.002638710034488, 0.002643497137566, 
  0.002648263747413, 0.002653001073157, 0.002657717754858, 0.002662405124606, 
  0.002667071700879, 0.002671708937861, 0.002676325233303, 0.002680912162639, 
  0.002685478003738, 0.002690014452449, 0.002694529667584, 0.002699015464598, 
  0.002703479884048, 0.002707914860204, 0.002712328316156, 
  0.002716712304211999, 0.002721074630768, 0.002725407465406, 
  0.002729718498588, 0.002734000016423, 0.002738259594177, 0.002742489633758, 
  0.002746697595963, 0.002750875997784, 0.002755032186259, 0.002759158792764, 
  0.00276326305127, 0.002767337706857, 0.002771389881106, 0.002775412432133, 
  0.002779412369794, 0.002783382664584999, 0.002787330215291, 
  0.002791248104142, 0.00279514311949, 0.002799008454675, 0.002802850788239, 
  0.002806663424016, 0.002810452931346, 0.00281421272396, 0.002817949262593, 
  0.002821656070283, 0.002825339499743, 0.002828993182748, 0.002832623364559, 
  0.002836223785121, 0.002839800582804, 0.002843347605175, 0.002846870884256, 
  0.002850364374703, 0.002853834002723001, 0.002857273829532, 
  0.002860689676045, 0.002864075709524, 0.002867437646105, 0.002870769758596, 
  0.002874077658848, 0.002877355724723, 0.002880609464276, 0.002883833359948, 
  0.002887032816471, 0.002890202420394, 0.002893347473595, 0.00289646266627, 
  0.0028995531979, 0.002902613861886, 0.002905649755746, 0.002908655775651, 
  0.002911636917597, 0.002914588180095, 0.002917514458039, 0.002920410851867, 
  0.002923282155783, 0.002926123571749, 0.002928939793678999, 
  0.002931726124661, 0.002934487158715, 0.002937218299673, 0.002939924042037, 
  0.002942599890008, 0.002945250238947, 0.002947870693056, 0.002950465548916, 
  0.002953030510372, 0.002955569775586, 0.002958079147698, 0.002960562726786, 
  0.002963016414955, 0.002965444214534, 0.002967842126258, 
  0.002970214055039999, 0.002972556099925, 0.002974872068724, 
  0.002977158158479, 0.002979418080209999, 0.002981648128657, 
  0.002983851918343, 0.002986025841414, 0.002988173416189999, 
  0.002990291131934, 0.002992382411047, 0.002994443839634, 0.002996478744447, 
  0.002998483808166, 0.003000462262163, 0.003002410885431, 0.003004332814217, 
  0.003006224923577, 0.003008090254882, 0.003009925779009, 0.0030117344427, 
  0.003013513312394, 0.003015265240453, 0.003016987388665, 0.003018682515214, 
  0.003020347877025, 0.003021986138323, 0.003023594650957, 0.003025175985399, 
  0.003026727588221, 0.003028251936345, 0.003029746570867, 0.003031213875351, 
  0.003032651485231, 0.003034061690902, 0.003035442221949, 0.003036795275774, 
  0.003038118675948, 0.003039414527052, 0.003040680746467999, 
  0.003041919346119, 0.003043128337046, 0.003044309638667999, 
  0.003045461355534, 0.003046585314706, 0.003047679714095, 0.003048746288552, 
  0.003049783329212, 0.003050792478846, 0.003051772121685, 0.003052723808548, 
  0.003053646016639, 0.003054540204943001, 0.003055404943523, 
  0.003056241599642, 0.003057048836115, 0.003057827928588, 0.003058577632525, 
  0.003059299132053, 0.003059991275193, 0.003060655154645, 0.003061289710899, 
  0.003061895945309, 0.003062472890754, 0.003063021457324, 0.003063540770213, 
  0.003064031648312, 0.003064493309066, 0.003064926480232, 0.003065330471445, 
  0.003065705919386, 0.003066052225822, 0.00306636993641, 0.003066658545003, 
  0.003066918506275, 0.003067149406117, 0.003067351608258, 0.003067524790575, 
  0.003067669225868999, 0.003067784683888, 0.003067871346375, 0.003067929074, 
  0.003067957949017, 0.003067957989526, 0.003067929087504, 0.003067871354478, 
  0.003067784689675, 0.003067669230369, 0.003067524794256999, 
  0.003067351611374, 0.003067149408817, 0.003066918508657, 0.003066658547135, 
  0.003066369938339, 0.003066052227581999, 0.003065705921005, 
  0.003065330472945, 0.003064926481627, 0.003064493310371, 0.003064031649537, 
  0.003063540771368, 0.003063021458417, 0.00306247289179, 0.003061895946293, 
  0.003061289711838, 0.003060655155542, 0.003059991276052, 0.003059299132876, 
  0.003058577633316, 0.003057827929348, 0.003057048836847, 0.003056241600348, 
  0.003055404944206, 0.003054540205603, 0.003053646017278, 0.003052723809167, 
  0.003051772122286, 0.003050792479429, 0.003049783329778, 0.003048746289103, 
  0.003047679714631, 0.003046585315228, 0.003045461356042, 0.003044309639164, 
  0.003043128337529, 0.00304191934659, 0.003040680746929, 0.003039414527502, 
  0.003038118676389, 0.003036795276205, 0.003035442222369, 0.003034061691313, 
  0.003032651485635, 0.003031213875747, 0.003029746571254, 
  0.003028251936725001, 0.003026727588593, 0.003025175985764, 
  0.003023594651315, 0.003021986138674999, 0.003020347877371, 
  0.003018682515553, 0.003016987388998, 0.003015265240781, 0.003013513312717, 
  0.003011734443017, 0.003009925779321, 0.003008090255188, 
  0.003006224923878999, 0.003004332814513, 0.003002410885723, 
  0.00300046226245, 0.002998483808449, 0.002996478744726, 0.002994443839908, 
  0.002992382411318, 0.002990291132201, 0.002988173416453, 0.002986025841674, 
  0.002983851918599, 0.002981648128909, 0.002979418080459, 0.002977158158725, 
  0.002974872068966, 0.002972556100164, 0.002970214055277, 0.002967842126492, 
  0.002965444214764, 0.002963016415182, 0.002960562727011, 0.002958079147919, 
  0.002955569775805, 0.002953030510589, 0.002950465549129, 
  0.002947870693266999, 0.002945250239156001, 0.002942599890215, 
  0.002939924042241, 0.002937218299875, 0.002934487158914, 0.002931726124858, 
  0.002928939793873, 0.002926123571942, 0.002923282155973, 0.002920410852056, 
  0.002917514458225, 0.002914588180279, 0.002911636917779, 0.002908655775832, 
  0.002905649755924, 0.002902613862062, 0.002899553198075, 0.002896462666444, 
  0.002893347473766, 0.002890202420562, 0.002887032816639, 0.002883833360113, 
  0.00288060946444, 0.002877355724885, 0.002874077659009, 
  0.002870769758754999, 0.002867437646263999, 0.00286407570968, 
  0.002860689676199, 0.002857273829683999, 0.002853834002874, 
  0.002850364374853, 0.002846870884405, 0.002843347605322, 
  0.002839800582948999, 0.002836223785266, 0.002832623364703, 
  0.002828993182891, 0.002825339499884, 0.002821656070423, 0.00281794926273, 
  0.002814212724097, 0.002810452931482, 0.00280666342415, 0.002802850788372, 
  0.002799008454808, 0.002795143119621, 0.002791248104272, 0.002787330215419, 
  0.002783382664713, 0.002779412369924, 0.002775412432255, 0.00277138988123, 
  0.00276733770698, 0.002763263051395, 0.002759158792882999, 
  0.002755032186379, 0.002750875997904, 0.002746697596084, 0.002742489633872, 
  0.002738259594292, 0.002734000016538, 0.002729718498705, 0.002725407465518, 
  0.002721074630881, 0.002716712304323, 0.00271232831627, 0.002707914860311, 
  0.002703479884156001, 0.002699015464706, 0.002694529667693, 
  0.002690014452555, 0.002685478003845, 0.002680912162745, 0.002676325233411, 
  0.002671708937961999, 0.002667071700982, 0.002662405124708, 
  0.002657717754962, 0.002653001073255, 0.002648263747513, 
  0.002643497137664999, 0.002638710034588, 0.002633893675745, 
  0.00262905697587, 0.002624191049066, 0.002619304934804, 0.002614389622915, 
  0.002609454278545, 0.002604489766314999, 0.002599505377973, 
  0.002594491851977, 0.002589458607657, 0.002584396256323, 0.002579314345861, 
  0.002574203359437, 0.002569072974506001, 0.002563913545079, 
  0.002558734879186, 0.002553527200641, 0.00254830044912, 0.002543044717172, 
  0.002537770077166001, 0.002532466489316, 0.002527144159794, 
  0.002521792915344, 0.002516423097058, 0.002511024397097, 
  0.002505607292613999, 0.002500161340009, 0.002494697153666, 
  0.002489204153055, 0.002483693090986, 0.002478153248772999, 
  0.002472595518867, 0.002467009043209, 0.002461404855137, 0.00245577195594, 
  0.002450121521118, 0.002444442410025, 0.002438745941629, 0.002433020832019, 
  0.002427278544955, 0.002421507651923, 0.002415719762845, 0.002409903303208, 
  0.00240407003048, 0.002398208222757, 0.002392329786478, 0.002386422850887, 
  0.00238049947285, 0.002374547631297999, 0.002368579535011, 
  0.002362583011087, 0.00235657042174, 0.002350529440704, 0.002344472585185, 
  0.002338387373959, 0.00233228648082, 0.002326157267985, 0.002320012567458, 
  0.002313839583235, 0.002307651307204, 0.002301434783456, 0.002295203165464, 
  0.002288943335679, 0.002282668610904, 0.002276365710188, 0.002270048115455, 
  0.002263702380525, 0.00225734215427, 0.002250953823445, 0.002244551205735, 
  0.00223812051892, 0.002231675751423, 0.002225202950109, 0.002218716276098, 
  0.002212201603346, 0.002205673267681, 0.002199116968115, 0.002192547217244, 
  0.002185949537041, 0.002179338618978, 0.002172699805859, 0.002166047970194, 
  0.002159368273411, 0.002152675771277, 0.002145955441609, 0.002139222525697, 
  0.002132461815437, 0.002125688739964, 0.002118887902906, 0.002112074923632, 
  0.002105234215065, 0.002098381589255, 0.002091501265952, 0.002084609252394, 
  0.002077689572603, 0.002070758431574, 0.002063799655004, 0.002056829648286, 
  0.002049832036099, 0.002042823426945, 0.002035787241748, 0.002028740294891, 
  0.00202166580072, 0.002014580782354, 0.002007468244667, 0.002000345422444, 
  0.001993195108111, 0.001986034751123, 0.001978846928413, 0.001971649307195, 
  0.001964424245767, 0.001957189632272, 0.001949927603162, 0.001942656270768, 
  0.001935357546379, 0.001928049769865, 0.001920714623957, 0.001913370679505, 
  0.001905999387184, 0.00189861955236, 0.001891212390063, 0.001883796943816, 
  0.001876354189304, 0.001868903411949, 0.001861425344293, 0.00185393951751, 
  0.001846426417081, 0.001838905823894, 0.00183135797235, 0.001823802897129, 
  0.001816220577403, 0.001808631305845, 0.001801014802138, 0.001793391621266, 
  0.001785741219026, 0.001778084417172, 0.001770400403089, 0.001762710269892, 
  0.001754992931883, 0.00174726975827, 0.001739519385469, 0.001731763463655, 
  0.001723980346399, 0.00171619196987, 0.001708376399685, 0.001700555863197, 
  0.001692708132786, 0.001684855732346, 0.001676976135581, 0.001669092168445, 
  0.001661181000344, 0.001653265765004, 0.001645323321731, 0.001637377117909, 
  0.001629403696746, 0.00162142682538, 0.00161342272473, 0.001605415487968, 
  0.001597381007324, 0.001589343708518, 0.001581279148464, 0.001573212092155, 
  0.001565117754343, 0.001557021246255, 0.001548897433396, 0.00154077178043, 
  0.001532618796275, 0.001524464306496, 0.001516282455828, 0.001508099438458, 
  0.001499889027069, 0.001491677792479, 0.001483439127164, 0.001475199986869, 
  0.001466933375401, 0.001458666642045, 0.00145037239317, 0.001442078380526, 
  0.001433756803938, 0.001425435826894, 0.001417087233225, 0.001408739607782, 
  0.001400364308581, 0.00139199035184, 0.001383588659565, 0.001375188689726, 
  0.001366760917712, 0.001358335254067, 0.001349881716524, 0.001341430679444, 
  0.001332951691429, 0.001324475602367, 0.001315971479772, 0.001307470661253, 
  0.001298941720778, 0.001290416496393, 0.001281863055539, 0.001273313749944, 
  0.00126473612698, 0.001256163065891, 0.001247561579843, 0.001238965090029, 
  0.001230340060654, 0.001221720469938, 0.001213072217705, 0.001204429854961, 
  0.001195758701025, 0.001187093896178, 0.001178400162359, 0.00116971324638, 
  0.001160997255138, 0.001152288560048, 0.001143550634461, 0.00113482049333, 
  0.001126060957061, 0.001117309704013, 0.001108528881285, 0.001099756851501, 
  0.001090955067071, 0.00108216259679, 0.001073340175916, 0.001064527602445, 
  0.001055684870852, 0.001046852532578, 0.001037989816427, 0.001029138052815, 
  0.001020255678668, 0.001011384830284, 0.001002483125066, 0.000993593533583, 
  0.000984672824537, 0.000975764832758, 0.000966825447408, 0.000957899399281, 
  0.000948941665383, 0.000939997906024, 0.000931022151518, 0.000922061027238, 
  0.000913067580192, 0.000904089438525, 0.000895078627085, 0.000886083816821, 
  0.00087705596914, 0.000868044840367, 0.000859000284546, 0.000849973188695, 
  0.000840912252702, 0.000831869542592, 0.00082279255419, 0.000813734584093, 
  0.000804641870746, 0.0007955689964510001, 0.000786460885232, 
  0.000777373464115, 0.000768250281597, 0.0007591486727140002, 
  0.000750010744855, 0.000740895309042, 0.0007317429610440001, 
  0.000722614061027, 0.0007134476172, 0.000704305617721, 0.000695125401315, 
  0.0006859706692900001, 0.0006767770023060001, 0.0006676099069870001, 
  0.000658403109971, 0.0006492240231480001, 0.0006400044149520001, 
  0.000630813711185, 0.0006215816086890001, 0.000612379665566, 
  0.0006031353833770002, 0.000593922581827, 0.0005846664319070002, 
  0.000575443156563, 0.0005661754478229999, 0.0005569420874380001, 
  0.000547663125244, 0.000538420073197, 0.0005291301588100001, 
  0.0005198778136869999, 0.0005105772435940001, 0.0005013160098910002, 
  0.0004920050750130001, 0.000482735363974, 0.000473414348719, 
  0.0004641365793480001, 0.000454805760474, 0.000445520360749, 
  0.0004361800060040001, 0.000426887414364, 0.000417537780803, 
  0.0004082384479770001, 0.000398879779903, 0.000389574171183, 
  0.000380206697588, 0.000370895295657, 0.000361519227013, 0.000352202535535, 
  0.000342818059725, 0.0003334966079179999, 0.0003241038849970001, 
  0.000314778233578, 0.000305377388968, 0.000296048137926, 0.000286639253418, 
  0.000277307052404, 0.000267890154064, 0.000258555716465, 0.000249130758095, 
  0.00023979488053, 0.00023036172051, 0.0002210253104289999, 
  0.00021158367854, 0.000202247794308, 0.000192797242851, 0.00018346315381, 
  0.000174002983098, 0.000164672262841, 0.000155201403123, 0.000145876080639, 
  0.000136392895911, 0.000127075713916, 0.000117577656234, 0.00010827254235, 
  0.000098755495818, 0.000089468498074, 0.00007992540675799999, 
  0.00007066677338799999, 0.00006108436171600001, 0.00005187396827599999, 
  0.00004222320224200001, 0.000033108671612, 0.000023306559435, 
  0.000014456273158, 0.000004106879400};

static const double w1024[2048] = 
{0.0000010267201349, 0.000003614078153, 0.0000058266822358, 
  0.000008277287868, 0.0000105560512268, 0.0000129689546232, 
  0.0000152718484261, 0.0000176678639431, 0.0000199830488169, 
  0.00002236950144909999, 0.0000246920749247, 0.00002707234996379999, 
  0.0000293998163854, 0.000031775744195, 0.0000341066579859, 
  0.00003647933390309999, 0.0000388127794938, 0.00004118290688819999, 
  0.0000435182649538, 0.0000458863191563, 0.00004822314875030001, 
  0.0000505894634912, 0.0000529274375272, 0.00005529225399979999, 
  0.00005763112138870001, 0.00005999461777240001, 0.00006233418013239999, 
  0.00006469649016380002, 0.00006703658682909999, 0.00006939781207430002, 
  0.0000717383100196, 0.0000740985281601, 0.00007643931512990001, 
  0.00007879858570449999, 0.0000811395653319, 0.0000834979339175, 
  0.0000858390222009, 0.0000881965234031, 0.0000905376460987, 
  0.000092894305822, 0.0000952353965032, 0.0000975912336275, 
  0.0000999322322036, 0.0001022872598897, 0.0001046281114413, 
  0.0001069823381753, 0.0001093229920727, 0.0001116764224281, 
  0.0001140168316016, 0.0001163694669018, 0.0001187095872872, 
  0.000121061426101, 0.0001234012161731, 0.0001257522547453, 
  0.0001280916751421, 0.0001304419077166, 0.0001327809209329, 
  0.0001351303400493, 0.0001374689101812, 0.0001398175068945, 
  0.0001421555994323, 0.000144503363513, 0.0001468409451514, 
  0.0001491878652544, 0.0001515249037515, 0.0001538709675518, 
  0.000156207431596, 0.000158552625897, 0.0001608884850018, 
  0.0001632327958556, 0.0001655680202671, 0.0001679114330409, 
  0.0001702459936595, 0.0001725884931234, 0.0001749223614209, 
  0.0001772639318146, 0.0001795970797946, 0.0001819377048693, 
  0.0001842701050006, 0.0001866097680849, 0.0001889413932551, 
  0.0001912800772938, 0.0001936109007799, 0.0001959485883606, 
  0.0001982785837832, 0.0002006152571886, 0.0002029443984835999, 
  0.0002052800397077, 0.0002076083011021, 0.0002099428918834, 
  0.0002122702478627, 0.0002146037697057, 0.0002169301950021, 
  0.0002192626291953, 0.0002215880987633, 0.0002239194264022, 
  0.0002262439153959, 0.0002285741174055, 0.0002308976011724, 
  0.0002332266583045, 0.000235549112366, 0.0002378770052329, 
  0.0002401984052717, 0.0002425251143475, 0.0002448454361965, 
  0.0002471709418313001, 0.0002494901614666, 0.0002518144438969, 
  0.0002541325374204, 0.0002564555767793, 0.0002587725204176, 
  0.000261094296742, 0.0002634100668395, 0.0002657305600728, 
  0.0002680451330769, 0.0002703643230897, 0.0002726776755528, 
  0.0002749955421376, 0.0002773076507006, 0.0002796241735810001, 
  0.0002819350149835, 0.0002842501738176, 0.0002865597248789, 
  0.0002888734992735, 0.0002911817368934999, 0.0002934941063989, 
  0.0002958010075546, 0.00029811195167, 0.0003004174934133, 
  0.0003027269915953, 0.0003050311510449, 0.0003073391827081, 
  0.0003096419370501, 0.000311948481572, 0.0003142498080537001, 
  0.0003165548447801, 0.0003188547207113, 0.0003211582289501, 
  0.0003234566316969, 0.0003257585907358, 0.0003280554977205, 
  0.000330355886814, 0.0003326512755111, 0.0003349500738948, 
  0.0003372439218314, 0.0003395411087189, 0.0003418333934734999, 
  0.0003441289480563, 0.0003464196472527, 0.0003487135487088, 
  0.0003510026400177001, 0.0003532948675099, 0.0003555823286471, 
  0.0003578728613235, 0.0003601586700489, 0.0003624474870461, 
  0.0003647316211617, 0.0003670187016064, 0.0003693011389556, 
  0.0003715864619671001, 0.000373867180433, 0.0003761507251218999, 
  0.0003784297026271, 0.0003807114481001, 0.0003829886626064, 
  0.0003852685879638, 0.0003875440174687999, 0.000389822101808, 
  0.0003920957243472001, 0.0003943719467654, 0.0003966437404096999, 
  0.0003989180800025, 0.0004011880228586, 0.0004034604587177999, 
  0.0004057285289275, 0.0004079990401501, 0.0004102652158877001, 
  0.0004125337815725001, 0.0004147980410476999, 0.0004170646402959, 
  0.0004193269617492001, 0.0004215915736647001, 0.0004238519353714, 
  0.0004261145390643, 0.0004283729193302001, 0.0004306334939158, 
  0.0004328898710798001, 0.0004351483956777001, 0.0004374027481099, 
  0.0004396592018487001, 0.0004419115079506001, 0.0004441658699664001, 
  0.0004464161081681001, 0.000448668357605, 0.0004509165063714001, 
  0.0004531666223823999, 0.0004554126602045, 0.0004576606219504001, 
  0.0004599045273518, 0.0004621503140077, 0.0004643920655419, 
  0.0004666356562892, 0.0004688752325388001, 0.0004711166065743, 
  0.0004733539861506001, 0.000475593122681, 0.0004778282842256, 
  0.0004800651624720001, 0.0004822980846544, 0.0004845326838479, 
  0.00048676334537, 0.0004889956447559002, 0.0004912240243462001, 
  0.0004934540031852001, 0.0004956800796021, 0.0004979077171697001, 
  0.0005001314691983999, 0.0005023567447842002, 0.0005045781512420002, 
  0.0005068010441506, 0.0005090200838811999, 0.0005112405734325, 
  0.0005134572253092001, 0.000515675290842, 0.0005178895337677, 
  0.0005201051546336, 0.0005223169675371999, 0.0005245301231096002, 
  0.000526739484951, 0.0005289501546180001, 0.0005311570443852, 
  0.0005333652075509, 0.0005355696042611, 0.0005377752403525001, 
  0.0005399771230496999, 0.0005421802115082, 0.0005443795592678001, 
  0.0005465800795575, 0.0005487768714818, 0.0005509748030828999, 
  0.0005531690183017, 0.0005553643407167, 0.0005575559583935, 
  0.0005597486511418, 0.0005619376504647001, 0.0005641276930889, 
  0.0005663140532768001, 0.0005685014253400001, 0.0005706851256377, 
  0.0005728698067239, 0.0005750508264085, 0.0005772327961225, 
  0.0005794111145002, 0.0005815903524677, 0.0005837659488724, 
  0.0005859424347417999, 0.0005881152885389, 0.0005902890019826, 
  0.0005924590925628, 0.0005946300132734001, 0.0005967973200613999, 
  0.0005989654277548002, 0.0006011299302019001, 0.0006032952046182001, 
  0.0006054568822065, 0.0006076193031103001, 0.0006097781353494001, 
  0.0006119376825260002, 0.0006140936489597, 0.0006162503022201001, 
  0.0006184033824193001, 0.0006205571215989001, 0.0006227072951635, 
  0.0006248581001232, 0.0006270053466857001, 0.0006291531973092001, 
  0.0006312974965312001, 0.0006334423727277, 0.0006355837043015001, 
  0.0006377255860086, 0.0006398639296551001, 0.0006420027968321001, 
  0.0006441381323067002, 0.00064627396494, 0.0006484062720258001, 
  0.0006505390501293001, 0.0006526683086415, 0.0006547980122544001, 
  0.0006569242020379001, 0.0006590508112268001, 0.0006611739121584, 
  0.0006632974070157, 0.0006654173990037, 0.0006675377596508002, 
  0.0006696546226352, 0.0006717718292191, 0.0006738855431695, 
  0.000675999575867, 0.0006781101207856001, 0.0006802209597988, 
  0.0006823283157216001, 0.0006844359412806, 0.0006865400882743, 
  0.0006886444806406001, 0.0006907453988018999, 0.0006928465382642001, 
  0.0006949442077251, 0.0006970420745982001, 0.0006991364755200002, 
  0.0007012310501522001, 0.0007033221627322001, 0.0007054134254989, 
  0.0007075012299635, 0.0007095891612698, 0.0007116736378796001, 
  0.0007137582181602, 0.0007158393472092001, 0.0007179205569293, 
  0.0007199983187437999, 0.0007220761383987, 0.0007241505133389002, 
  0.0007262249234538, 0.0007282958919129001, 0.0007303668730435, 
  0.0007324344154482, 0.0007345019481816, 0.0007365660449924999, 
  0.000738630109947, 0.0007406907416574001, 0.0007427513194836, 
  0.0007448084666213001, 0.0007468655379986, 0.0007489191811274999, 
  0.000750972726768, 0.0007530228464836999, 0.0007550728471326, 
  0.0007571194240656, 0.0007591658605006001, 0.0007612088753158, 
  0.0007632517283445001, 0.0007652911617442, 0.0007673304122075999, 
  0.0007693662449255, 0.0007714018736992001, 0.0007734340865039, 
  0.0007754660744961001, 0.0007774946481941001, 0.0007795229763433999, 
  0.0007815478917762001, 0.0007835725410557, 0.0007855937790983001, 
  0.0007876147305178, 0.0007896322720816002, 0.0007916495066812999, 
  0.0007936633327135999, 0.0007956768315689001, 0.0007976869230542, 
  0.0007996966672733002, 0.0008017030052311, 0.0008037089759584, 
  0.0008057115414437, 0.0008077137198586, 0.0008097124939637, 
  0.0008117108612778, 0.000813705825132, 0.0008157003625935, 
  0.0008176914973624, 0.0008196821862558, 0.0008216694731413, 
  0.0008236562947857, 0.0008256397150276, 0.0008276226507747, 
  0.0008296021856504, 0.0008315812168915, 0.0008335568477153, 
  0.0008355319558756, 0.0008375036639995, 0.0008394748305412, 
  0.0008414425973544, 0.0008434098037752, 0.0008453736107043, 
  0.0008473368385407, 0.0008492966670521, 0.0008512558978737, 
  0.0008532117294708, 0.000855166944888, 0.0008571187611113, 
  0.0008590699427676, 0.0008610177251996, 0.0008629648547788, 
  0.0008649085850374, 0.0008668516442596, 0.0008687913040026, 
  0.0008707302746258, 0.0008726658455502, 0.0008746007093698, 
  0.0008765321732121, 0.0008784629120614, 0.0008803902505963, 
  0.0008823168463482, 0.0008842400413906, 0.0008861624759542, 
  0.0008880815093588, 0.0008899997646833, 0.0008919146183443, 
  0.0008938286764169, 0.0008957393322684, 0.0008976491751163, 
  0.0008995556151319, 0.0009014612248194, 0.0009033634310141, 
  0.0009052647896478, 0.0009071627440764, 0.0009090598337985, 
  0.0009109535185564, 0.0009128463215527, 0.0009147357187759, 
  0.0009166242172685, 0.0009185093091348, 0.0009203934853885, 
  0.0009222742541149, 0.0009241540904325, 0.0009260305182794, 
  0.0009279059970055, 0.000929778066273, 0.000931649169793, 
  0.0009335168628229, 0.0009353835735623, 0.0009372468727382, 
  0.0009391091731621, 0.0009409680609109, 0.0009428259335274, 
  0.0009446803923159, 0.0009465338196736, 0.0009483838320125, 
  0.0009502327967006, 0.0009520783451411, 0.0009539228297923, 
  0.0009557638969289, 0.0009576038842148, 0.0009594404526861, 
  0.0009612759253222, 0.0009631079778069, 0.0009649389185515, 
  0.0009667664377733, 0.0009685928294243, 0.0009704157981486, 
  0.0009722376235493, 0.0009740560245853, 0.0009758732666188, 
  0.0009776870828188, 0.000979499724413, 0.0009813089386745, 
  0.0009831169627996, 0.0009849215580613, 0.0009867249477291, 
  0.0009885249069755, 0.0009903236452431, 0.000992118951501, 
  0.0009939130214691, 0.0009957036578116, 0.0009974930426215, 
  0.0009992789921649, 0.001001063675005, 0.0010028449209081, 
  0.0010046248850097, 0.0010064014104799, 0.0010081766391172, 
  0.0010099484274034, 0.0010117189038959, 0.001013485938294, 
  0.001015251646005, 0.0010170139098547, 0.0010187748321932, 
  0.0010205323088801, 0.0010222884292983, 0.0010240411022522, 
  0.0010257924042479, 0.0010275402569463, 0.0010292867240631, 
  0.0010310297400271, 0.0010327713558527, 0.0010345095186506, 
  0.0010362462668183, 0.0010379795600631, 0.0010397114242514, 
  0.0010414398316042, 0.0010431667955372, 0.001044890300704, 
  0.0010466123481535, 0.0010483309348854, 0.0010500480496677, 
  0.0010517617017652, 0.0010534738677412, 0.0010551825690506, 
  0.0010568897701308, 0.0010585935045443, 0.0010602957246832, 
  0.0010619944761406, 0.0010636916993395, 0.0010653854518283, 
  0.0010670776621364, 0.0010687663996904, 0.0010704535812046, 
  0.0010721372879059, 0.0010738194247664, 0.0010754980847443, 
  0.0010771751611424, 0.0010788487585742, 0.0010805207587474, 
  0.0010821892778573, 0.0010838561860899, 0.0010855196111517, 
  0.0010871814117761, 0.0010888397271116, 0.0010904964045086, 
  0.0010921495944862, 0.0010938011330838, 0.0010954491821218, 
  0.0010970955663968, 0.0010987384589628, 0.0011003796734386, 
  0.001102017394048, 0.0011036534232985, 0.0011052859565162, 
  0.0011069167851629, 0.0011085441156007, 0.0011101697283148, 
  0.0011117918406356, 0.001113412222136, 0.0011150291010526, 
  0.0011166442361077, 0.0011182558663821, 0.0011198657398082, 
  0.001121472106251, 0.001123076702916, 0.001124677790387, 
  0.0011262770952073, 0.0011278728886178, 0.0011294668865599, 
  0.0011310573708708, 0.0011326460469489, 0.0011342312071715, 
  0.0011358145464514, 0.0011373943676465, 0.0011389723552438, 
  0.0011405468225232, 0.0011421194436039, 0.00114368854213, 
  0.0011452557819105, 0.0011468194968953, 0.0011483813406421, 
  0.0011499396573496, 0.001151496090379, 0.001153048994126, 
  0.0011546000018062, 0.001156147477957, 0.0011576930457071, 
  0.0011592350796791, 0.0011607751929685, 0.0011623117702301, 
  0.0011638464145793, 0.001165377520652, 0.0011669066816342, 
  0.0011684323020882, 0.0011699559653267, 0.0011714760857867, 
  0.0011729942369562, 0.0011745088430971, 0.0011760214679259, 
  0.0011775305454761, 0.0011790376297411, 0.0011805411644797, 
  0.0011820426940131, 0.0011835406717735, 0.0011850366324576, 
  0.0011865290391238, 0.0011880194168933, 0.0011895062384025, 
  0.0011909910192467, 0.0011924722415883, 0.001193951411545, 
  0.0011954270207623, 0.0011969005659265, 0.0011983705481164, 
  0.0011998384546307, 0.0012013027959414, 0.0012027650500073, 
  0.0012042237366398, 0.0012056803245078, 0.0012071333427188, 
  0.001208584250693, 0.0012100315867916, 0.0012114768012305, 
  0.0012129184415789, 0.0012143579488936, 0.0012157938799093, 
  0.0012172276665647, 0.001218657874717, 0.0012200859272324, 
  0.0012215103990457, 0.0012229327039941, 0.0012243514260466, 
  0.001225767970053, 0.0012271809289786, 0.0012285916987246, 
  0.0012299988812099, 0.0012314038634303, 0.0012328052562166, 
  0.0012342044377008, 0.001235600027583, 0.0012369933951741, 
  0.0012383831690061, 0.0012397707096026, 0.001241154654288, 
  0.0012425363548424, 0.0012439144573428, 0.0012452903048643, 
  0.0012466625521949, 0.0012480325337453, 0.0012493989129785, 
  0.0012507630156754, 0.0012521235139372, 0.0012534817249539, 
  0.0012548363294262, 0.0012561886359897, 0.0012575373339116, 
  0.0012588837233079, 0.0012602265019704, 0.0012615669615381, 
  0.0012629038082915, 0.0012642383254258, 0.0012655692276757, 
  0.0012668977898263, 0.0012682227350331, 0.0012695453297086, 
  0.0012708643053902, 0.0012721809201527, 0.0012734939138828, 
  0.0012748045363509, 0.0012761115357594, 0.0012774161536091, 
  0.0012787171463824, 0.0012800157473462, 0.0012813107212269, 
  0.0012826032930927, 0.0012838922358818, 0.0012851787664945, 
  0.0012864616660486, 0.001287742143309, 0.0012890189875429, 
  0.0012902933994099, 0.0012915641762928, 0.0012928325107835, 
  0.001294097208344, 0.0012953594535304, 0.0012966180598556, 
  0.0012978742038651, 0.0012991267070969, 0.0013003767381204, 
  0.0013016231264594, 0.0013028670327379, 0.0013041072944422, 
  0.0013053450642825, 0.0013065791876681, 0.0013078108094239, 
  0.0013090387828651, 0.0013102642449598, 0.0013114860568872, 
  0.0013127053477924, 0.0013139209866972, 0.0013151340949503, 
  0.0013163435493791, 0.0013175504635668, 0.0013187537221262, 
  0.0013199544309032, 0.0013211514822598, 0.0013223459743298, 
  0.001323536807205, 0.0013247250713385, 0.0013259096745159, 
  0.0013270916995335, 0.0013282700618522, 0.0013294458366419, 
  0.0013306179470023, 0.0013317874605023, 0.0013329533078624, 
  0.0013341165490792, 0.0013352761224566, 0.0013364330804449, 
  0.0013375863689172, 0.0013387370328009, 0.0013398840255023, 
  0.0013410283844559, 0.001342169070582, 0.0013433071138475, 
  0.0013444414826535, 0.0013455731995231, 0.0013467012403236, 
  0.0013478266201585, 0.0013489483223265, 0.0013500673545378, 
  0.001351182707507, 0.0013522953815758, 0.0013534043748393, 
  0.0013545106802965, 0.0013556133034103, 0.0013567132298527, 
  0.0013578094724267, 0.0013589030095095, 0.0013599928612208, 
  0.0013610799986605, 0.0013621634492373, 0.001363244176809, 
  0.0013643212160519, 0.0013653955235913, 0.0013664661413488, 
  0.0013675340187517, 0.0013685982049444, 0.0013696596421675, 
  0.0013707173867657, 0.0013717723738268, 0.0013728236668724, 
  0.0013738721938491, 0.0013749170254326, 0.0013759590824634, 
  0.0013769974427502, 0.0013780330200332, 0.0013790648992356, 
  0.0013800939870327, 0.0013811193754367, 0.0013821419640683, 
  0.00138316085201, 0.0013841769318578, 0.0013851893097455, 
  0.001386198871254, 0.0013872047295453, 0.0013882077632189, 
  0.0013892070924449, 0.0013902035888502, 0.0013911963795923, 
  0.0013921863293562, 0.0013931725722684, 0.001394155966081, 
  0.0013951356518679, 0.0013961124804794, 0.0013970855999184, 
  0.0013980558541411, 0.0013990223980608, 0.0013999860687692, 
  0.0014009460280714, 0.0014019031062022, 0.0014028564718375, 
  0.0014038069483891, 0.0014047537113852, 0.0014056975774166, 
  0.0014066377288487, 0.0014075749754838, 0.0014085085065016, 
  0.0014094391249252, 0.0014103660267303, 0.0014112900081889, 
  0.0014122102720574, 0.0014131276078593, 0.0014140412251169, 
  0.001414951906635, 0.0014158588686814, 0.0014167628873507, 
  0.0014176631856369, 0.001418560532954, 0.001419454159007, 
  0.001420344826532, 0.0014212317719277, 0.0014221157512836, 
  0.0014229960076739, 0.0014238732905457, 0.0014247468496332, 
  0.0014256174277692, 0.0014264842813338, 0.001427348146546, 
  0.0014282082864138, 0.0014290654305773, 0.0014299188486551, 
  0.0014307692637061, 0.0014316159519485, 0.00143245962989, 
  0.0014332995803283, 0.0014341365132238, 0.0014349697179405, 
  0.0014357998979183, 0.0014366263490716, 0.0014374497683239, 
  0.0014382694581224, 0.0014390861089034, 0.001439899029634, 
  0.0014407089042621, 0.0014415150482614, 0.0014423181391195, 
  0.0014431174988008, 0.0014439137983352, 0.0014447063661625, 
  0.0014454958668836, 0.0014462816353993, 0.0014470643298805, 
  0.0014478432916761, 0.0014486191725552, 0.0014493913203016, 
  0.0014501603802819, 0.0014509257066979, 0.0014516879385444, 
  0.0014524464364312, 0.0014532018329737, 0.001453953495178, 
  0.0014547020493118, 0.0014554468687618, 0.0014561885734467, 
  0.0014569265431195, 0.001457661391379, 0.0014583925043322, 
  0.0014591204892533, 0.001459844738592, 0.0014605658533274, 
  0.0014612832322395, 0.0014619974700068, 0.001462707971725, 
  0.0014634153258071, 0.0014641189436489, 0.0014648194073911, 
  0.0014655161347212, 0.0014662097015349, 0.0014668995318001, 
  0.00146758619516, 0.001468269121855, 0.0014689488753082, 
  0.0014696248920039, 0.0014702977291481, 0.0014709668294773, 
  0.0014716327439917, 0.0014722949216535, 0.0014729539072654, 
  0.0014736091560208, 0.0014742612065419, 0.0014749095202221, 
  0.0014755546295076, 0.001476196002006, 0.0014768341639992, 
  0.0014774685892725, 0.0014780997979607, 0.001478727270037, 
  0.0014793515194922, 0.0014799720324594, 0.0014805893167997, 
  0.0014812028648137, 0.0014818131782439, 0.0014824197555271, 
  0.0014830230922941, 0.0014836226931327, 0.0014842190475739, 
  0.0014848116663209, 0.0014854010328152, 0.0014859866638888, 
  0.0014865690369032, 0.001487147674788, 0.0014877230488339, 
  0.0014882946880798, 0.0014888630577555, 0.0014894276929791, 
  0.0014899890529271, 0.00149054667881, 0.0014911010237618, 
  0.001491651635052, 0.0014921989597814, 0.0014927425512926, 
  0.001493282850663, 0.0014938194172769, 0.0014943526861939, 
  0.0014948822228562, 0.0014954084563158, 0.001495930958039, 
  0.001496450151079, 0.001496965612942, 0.0014974777606916, 
  0.0014979861778393, 0.0014984912754672, 0.0014989926431119, 
  0.0014994906858813, 0.0014999849992999, 0.0015004759825121, 
  0.0015009632370507, 0.0015014471560996, 0.0015019273471676, 
  0.00150240419749, 0.0015028773205653, 0.0015033470976872, 
  0.0015038131483139, 0.0015042758478039, 0.0015047348215929, 
  0.0015051904391108, 0.0015056423317394, 0.0015060908629875, 
  0.0015065356701985, 0.0015069771109707, 0.001507414828576, 
  0.0015078491747061, 0.0015082797985827, 0.0015087070459989, 
  0.0015091305720914, 0.0015095507167601, 0.0015099671410794, 
  0.001510380179064, 0.0015107894976883, 0.0015111954250876, 
  0.0015115976341619, 0.0015119964471724, 0.0015123915429089, 
  0.0015127832377653, 0.0015131712164421, 0.0015135557894746, 
  0.0015139366474379, 0.0015143140950123, 0.0015146878286765, 
  0.00151505814726, 0.0015154247531035, 0.0015157879391949, 
  0.0015161474137654, 0.0015165034639663, 0.0015168558038784, 
  0.0015172047148204, 0.0015175499167555, 0.0015178916851774, 
  0.0015182297458837, 0.0015185643685508, 0.0015188952848452, 
  0.0015192227586281, 0.0015195465273936, 0.0015198668491923, 
  0.0015201834673807, 0.0015204966342025, 0.0015208060988313, 
  0.0015211121077091, 0.0015214144158637, 0.0015217132639419, 
  0.0015220084127742, 0.001522300097218, 0.0015225880839492, 
  0.0015228726020381, 0.0015231534239562, 0.0015234307729904, 
  0.0015237044274493, 0.0015239746048439, 0.0015242410892674, 
  0.001524504092456, 0.0015247634043346, 0.0015250192308681, 
  0.0015252713677588, 0.0015255200152061, 0.0015257649747347, 
  0.0015260064407818, 0.0015262442206411, 0.0015264785029901, 
  0.0015267091009549, 0.0015269361974164, 0.0015271596112855, 
  0.0015273795197221, 0.0015275957474214, 0.0015278084657655, 
  0.0015280175052276, 0.0015282230314779, 0.0015284248807664, 
  0.0015286232129889, 0.00152881787017, 0.0015290090064978, 
  0.0015291964697724, 0.0015293804084099, 0.0015295606759765, 
  0.0015297374151917, 0.0015299104853888, 0.00153008002352, 
  0.0015302458946802, 0.0015304082301319, 0.0015305669007319, 
  0.0015307220319779, 0.0015308735004827, 0.001531021426061, 
  0.0015311656910869, 0.0015313064096087, 0.0015314434697514, 
  0.0015315769798914, 0.0015317068339073, 0.0015318331344098, 
  0.0015319557810256, 0.0015320748707012, 0.0015321903088149, 
  0.0015323021865445, 0.0015324104150114, 0.0015325150797401, 
  0.0015326160976012, 0.0015327135483452, 0.0015328073545841, 
  0.0015328975904242, 0.0015329841842259, 0.0015330672043136, 
  0.0015331465847847, 0.0015332223883352, 0.0015332945548103, 
  0.001533363141111, 0.0015334280928148, 0.0015334894612126, 
  0.001533547197631, 0.0015336013475455, 0.0015336518680145, 
  0.0015336987989222, 0.0015337421030831, 0.0015337818145289, 
  0.0015338179017975, 0.0015338503933635, 0.0015338792635338, 
  0.0015339045348425, 0.001533926187278, 0.0015339442378248, 
  0.0015339586721857, 0.0015339695007401, 0.0015339767129889, 
  0.0015339802956898, 0.001533980376718, 0.0015339767399982, 
  0.0015339695169457, 0.001533958683761, 0.0015339442468286, 
  0.0015339261946436, 0.0015339045410748, 0.0015338792689351, 
  0.0015338503981285, 0.0015338179060609, 0.001533781818387, 
  0.0015337421066056, 0.0015336988021629, 0.0015336518710152, 
  0.0015336013503402, 0.0015335472002454, 0.0015334894636676, 
  0.0015334280951294, 0.0015333631432998, 0.0015332945568876, 
  0.0015332223903119, 0.001533146586668, 0.0015330672061134, 
  0.0015329841859489, 0.001532897592077, 0.0015328073561719, 
  0.0015327135498731, 0.0015326160990735, 0.0015325150811608, 
  0.001532410416383, 0.0015323021878711, 0.0015321903100993, 
  0.0015320748719462, 0.0015319557822333, 0.0015318331355826, 
  0.0015317068350469, 0.0015315769809991, 0.0015314434708294, 
  0.0015313064106595, 0.0015311656921104, 0.0015310214270592, 
  0.0015308735014561, 0.0015307220329284, 0.0015305669016605, 
  0.0015304082310384, 0.0015302458955667, 0.0015300800243875, 
  0.0015299104862379, 0.0015297374160233, 0.0015295606767913, 
  0.0015293804092087, 0.0015291964705555, 0.001529009007266, 
  0.0015288178709227, 0.0015286232137279, 0.001528424881492, 
  0.0015282230321907, 0.0015280175059289, 0.0015278084664539, 
  0.0015275957480981, 0.0015273795203877, 0.0015271596119393, 
  0.0015269361980598, 0.0015267091015881, 0.0015264785036144, 
  0.0015262442212549, 0.0015260064413872, 0.0015257649753303, 
  0.001525520015793, 0.0015252713683372, 0.0015250192314383, 
  0.0015247634048968, 0.0015245040930105, 0.0015242410898143, 
  0.0015239746053828, 0.0015237044279817, 0.0015234307735151, 
  0.0015231534244741, 0.0015228726025494, 0.001522588084454, 
  0.0015223000977166, 0.0015220084132666, 0.0015217132644277, 
  0.0015214144163436, 0.0015211121081833, 0.0015208060992999, 
  0.0015204966346657, 0.0015201834678386, 0.0015198668496451, 
  0.0015195465278412, 0.0015192227590695, 0.001518895285283, 
  0.0015185643689827, 0.0015182297463121, 0.0015178916856001, 
  0.0015175499171749, 0.0015172047152355, 0.001516855804288, 
  0.0015165034643717, 0.0015161474141668, 0.0015157879395923, 
  0.0015154247534958, 0.0015150581476485, 0.0015146878290611, 
  0.0015143140953944, 0.0015139366478164, 0.0015135557898484, 
  0.0015131712168123, 0.0015127832381322, 0.0015123915432724, 
  0.0015119964475326, 0.0015115976345178, 0.0015111954254404, 
  0.001510789498038, 0.0015103801794106, 0.001509967141423, 
  0.0015095507171007, 0.0015091305724291, 0.0015087070463337, 
  0.0015082797989147, 0.0015078491750354, 0.0015074148289024, 
  0.0015069771112946, 0.0015065356705197, 0.0015060908633052, 
  0.0015056423320545, 0.0015051904394243, 0.0015047348219031, 
  0.0015042758481116, 0.0015038131486193, 0.0015033470979902, 
  0.001502877320866, 0.0015024041977875, 0.0015019273474637, 
  0.0015014471563935, 0.0015009632373416, 0.0015004759828008, 
  0.0014999849995873, 0.0014994906861659, 0.0014989926433944, 
  0.0014984912757477, 0.001497986178117, 0.0014974777609673, 
  0.0014969656132157, 0.0014964501513509, 0.001495930958309, 
  0.0014954084565839, 0.0014948822231225, 0.0014943526864584, 
  0.0014938194175396, 0.001493282850924, 0.0014927425515518, 
  0.0014921989600381, 0.001491651635307, 0.0014911010240152, 
  0.0014905466790617, 0.0014899890531772, 0.0014894276932268, 
  0.0014888630580017, 0.0014882946883251, 0.001487723049077, 
  0.0014871476750296, 0.0014865690371434, 0.0014859866641274, 
  0.0014854010330524, 0.0014848116665559, 0.0014842190478075, 
  0.0014836226933662, 0.0014830230925249, 0.0014824197557564, 
  0.001481813178472, 0.0014812028650404, 0.0014805893170251, 
  0.0014799720326822, 0.0014793515197136, 0.0014787272702572, 
  0.0014780997981809, 0.0014774685894914, 0.0014768341642157, 
  0.0014761960022212, 0.0014755546297229, 0.0014749095204349, 
  0.0014742612067535, 0.0014736091562313, 0.0014729539074747, 
  0.0014722949218605, 0.0014716327441987, 0.0014709668296831, 
  0.0014702977293518, 0.0014696248922075, 0.0014689488755109, 
  0.0014682691220553, 0.0014675861953606, 0.0014668995319983, 
  0.0014662097017322, 0.0014655161349174, 0.0014648194075863, 
  0.001464118943843, 0.0014634153259992, 0.0014627079719172, 
  0.0014619974701981, 0.0014612832324286, 0.0014605658535167, 
  0.0014598447387793, 0.0014591204894396, 0.0014583925045176, 
  0.0014576613915636, 0.001456926543303, 0.0014561885736295, 
  0.0014554468689436, 0.0014547020494927, 0.001453953495357, 
  0.0014532018331518, 0.0014524464366084, 0.0014516879387209, 
  0.0014509257068746, 0.0014501603804567, 0.0014493913204766, 
  0.0014486191727284, 0.0014478432918484, 0.0014470643300521, 
  0.0014462816355701, 0.0014454958670536, 0.0014447063663317, 
  0.0014439137985037, 0.0014431174989684, 0.0014423181392855, 
  0.0014415150484266, 0.0014407089044266, 0.0014398990297977, 
  0.0014390861090664, 0.0014382694582846, 0.0014374497684855, 
  0.0014366263492324, 0.0014357998980785, 0.001434969718099, 
  0.0014341365133826, 0.0014332995804854, 0.0014324596300465, 
  0.0014316159521042, 0.0014307692638613, 0.0014299188488086, 
  0.0014290654307311, 0.0014282082865669, 0.0014273481466977, 
  0.0014264842814848, 0.0014256174279205, 0.0014247468497839, 
  0.0014238732906948, 0.0014229960078224, 0.0014221157514315, 
  0.001421231772075, 0.0014203448266788, 0.0014194541591531, 
  0.0014185605330996, 0.0014176631857818, 0.0014167628874951, 
  0.0014158588688243, 0.0014149519067773, 0.0014140412252586, 
  0.0014131276080005, 0.0014122102721981, 0.0014112900083291, 
  0.0014103660268698, 0.0014094391250642, 0.0014085085066401, 
  0.001407574975621, 0.0014066377289852, 0.0014056975775535, 
  0.0014047537115207, 0.0014038069485242, 0.001402856471972, 
  0.0014019031063363, 0.001400946028204, 0.0013999860689022, 
  0.0013990223981924, 0.0013980558542723, 0.0013970856000491, 
  0.0013961124806096, 0.0013951356519976, 0.0013941559662103, 
  0.001393172572394, 0.0013921863294869, 0.0013911963797194, 
  0.0013902035889737, 0.0013892070925718, 0.0013882077633446, 
  0.0013872047296736, 0.0013861988713789, 0.0013851893098667, 
  0.0013841769319841, 0.0013831608521327, 0.0013821419641883, 
  0.0013811193755593, 0.0013800939871542, 0.0013790648993596, 
  0.0013780330201538, 0.0013769974428673, 0.0013759590825854, 
  0.0013749170255519, 0.0013738721939643, 0.0013728236669902, 
  0.0013717723739442, 0.0013707173868856, 0.0013696596422841, 
  0.0013685982050576, 0.0013675340188697, 0.0013664661414634, 
  0.0013653955237027, 0.0013643212161658, 0.0013632441769225, 
  0.0013621634493533, 0.0013610799987733, 0.0013599928613303, 
  0.0013589030096237, 0.0013578094725376, 0.0013567132299612, 
  0.0013556133035212, 0.0013545106804063, 0.0013534043749515, 
  0.001352295381685, 0.0013511827076157, 0.001350067354649, 
  0.0013489483224339, 0.0013478266202635, 0.001346701240433, 
  0.0013455731996308, 0.0013444414827588, 0.0013433071139545, 
  0.0013421690706886, 0.0013410283845643, 0.0013398840256076, 
  0.0013387370329039, 0.0013375863690239, 0.0013364330805493, 
  0.0013352761225587, 0.0013341165491829, 0.0013329533079657, 
  0.0013317874606074, 0.0013306179471044, 0.0013294458367411, 
  0.001328270061955, 0.0013270916996334, 0.0013259096746141, 
  0.0013247250714391, 0.0013235368073052, 0.001322345974431, 
  0.0013211514823594, 0.001319954431, 0.0013187537222265, 0.0013175504636643, 
  0.0013163435494738, 0.0013151340950472, 0.0013139209867938, 
  0.0013127053478912, 0.0013114860569832, 0.0013102642450531, 
  0.0013090387829618, 0.0013078108095191, 0.0013065791877592, 
  0.0013053450643759, 0.0013041072945353, 0.0013028670328333, 
  0.0013016231265519, 0.0013003767382116, 0.0012991267071914, 
  0.001297874203957, 0.0012966180599447, 0.0012953594536217, 
  0.001294097208435, 0.0012928325108755, 0.0012915641763833, 
  0.0012902933994989, 0.0012890189876329, 0.0012877421433976, 
  0.0012864616661357, 0.0012851787665837, 0.0012838922359696, 
  0.0012826032931826, 0.0012813107213141, 0.0012800157474322, 
  0.0012787171464703, 0.0012774161536957, 0.0012761115358434, 
  0.0012748045364382, 0.0012734939139675, 0.0012721809202396, 
  0.0012708643054744, 0.0012695453297927, 0.0012682227351192, 
  0.0012668977899099, 0.0012655692277567, 0.0012642383255101, 
  0.0012629038083733, 0.0012615669616231, 0.0012602265020528, 
  0.0012588837233891, 0.0012575373339947, 0.0012561886360715, 
  0.0012548363295056, 0.0012534817250353, 0.0012521235140172, 
  0.0012507630157575, 0.0012493989130592, 0.0012480325338237, 
  0.0012466625522751, 0.0012452903049433, 0.0012439144574205, 
  0.001242536354922, 0.0012411546543652, 0.0012397707096819, 
  0.001238383169083, 0.0012369933952508, 0.0012356000276605, 
  0.0012342044377771, 0.0012328052562906, 0.0012314038635073, 
  0.0012299988812845, 0.0012285916988023, 0.0012271809290539, 
  0.0012257679701272, 0.0012243514261215, 0.0012229327040679, 
  0.0012215103991182, 0.0012200859273078, 0.0012186578747901, 
  0.0012172276666398, 0.0012157938799821, 0.0012143579489663, 
  0.0012129184416523, 0.0012114768013028, 0.0012100315868616, 
  0.0012085842507659, 0.0012071333427895, 0.0012056803245804, 
  0.0012042237367111, 0.0012027650500775, 0.0012013027960124, 
  0.0011998384547016, 0.001198370548184, 0.001196900565997, 
  0.0011954270208316, 0.0011939514116161, 0.0011924722416572, 
  0.0011909910193145, 0.0011895062384721, 0.0011880194169619, 
  0.0011865290391901, 0.0011850366325258, 0.0011835406718414, 
  0.001182042694079, 0.0011805411645473, 0.0011790376298077, 
  0.0011775305455434, 0.0011760214679922, 0.0011745088431631, 
  0.0011729942370231, 0.0011714760858524, 0.0011699559653904, 
  0.0011684323021536, 0.0011669066816986, 0.001165377520718, 
  0.0011638464146443, 0.001162311770294, 0.0011607751930332, 
  0.0011592350797427, 0.0011576930457687, 0.0011561474780203, 
  0.0011546000018685, 0.0011530489941898, 0.0011514960904419, 
  0.0011499396574113, 0.0011483813407047, 0.0011468194969568, 
  0.0011452557819701, 0.0011436885421921, 0.001142119443665, 
  0.001140546822585, 0.0011389723553046, 0.0011373943677062, 
  0.001135814546512, 0.0011342312072309, 0.0011326460470073, 
  0.0011310573709309, 0.0011294668866181, 0.0011278728886785, 
  0.0011262770952661, 0.0011246777904447, 0.0011230767029746, 
  0.0011214721063085, 0.0011198657398648, 0.0011182558664402, 
  0.0011166442361649, 0.0011150291011113, 0.0011134122221929, 
  0.0011117918406923, 0.0011101697283714, 0.0011085441156572, 
  0.0011069167852176, 0.0011052859565725, 0.0011036534233538, 
  0.0011020173941049, 0.0011003796734945, 0.0010987384590177, 
  0.0010970955664525, 0.0010954491821772, 0.0010938011331375, 
  0.0010921495945415, 0.0010904964045621, 0.0010888397271666, 
  0.0010871814118303, 0.0010855196112056, 0.0010838561861438, 
  0.0010821892779102, 0.0010805207587994, 0.0010788487586277, 
  0.0010771751611949, 0.0010754980847975, 0.0010738194248187, 
  0.0010721372879572, 0.0010704535812567, 0.0010687663997423, 
  0.0010670776621875, 0.00106538545188, 0.0010636916993903, 
  0.0010619944761929, 0.0010602957247338, 0.0010585935045939, 
  0.0010568897701821, 0.0010551825691008, 0.0010534738677906, 
  0.0010517617018161, 0.0010500480497169, 0.0010483309349361, 
  0.0010466123482025, 0.0010448903007529, 0.0010431667955868, 
  0.0010414398316528, 0.0010397114242984, 0.0010379795601115, 
  0.0010362462668659, 0.0010345095186996, 0.0010327713559009, 
  0.0010310297400743, 0.0010292867241111, 0.0010275402569933, 
  0.0010257924042942, 0.0010240411022998, 0.0010222884293444, 
  0.0010205323089275, 0.0010187748322398, 0.0010170139099004, 
  0.0010152516460515, 0.0010134859383395, 0.0010117189039406, 
  0.0010099484274495, 0.0010081766391617, 0.0010064014105258, 
  0.0010046248850548, 0.0010028449209531, 0.00100106367505, 
  0.0009992789922089, 0.0009974930426655, 0.0009957036578562, 
  0.0009939130215129, 0.0009921189515462, 0.0009903236452867, 
  0.0009885249070182, 0.0009867249477726, 0.0009849215581038, 
  0.0009831169628414, 0.0009813089387176, 0.0009794997244554, 
  0.0009776870828625, 0.0009758732666617, 0.0009740560246266, 
  0.000972237623592, 0.0009704157981897, 0.0009685928294654, 
  0.0009667664378149, 0.000964938918593, 0.0009631079778471, 
  0.0009612759253644, 0.0009594404527268, 0.0009576038842562, 
  0.0009557638969694, 0.0009539228298321, 0.0009520783451814, 
  0.0009502327967409, 0.0009483838320513, 0.0009465338197137, 
  0.0009446803923552, 0.0009428259335681, 0.0009409680609508, 
  0.0009391091732013, 0.0009372468727779, 0.0009353835736006, 
  0.0009335168628604, 0.0009316491698325, 0.000929778066311, 
  0.0009279059970449, 0.0009260305183173, 0.0009241540904697, 
  0.0009222742541527, 0.0009203934854262, 0.000918509309171, 
  0.0009166242173067, 0.0009147357188126, 0.0009128463215908, 
  0.0009109535185942, 0.0009090598338351, 0.0009071627441135, 
  0.0009052647896843, 0.0009033634310498, 0.0009014612248564, 
  0.0008995556151674, 0.0008976491751532, 0.0008957393323044, 
  0.0008938286764522, 0.0008919146183802, 0.0008899997647186, 
  0.0008880815093932, 0.00088616247599, 0.0008842400414249, 
  0.0008823168463832, 0.0008803902506311, 0.0008784629120956, 
  0.0008765321732468, 0.0008746007094039, 0.0008726658455834, 
  0.0008707302746597, 0.0008687913040363, 0.0008668516442941, 
  0.0008649085850704, 0.0008629648548118, 0.0008610177252331, 
  0.0008590699428012, 0.0008571187611434, 0.0008551669449202, 
  0.0008532117295028, 0.000851255897907, 0.0008492966670846, 
  0.0008473368385726, 0.0008453736107367, 0.0008434098038076, 
  0.0008414425973854, 0.0008394748305729, 0.0008375036640304, 
  0.0008355319559078, 0.0008335568477466, 0.0008315812169223, 
  0.0008296021856816, 0.0008276226508054, 0.0008256397150574, 
  0.0008236562948156, 0.0008216694731716, 0.0008196821862869, 
  0.0008176914973927, 0.0008157003626232, 0.0008137058251616, 
  0.0008117108613067, 0.0008097124939919, 0.0008077137198875, 
  0.0008057115414724, 0.0008037089759878, 0.0008017030052591, 
  0.0007996966673020001, 0.0007976869230827001, 0.0007956768315969001, 
  0.0007936633327414001, 0.0007916495067092001, 0.0007896322721093001, 
  0.0007876147305461001, 0.0007855937791258999, 0.0007835725410834, 
  0.0007815478918037, 0.0007795229763703001, 0.0007774946482203, 
  0.0007754660745230001, 0.0007734340865312001, 0.000771401873726, 
  0.0007693662449521, 0.0007673304122342001, 0.0007652911617707002, 
  0.0007632517283711, 0.0007612088753416, 0.0007591658605270001, 
  0.0007571194240919001, 0.0007550728471595001, 0.0007530228465093001, 
  0.0007509727267936001, 0.0007489191811531, 0.0007468655380242001, 
  0.0007448084666468001, 0.0007427513195091001, 0.0007406907416828, 
  0.0007386301099724, 0.0007365660450172001, 0.0007345019482063, 
  0.0007324344154734, 0.0007303668730681001, 0.0007282958919368001, 
  0.0007262249234778001, 0.0007241505133633, 0.0007220761384226, 
  0.0007199983187676001, 0.0007179205569531, 0.0007158393472328001, 
  0.0007137582181838999, 0.0007116736379027, 0.0007095891612934002, 
  0.0007075012299863999, 0.0007054134255212999, 0.0007033221627549999, 
  0.0007012310501756001, 0.0006991364755434, 0.0006970420746211002, 
  0.0006949442077467, 0.0006928465382864001, 0.0006907453988245999, 
  0.0006886444806627001, 0.0006865400882968, 0.0006844359413027, 
  0.0006823283157441001, 0.0006802209598202001, 0.0006781101208074001, 
  0.0006759995758884001, 0.0006738855431912, 0.0006717718292399, 
  0.0006696546226563001, 0.0006675377596725001, 0.0006654173990259, 
  0.0006632974070369002, 0.0006611739121789002, 0.0006590508112479001, 
  0.0006569242020582, 0.0006547980122748, 0.0006526683086618001, 
  0.0006505390501496001, 0.0006484062720465001, 0.0006462739649608001, 
  0.0006441381323263001, 0.0006420027968518, 0.0006398639296750999, 
  0.0006377255860276, 0.0006355837043215001, 0.0006334423727472, 
  0.0006312974965512, 0.0006291531973286999, 0.0006270053467045001, 
  0.0006248581001426001, 0.0006227072951827, 0.0006205571216178, 
  0.0006184033824385001, 0.0006162503022388001, 0.0006140936489783, 
  0.0006119376825447, 0.0006097781353679001, 0.0006076193031289, 
  0.0006054568822249001, 0.0006032952046367001, 0.0006011299302203001, 
  0.0005989654277733001, 0.0005967973200797, 0.0005946300132914, 
  0.0005924590925805, 0.0005902890020005001, 0.0005881152885566001, 
  0.0005859424347596, 0.00058376594889, 0.0005815903524854999, 
  0.0005794111145173, 0.0005772327961396999, 0.0005750508264255, 
  0.0005728698067415002, 0.0005706851256545999, 0.0005685014253566, 
  0.0005663140532932, 0.0005641276931054, 0.0005619376504815001, 
  0.0005597486511582, 0.0005575559584098001, 0.0005553643407336001, 
  0.000553169018318, 0.0005509748030987001, 0.0005487768714979, 
  0.0005465800795733, 0.0005443795592839001, 0.0005421802115244, 
  0.0005399771230652001, 0.0005377752403681, 0.0005355696042761, 
  0.0005333652075655, 0.0005311570444001, 0.0005289501546331001, 
  0.0005267394849664, 0.0005245301231246, 0.0005223169675521, 
  0.0005201051546486001, 0.0005178895337820001, 0.0005156752908565001, 
  0.0005134572253235001, 0.0005112405734469001, 0.0005090200838959001, 
  0.000506801044165, 0.0005045781512557001, 0.0005023567447985, 
  0.0005001314692125001, 0.0004979077171835, 0.0004956800796157, 
  0.0004934540031989, 0.0004912240243602, 0.0004889956447695, 
  0.0004867633453835, 0.0004845326838615, 0.0004822980846674, 
  0.0004800651624846, 0.0004778282842385001, 0.0004755931226945001, 
  0.0004733539861641, 0.0004711166065883999, 0.0004688752325515, 
  0.0004666356563027, 0.0004643920655542, 0.0004621503140203, 
  0.0004599045273641, 0.0004576606219629001, 0.0004554126602170001, 
  0.0004531666223937, 0.0004509165063837, 0.0004486683576177001, 
  0.0004464161081803, 0.0004441658699777002, 0.0004419115079618, 
  0.0004396592018610001, 0.000437402748121, 0.0004351483956899, 
  0.0004328898710914001, 0.0004306334939271001, 0.0004283729193416999, 
  0.0004261145390760001, 0.0004238519353829, 0.0004215915736759001, 
  0.0004193269617602001, 0.0004170646403070001, 0.0004147980410586, 
  0.0004125337815841, 0.0004102652158982, 0.0004079990401611, 
  0.0004057285289379001, 0.0004034604587279, 0.000401188022869, 
  0.0003989180800126001, 0.0003966437404206, 0.0003943719467754, 
  0.0003920957243573, 0.0003898221018193999, 0.0003875440174785, 
  0.0003852685879739, 0.0003829886626162, 0.0003807114481106, 
  0.0003784297026369, 0.0003761507251323001, 0.0003738671804427001, 
  0.0003715864619766001, 0.0003693011389648, 0.0003670187016163, 
  0.0003647316211704999, 0.0003624474870555, 0.0003601586700577, 
  0.0003578728613333, 0.0003555823286558, 0.0003532948675187999, 
  0.0003510026400264, 0.0003487135487177, 0.0003464196472613001, 
  0.0003441289480648, 0.0003418333934817, 0.0003395411087277, 
  0.00033724392184, 0.0003349500739032, 0.0003326512755201, 
  0.000330355886822, 0.0003280554977282001, 0.0003257585907437, 
  0.000323456631705, 0.0003211582289579, 0.0003188547207185, 
  0.000316554844788, 0.0003142498080618, 0.0003119484815803, 
  0.0003096419370576999, 0.0003073391827158999, 0.0003050311510519999, 
  0.0003027269916027, 0.0003004174934208001, 0.0002981119516774, 
  0.0002958010075617, 0.0002934941064057, 0.0002911817369009, 
  0.0002888734992822, 0.0002865597248857, 0.000284250173825, 
  0.0002819350149904, 0.0002796241735879, 0.0002773076507076, 
  0.0002749955421445, 0.0002726776755588999, 0.000270364323097, 
  0.0002680451330834, 0.0002657305600788, 0.0002634100668451, 
  0.000261094296748, 0.0002587725204241, 0.0002564555767857, 
  0.000254132537426, 0.0002518144439033, 0.0002494901614722, 
  0.0002471709418377, 0.0002448454362025, 0.0002425251143539, 
  0.0002401984052776, 0.0002378770052387999, 0.0002355491123712, 
  0.0002332266583096, 0.0002308976011775, 0.000228574117411, 
  0.0002262439154014, 0.0002239194264072, 0.0002215880987687, 
  0.0002192626292011, 0.0002169301950071, 0.0002146037697107, 
  0.0002122702478669, 0.0002099428918884, 0.0002076083011067, 
  0.0002052800397128, 0.0002029443984881, 0.0002006152571932, 
  0.0001982785837873, 0.0001959485883656, 0.0001936109007844, 
  0.0001912800772979, 0.0001889413932589, 0.0001866097680894, 
  0.0001842701050044, 0.0001819377048735, 0.0001795970797983, 
  0.0001772639318187, 0.000174922361425, 0.0001725884931272, 
  0.0001702459936632, 0.0001679114330446, 0.0001655680202708, 
  0.0001632327958593, 0.0001608884850054, 0.0001585526259008, 
  0.0001562074315988, 0.0001538709675556, 0.0001515249037551, 
  0.0001491878652581, 0.0001468409451542, 0.000144503363516, 
  0.0001421555994347, 0.0001398175068979, 0.0001374689101839, 
  0.0001351303400526, 0.0001327809209356, 0.0001304419077199, 
  0.0001280916751444, 0.0001257522547483, 0.0001234012161758, 
  0.0001210614261044, 0.0001187095872896, 0.0001163694669044, 
  0.0001140168316035, 0.0001116764224311, 0.0001093229920746, 
  0.0001069823381779, 0.0001046281114428, 0.0001022872598923, 
  0.0000999322322055, 0.0000975912336298, 0.0000952353965047, 
  0.0000928943058247, 0.0000905376461002, 0.0000881965234057, 
  0.0000858390222024, 0.0000834979339194, 0.0000811395653334, 
  0.0000787985857064, 0.0000764393151306, 0.0000740985281616, 
  0.000071738310021, 0.0000693978120762, 0.00006703658682990001, 
  0.00006469649016550001, 0.0000623341801334, 0.00005999461777319999, 
  0.0000576311213915, 0.00005529225401050001, 0.00005292743752610001, 
  0.00005058946349460001, 0.0000482231487494, 0.00004588631915899999, 
  0.0000435182649537, 0.00004118290689050001, 0.00003881277949290001, 
  0.000036479333906, 0.0000341066579851, 0.0000317757441973, 
  0.0000293998163844, 0.0000270723499665, 0.0000246920749223, 
  0.000022369501453, 0.0000199830488135, 0.0000176678639484, 
  0.0000152718484189, 0.000012968954639, 0.000010556051269, 
  0.000008277287861, 0.0000058266822394, 0.0000036140781518, 
  0.000001026720134};


/************************************************************************/
/* returns a pointer to the proper quadrature weights for a given
   bandwidth bw.  Weights array is of size 2*bw. A closed form for
   the weights can be found in the original Driscoll and Healy paper,
   but need to be normalized */

const double *get_weights(int bw)
{

  switch(bw)
    {
    case 4: return w4;
    case 8: return w8;
    case 16: return w16;
    case 32: return w32;
    case 64: return w64;
    case 128: return w128;
    case 256: return w256;
    case 512: return w512;
    case 1024: return w1024;
    default: return 0;
  }
}

