'use strict';

window.addEventListener('DOMContentLoaded', function () {
    function setTheme(mode) {
        if (mode !== "light" && mode !== "dark" && mode !== "auto") {
            console.error(`Got invalid theme mode: ${mode}. Resetting to auto.`);
            mode = "auto";
        }
        document.documentElement.setAttribute("data-bs-theme", mode);
        localStorage.setItem("theme", mode);

        const moonIcon = document.querySelector('#darkModeToggle > i');
        if (moonIcon) {
            if (mode === 'dark') {
                moonIcon.className = 'fas fa-sun';
            } else if (mode === 'light') {
                moonIcon.className = 'fas fa-moon';
            } else {
                moonIcon.className = 'fas fa-circle';
            }
        }
    }

    function cycleTheme() {
        const currentTheme = localStorage.getItem("theme") || "auto";
        const prefersDark = window.matchMedia("(prefers-color-scheme: dark)").matches;

        if (prefersDark) {
            // Auto (dark) -> Light -> Dark
            if (currentTheme === "auto") {
                setTheme("light");
            } else if (currentTheme === "light") {
                setTheme("dark");
            } else {
                setTheme("auto");
            }
        } else {
            // Auto (light) -> Dark -> Light
            if (currentTheme === "auto") {
                setTheme("dark");
            } else if (currentTheme === "dark") {
                setTheme("light");
            } else {
                setTheme("auto");
            }
        }
    }

    function initTheme() {
        // set theme defined in localStorage if there is one, or fallback to auto mode
        const currentTheme = localStorage.getItem("theme") || "auto";
        setTheme(currentTheme); // Set theme immediately on page load
    }

    function setupTheme() {
        const buttons = document.getElementsByName("darkModeToggle");
        Array.from(buttons).forEach((btn) => {
            btn.addEventListener("click", cycleTheme);
        });
        initTheme();
    }

    setupTheme();
});
