import { Construct } from 'constructs';
export interface RedisOptions {
    /**
     * Number of replicas.
     * @default 2
     */
    readonly replicas?: number;
    /**
     * Extra labels to associate with resources.
     * @default - none
     */
    readonly labels?: {
        [name: string]: string;
    };
}
export declare class Redis extends Construct {
    /**
     * The DNS host for the primary service.
     */
    readonly primaryHost: string;
    /**
     * The DNS host for the replica service.
     */
    readonly replicaHost: string;
    constructor(scope: Construct, id: string, options?: RedisOptions);
}
//# sourceMappingURL=redis.d.ts.map