from collections import namedtuple
from pathlib import Path

HERE = Path(__file__).parent

Metadata = namedtuple('Metadata', ['descr', 'ref', 'index', 'source'])

metadata = dict(
    airlines=Metadata(
        descr="Translation between two letter carrier codes and names",
        ref="https://github.com/tidyverse/nycflights13",
        index=False,
        source=HERE / "airlines.csv.gz",
    ),
    airports=Metadata(
        descr="airport names and locations",
        ref="https://github.com/tidyverse/nycflights13",
        index=False,
        source=HERE / "airports.csv.gz",
    ),
    airquality=Metadata(
        descr="Daily air quality measurements in New York, May to September 1973.",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/airquality",
        index=False,
        source=HERE / "airquality.csv.gz",
    ),
    anscombe=Metadata(
        descr="Four x-y datasets which have the same traditional statistical properties",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/anscombe",
        index=False,
        source=HERE / "anscombe.csv.gz",
    ),
    band_instruments=Metadata(
        descr="Band members of the Beatles and Rolling Stones",
        ref="https://dplyr.tidyverse.org/reference/band_members.html",
        index=False,
        source=HERE / "band_instruments.csv.gz",
    ),
    band_instruments2=Metadata(
        descr="Band members of the Beatles and Rolling Stones",
        ref="https://dplyr.tidyverse.org/reference/band_members.html",
        index=False,
        source=HERE / "band_instruments2.csv.gz",
    ),
    band_members=Metadata(
        descr="Band members of the Beatles and Rolling Stones",
        ref="https://dplyr.tidyverse.org/reference/band_members.html",
        index=False,
        source=HERE / "band_members.csv.gz",
    ),
    billboard=Metadata(
        descr="Song rankings for Billboard top 100 in the year 2000",
        ref="https://tidyr.tidyverse.org/reference/billboard.html",
        index=False,
        source=HERE / "billboard.csv.gz",
    ),
    chickweight=Metadata(
        descr="Weight versus age of chicks on different diets",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/ChickWeight",
        index=False,
        source=HERE / "chickweight.csv.gz",
    ),
    construction=Metadata(
        descr="Completed construction in the US in 2018",
        ref="https://tidyr.tidyverse.org/reference/construction.html",
        index=False,
        source=HERE / "construction.csv.gz",
    ),
    diamonds=Metadata(
        descr="A dataset containing the prices and other attributes of almost 54,000 diamonds",
        ref="https://ggplot2.tidyverse.org/reference/diamonds.html",
        index=False,
        source=HERE / "diamonds.csv.gz",
    ),
    economics=Metadata(
        descr="US economic time series",
        ref="https://ggplot2.tidyverse.org/reference/economics.html",
        index=False,
        source=HERE / "economics.csv.gz",
    ),
    economics_long=Metadata(
        descr="US economic time series",
        ref="https://ggplot2.tidyverse.org/reference/economics.html",
        index=False,
        source=HERE / "economics_long.csv.gz",
    ),
    faithful=Metadata(
        descr="Waiting time between eruptions and the duration of the eruption for the Old Faithful geyser in Yellowstone National Park, Wyoming, USA",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/faithful",
        index=False,
        source=HERE / "faithful.csv.gz",
    ),
    faithfuld=Metadata(
        descr="2d density estimate of Old Faithful data",
        ref="https://ggplot2.tidyverse.org/reference/faithfuld.html",
        index=False,
        source=HERE / "faithfuld.csv.gz",
    ),
    fish_encounters=Metadata(
        descr="Information about fish swimming down a river",
        ref="https://tidyr.tidyverse.org/reference/fish_encounters.html",
        index=False,
        source=HERE / "fish_encounters.csv.gz",
    ),
    flights=Metadata(
        descr="all flights that departed from NYC in 2013",
        ref="https://github.com/tidyverse/nycflights13",
        index=False,
        source=HERE / "flights.csv.gz",
    ),
    gss_cat=Metadata(
        descr="A sample of categorical variables from the General Social survey",
        ref="https://forcats.tidyverse.org/reference/gss_cat.html",
        index=False,
        source=HERE / "gss_cat.csv.gz",
    ),
    iris=Metadata(
        descr="Edgar Anderson's Iris Data",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/iris",
        index=False,
        source=HERE / "iris.csv.gz",
    ),
    luv_colours=Metadata(
        descr="colors() in Luv space",
        ref="https://ggplot2.tidyverse.org/reference/luv_colours.html",
        index=False,
        source=HERE / "luv_colours.csv.gz",
    ),
    midwest=Metadata(
        descr="Midwest demographics",
        ref="https://ggplot2.tidyverse.org/reference/midwest.html",
        index=False,
        source=HERE / "midwest.csv.gz",
    ),
    mpg=Metadata(
        descr="Fuel economy data from 1999 to 2008 for 38 popular models of cars",
        ref="https://ggplot2.tidyverse.org/reference/mpg.html",
        index=False,
        source=HERE / "mpg.csv.gz",
    ),
    msleep=Metadata(
        descr="An updated and expanded version of the mammals sleep dataset",
        ref="https://ggplot2.tidyverse.org/reference/msleep.html",
        index=False,
        source=HERE / "msleep.csv.gz",
    ),
    mtcars=Metadata(
        descr="Motor Trend Car Road Tests",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/mtcars",
        index=True,
        source=HERE / "mtcars.csv.gz",
    ),
    planes=Metadata(
        descr="construction information about each plane",
        ref="https://github.com/tidyverse/nycflights13",
        index=False,
        source=HERE / "planes.csv.gz",
    ),
    population=Metadata(
        descr="A subset of data from the World Health Organization Global Tuberculosis Report, and accompanying global populations.",
        ref="https://tidyr.tidyverse.org/reference/who.html",
        index=False,
        source=HERE / "population.csv.gz",
    ),
    presidential=Metadata(
        descr="Terms of 11 presidents from Eisenhower to Obama",
        ref="https://ggplot2.tidyverse.org/reference/presidential.html",
        index=False,
        source=HERE / "presidential.csv.gz",
    ),
    relig_income=Metadata(
        descr="Pew religion and income survey",
        ref="https://tidyr.tidyverse.org/reference/relig_income.html",
        index=False,
        source=HERE / "relig_income.csv.gz",
    ),
    seals=Metadata(
        descr="Vector field of seal movements",
        ref="https://ggplot2.tidyverse.org/reference/seals.html",
        index=False,
        source=HERE / "seals.csv.gz",
    ),
    smith=Metadata(
        descr="A small demo dataset describing John and Mary Smith.",
        ref="https://tidyr.tidyverse.org/reference/smiths.html",
        index=False,
        source=HERE / "smith.csv.gz",
    ),
    starwars=Metadata(
        descr="tarwars characters (columns films, vehicles and starships are not included)",
        ref="https://dplyr.tidyverse.org/reference/starwars.html",
        index=False,
        source=HERE / "starwars.csv.gz",
    ),
    state_abb=Metadata(
        descr="character vector of 2-letter abbreviations for the state names.",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/state",
        index=False,
        source=HERE / "state_abb.csv.gz",
    ),
    state_division=Metadata(
        descr="factor giving state divisions (New England, Middle Atlantic, South Atlantic, East South Central, West South Central, East North Central, West North Central, Mountain, and Pacific).",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/state",
        index=False,
        source=HERE / "state_division.csv.gz",
    ),
    state_region=Metadata(
        descr="factor giving the region (Northeast, South, North Central, West) that each state belongs to.",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/state",
        index=False,
        source=HERE / "state_region.csv.gz",
    ),
    storms=Metadata(
        descr="This data is a subset of the NOAA Atlantic hurricane database best track data",
        ref="https://dplyr.tidyverse.org/reference/storms.html",
        index=False,
        source=HERE / "storms.csv.gz",
    ),
    table1=Metadata(
        descr="Example tabular representations",
        ref="https://tidyr.tidyverse.org/reference/table1.html",
        index=False,
        source=HERE / "table1.csv.gz",
    ),
    table2=Metadata(
        descr="Example tabular representations",
        ref="https://tidyr.tidyverse.org/reference/table1.html",
        index=False,
        source=HERE / "table2.csv.gz",
    ),
    table3=Metadata(
        descr="Example tabular representations",
        ref="https://tidyr.tidyverse.org/reference/table1.html",
        index=False,
        source=HERE / "table3.csv.gz",
    ),
    table4a=Metadata(
        descr="Example tabular representations",
        ref="https://tidyr.tidyverse.org/reference/table1.html",
        index=False,
        source=HERE / "table4a.csv.gz",
    ),
    table4b=Metadata(
        descr="Example tabular representations",
        ref="https://tidyr.tidyverse.org/reference/table1.html",
        index=False,
        source=HERE / "table4b.csv.gz",
    ),
    table5=Metadata(
        descr="Example tabular representations",
        ref="https://tidyr.tidyverse.org/reference/table1.html",
        index=False,
        source=HERE / "table5.csv.gz",
    ),
    toothgrowth=Metadata(
        descr="The Effect of Vitamin C on Tooth Growth in Guinea Pigs",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/ToothGrowth",
        index=False,
        source=HERE / "toothgrowth.csv.gz",
    ),
    txhousing=Metadata(
        descr="Housing sales in TX",
        ref="https://ggplot2.tidyverse.org/reference/txhousing.html",
        index=False,
        source=HERE / "txhousing.csv.gz",
    ),
    us_rent_income=Metadata(
        descr="US rent and income data",
        ref="https://tidyr.tidyverse.org/reference/us_rent_income.html",
        index=False,
        source=HERE / "us_rent_income.csv.gz",
    ),
    warpbreaks=Metadata(
        descr="The Number of Breaks in Yarn during Weaving",
        ref="https://www.rdocumentation.org/packages/datasets/versions/3.6.2/topics/warpbreaks",
        index=False,
        source=HERE / "warpbreaks.csv.gz",
    ),
    weather=Metadata(
        descr="hourly meterological data for each airport",
        ref="https://github.com/tidyverse/nycflights13",
        index=False,
        source=HERE / "weather.csv.gz",
    ),
    who=Metadata(
        descr="A subset of data from the World Health Organization Global Tuberculosis Report, and accompanying global populations.",
        ref="https://tidyr.tidyverse.org/reference/who.html",
        index=False,
        source=HERE / "who.csv.gz",
    ),
    world_bank_pop=Metadata(
        descr="Population data from the world bank",
        ref="https://tidyr.tidyverse.org/reference/world_bank_pop.html",
        index=False,
        source=HERE / "world_bank_pop.csv.gz",
    ),
)
