# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ideaseed']

package_data = \
{'': ['*']}

install_requires = \
['PyGithub>=1.54.1,<2.0.0',
 'PyYAML>=5.4.1,<6.0.0',
 'docopt>=0.6.2,<0.7.0',
 'gkeepapi>=0.11.16,<0.12.0',
 'inquirer>=2.7.0,<3.0.0',
 'recordclass>=0.14.3,<0.15.0',
 'rich>=10.1.0,<11.0.0',
 'semantic-version>=2.8.5,<3.0.0',
 'unicode-slugify>=0.1.3,<0.2.0',
 'urllib3>=1.26.4,<2.0.0']

entry_points = \
{'console_scripts': ['ideaseed = ideaseed.cli:run']}

setup_kwargs = {
    'name': 'ideaseed',
    'version': '1.2.0',
    'description': 'Note down your ideas and get them to the right place, without switching away from your terminal',
    'long_description': '<center><p align="center">\n<img alt="ideaseed" src="https://raw.githubusercontent.com/ewen-lbh/ideaseed/master/visual-identity/ideaseed-logomark-color-transparent.svg" width="550px">\n  <br>\n<a href="https://pypi.org/project/ideased"><img alt="PyPI Latest version" src="https://img.shields.io/pypi/v/ideaseed"/></a>\n<a href="https://pepy.tech/project/ideaseed"><img alt="Downloads count" src="https://pepy.tech/badge/ideaseed"/></a>\n</p></center>\n\nDo you have ideas suddenly and just wished you could catch them as fast as possible, as to not loose them, without having to interrupt what you were doing?\n\nAs I guy with a lot of more or less stupid ideas, I use Google Keep as a centralized place to put all of my thoughts that I deem worthy of consideration.\n\nI recently started to use GitHub Projects for _coding_ project ideas as a [single project called "incubator" on my GitHub profile directly](https://github.com/ewen-lbh?tab=projects), and as issues or notes when the idea is related to an already-existing project and repo.\n\nBut when I don\'t get to decide _when_ this idea comes, and I often need to interrupt what am I doing to open github, get to the right page, input my idea and get back. And I find it frustrating.\n\nEnough rambling. Here\'s what you came for.\n\nNote down your ideas and get them to the right place, without switching away from your terminal\n\n<details>\n<summary>Table of contents</summary>\n<ul>\n<li><a href="#installation">Installation</a></li>\n<li><a href="#authentication">Authentication</a></li>\n<li><a href="#usage">Usage</a>\n<ul>\n<li><a href="#create-a-google-keep-card">Create a Google Keep card</a></li>\n<li><a href="#create-an-issue-andor-a-projects-card-on-a-repository">Create an issue and/or a Projects card on a repository</a></li>\n<li><a href="#create-a-card-on-a-project-tied-to-your-user-profile">Create a card on a project tied to your user profile</a></li>\n<li><a href="#providing-other-information">Providing other information</a>\n<ul>\n<li><a href="#labels">Labels</a></li>\n<li><a href="#assigneescollaborators">Assignees/Collaborators</a></li>\n<li><a href="#milestones">Milestones</a></li>\n<li><a href="#pin-status">Pin status</a></li>\n<li><a href="#colors">Colors</a></li>\n</ul></li>\n<li><a href="#other-features">Other features</a>\n<ul>\n<li><a href="#--open"><code>--open</code></a></li>\n<li><a href="#--dry-run"><code>--dry-run</code></a></li>\n<li><a href="#local-copy">Local copy</a></li>\n</ul></li>\n</ul></li>\n<li><a href="#configuration">Configuration</a>\n<ul>\n<li><a href="#defaults">Defaults</a></li>\n<li><a href="#miscelleanous-options">Miscelleanous options</a>\n<ul>\n<li><a href="#--self-assign-auto-assigning-yourself"><code>--self-assign</code> Auto-assigning yourself</a></li>\n<li><a href="#--create-missing-prompt-for-creation-of-missing-stuff"><code>--create-missing</code>: Prompt for creation of missing stuff</a></li>\n<li><a href="#--check-for-updates-get-notified-when-a-new-version-of-ideaseed-is-released"><code>--check-for-updates</code>: Get notified when a new version of ideaseed is released.</a></li>\n<li><a href="#--auth-cachefilepath-change-the-auth-cache-location"><code>--auth-cache=FILEPATH</code>: Change the auth cache location</a></li>\n</ul></li>\n</ul></li>\n<li><a href="#updating">Updating</a></li>\n<li><a href="#complete-usage-from---help">Complete usage from <code>--help</code></a></li>\n</ul>\n</details>\n\n## Installation\n\nIdeaseed is available [on PyPI.org](https://pypi.org/project/ideaseed):\n\n```sh\npip install ideaseed # latest version\npip install git+https://github.com/ewen-lbh/ideaseed # latest commit\n```\n\n<!-- ### Arch Linux\n\nArch users can also get _ideaseed_ from the AUR:\n\n- latest stable: [`ideaseed`](https://aur.archlinux.org/packages/ideaseed)\n- bleeding edge (latest commit): [`ideaseed-git`](https://aur.archlinux.org/packages/ideaseed-git)\n\n-->\n\n## Authentication\n\nAuthentication credentials are asked for when necessary, and are cached in a JSON file referred to as the \'auth cache\'.\nThe location of that auth cache is configurable through the `--auth-cache` flag.\n\nYou can manually login to both Google Keep and GitHub with `ideaseed login`, and clear the cache with `ideaseed logout`.\n\nA support for keyrings as an alternative authentication method [is planned](https://github.com/ewen-lbh/ideaseed/issues/153)\n\n## Usage\n\nIdeas are made up of different pieces of data, of which only the _body_ is necessary.\n\n- body: the body of your idea, the main content\n- title\n- project: the GitHub project to put the card in\n- column: the project\'s column to put the card in\n- repo: the repository to create the card (and issue) in (only relevant when adding to a repository)\n\nThus, ideaseed\'s usage patterns are varied:\n\n### Create a Google Keep card\n\nProvide only the body, a Google Keep card will be created, with no title:\n```\nideaseed [options] BODY\n```\nSame as above, but provide a title:\n```\nideaseed [options] TITLE BODY\n```\n\n### Create an issue and/or a Projects card on a repository\n\nAlso provide a repository name (and owner if it isn\'t you):\n```\nideaseed [options] REPO TITLE BODY\n```\nIf you have set defaults for the project and column names, they will get used.\nOtherwise, no Github Projects card will be created. \n\nFinally, providing the column and/or the project:\n```\nideaseed [options] REPO COLUMN TITLE BODY\nideaseed [options] REPO PROJECT COLUMN TITLE BODY\n```\n\nNote that you are not forced to use those combinations, as these arguments also exist in `--flag` forms: `-C/--column` for `COLUMN`, etc.\n\nYou can use `-I/--no-issue` to only create a Project card.\n\n### Create a card on a project tied to your user profile\n\nIf you want to create a github card on a project that\'s tied to your user profile instead of to a repository, put `user` in front, and drop `REPO`:\n\n```\nideaseed [options] user BODY\nideaseed [options] user TITLE BODY\nideaseed [options] user PROJECT TITLE BODY\nideaseed [options] user PROJECT COLUMN TITLE BODY\n```\n\n### Providing other information\n\n#### Labels\n\nAdd labels by using `-#/--label` one or more times.\nThis works on Google Keep or when creating issues. \n\n#### Assignees/Collaborators\n\nAdd assignees (github issues) or collaborators (Google Keep) by using `-@/--assign` one or more times.\nUse usernames for github issues and emails for Google Keep cards.\n\n\n#### Milestones\n\nAssign an issue to a milestone by specifying its name with `-M/--milestone`.\n\n#### Pin status\n\nPin your Google Keep card with `--pin`.\nSupport for github issues [is planned](https://github.com/ewen-lbh/issues/155)\n\n#### Colors\n\nGive your Google Keep card a color with `--color NAME`. `NAME` can be:\n\n- blue\n- brown\n- darkblue (or indigo)\n- gray (or grey)\n- green\n- orange\n- pink\n- purple (or magenta)\n- red\n- teal (or cyan)\n- white\n- yellow\n\n### Other features\n\n#### `--open`\n\nOpen the created issue/card in your favorite browser (uses [`webbrowser.open`](https://docs.python.org/3/library/webbrowser.html#webbrowser.open))\n\n#### `--dry-run`\n\nDo a \'test run\'. Does not create issues and cards. Note that missing resources tthat were created with `--create-missing` still do get created.\n\nThe following will appear to let you know that you are dry-running:\n\n> You are in **dry-run mode**.\n>\n> Issues and cards will not be created.\n>\n> Creation of objects from --create-missing will still occur\n>\n> _(e.g. missing labels will be created if you answer \'yes\')_\n\n#### Local copy\n\nSave copies of your ideas locally, somewhere safe on your disk.\n\nIf you use `--local-copy=DIR`, copies of all created ideas will get saved as files inside of `DIR`.\n\nIf `USER/REPO` or `REPO` is used, the file will be written into `DIR/[USER/]REPO` instead.\nIf the ‘user’ command is used, the file will be written into `DIR/PROJECT` instead.\n\nThe file\'s name will be a [slugified](https://en.wikipedia.org/wiki/Clean_URL#Slug)<sup>1</sup> version of either the title or, if not set, the body\'s first line.\n\nThe file is a markdown with a YAML header that holds metadata such as labels and assigned people.\n\nValues that count as false (empty strings, empty lists, empty objects, the False boolean and 0) will not be included in the header.\n\nThe following information is written to the header:\n\nYAML key  | Description             | Related to flag\n----------|-------------------------|------------------\nassignees | People assigned         |  `-@` / `--assign`\ncolor     | The card\'s color        |  `--color`\ncolumn    | The project\'s column    |  `-C` / `--column`\nlabels    | Included labels         |  `-#` / `--label`\nmilestone | Assigned milestone      |  `-M` / `--milestone`\npinned    | The card\'s pinned state |  `--pin`\nproject   | The github project      |  `-P` / `--project`\nurl       | A link to the idea      |  \n\nThe values correspond to what was actually used to publish the idea, so defaults get applied,\nand things created with `--create-missing` also appear here.\n\nIf \'url\' is not in the header, then either the idea failed to get uploaded to the service (github, google keep), or `--dry-run` was used.\n\n---\n\n<sup>1</sup> As defined by [unicode-slugify](https://pypi.org/project/unicode-slugify)\'s `slugify` function\n\n## Configuration\n\nConfiguration is done through aliasing ideaseed and adding flags to the alias.\nThis configuration can be done interactively with `ideaseed config`.\n\nIt will ask you some questions to configure your alias, then append the alias to your current shell\'s rc file (supported shells are fish, bash, zsh, csh, ksh and tcsh. Feel free to add more shells through PRs or issues!)\n\n### Defaults\n\nYou can specify default values for `COLUMN` and `PROJECT`. You can use {placeholders} in these default values to make them dynamic. The format is the same as python\'s [`str.format`](https://pyformat.info/), so you can also do things like trimming!\n\n| Flag | Sets default value for | Available placeholders |\n|------|------------------------|------------------------|\n| `--default-project` | `PROJECT` | {repository}, {username}, {owner} |\n| `--default-column` | `COLUMN` | {project}, {repository}, {username}, {owner} |\n| `--default-user-project` | `PROJECT` when using `user` | none\n| `--default-user-column` | `COLUMN` when using `user` | {project} \n\nNote: if a `--default-user-*` is not set, it will fall back to the corresponding `--default-*`.\nThese are essentially overrides for the `user` command, since you might want different defaults with that one.\n\n### Miscelleanous options\n\n#### `--self-assign` Auto-assigning yourself\n\nWith this flag, if `-@/--assign` is not used, you are assigned to the created issue automatically. Does not assign yourself as a collaborator in Google Keep.\n\n#### `--create-missing`: Prompt for creation of missing stuff\n\nIf a label, milestone, project or column does not exist but is used, you will be asked whether or not you want to create that missing resource. \n\nIf you say no, the command will be cancelled and nothing will happen. \n\nIf you say yes, the missing object will get created (you might enter additional informtion such as a column\'s description) and the issue and/or card will also get created.\n\n#### `--check-for-updates`: Get notified when a new version of ideaseed is released.\n\nWith this flag, if you run ideaseed and that it detects that a newer version is available, a notification will appear.\n\nYou can then [update ideaseed](#Updating).\n\n#### `--auth-cache=FILEPATH`: Change the auth cache location\n\nIf you want to change where ideaseed caches your authentication credentials, use this flag.\n\n## Updating\n\nYou can update ideaseed with the `update` command (or directly from your package manager).\n\n## Complete usage from `--help`\n\n```\nNote down your ideas and get them to the right place, without switching away from your terminal\nUsage:\n    ideaseed [options] config\n    ideaseed [options] logout\n    ideaseed [options] login\n    ideaseed [options] about | --about\n    ideaseed [options] version | --version\n    ideaseed [options] help | --help\n    ideaseed [options] update\n    ideaseed [options] [-# LABEL...] [-@ USER...] user BODY\n    ideaseed [options] [-# LABEL...] [-@ USER...] user TITLE BODY\n    ideaseed [options] [-# LABEL...] [-@ USER...] user PROJECT TITLE BODY\n    ideaseed [options] [-# LABEL...] [-@ USER...] user PROJECT COLUMN TITLE BODY\n    ideaseed [options] [-# LABEL...] [-@ USER...] BODY\n    ideaseed [options] [-# LABEL...] [-@ USER...] TITLE BODY\n    ideaseed [options] [-# LABEL...] [-@ USER...] REPO TITLE BODY\n    ideaseed [options] [-# LABEL...] [-@ USER...] REPO COLUMN TITLE BODY\n    ideaseed [options] [-# LABEL...] [-@ USER...] REPO PROJECT COLUMN TITLE BODY\n\n\nCommands:\n    user                    Creates cards in your user\'s project. \n                            (see https://github.com/users/YOURUSERNAME/projects)\n                            Flags --no-issue and --repo has no effects.\n                            Flag --default-column still applies.\n                            REPO is _not_ set to \'user\'.\n    config                  Configures an alias with Configuration flags through a series of questions.\n    log(in/out)             Fills/Clears the auth cache (see --auth-cache).\n    about                   Show information about ideaseed.\n    version                 Outputs the version number\n    update                  Check for updates. If any is available, shows the changelog. \n                            You can then decide to install the new version.\n\n\nArguments:\n    BODY      Sets the note\'s body. Required.\n    TITLE     Sets the title.\n    REPO      The repository to put the issue/card into. Uses the format [USER/]REPO. \n              If USER/ is omitted, the currently-logged-in user\'s username is assumed.\n              Omitting this argument entirely has the effect of creating a Google Keep card instead.\n              When used without PROJECT, the card is added to the Default Project (see --default-project)\n              If the Default Project is \'<None>\', it creates an issue without a project card.\n    PROJECT   Specify which GitHub project to add the card to.\n              When used without COLUMN, the card is added to the Default Column (see --default-column)\n              Can use Placeholders\n    COLUMN    Specify which column to use.\n              Can use Placeholders.\n\n\nOptions:\n    -I --no-issue           Only creates a project card, no issue is created.\n                            Has no effect when used without a REPO\n    -T --title=TITLE        Specifies TITLE\n    -R --repo=REPO          Specifies REPOSITORY\n    -P --project=PROJECT    Specifies PROJECT\n    -C --column=COLUMN      Specifies COLUMN\n    -# --label=LABEL...     Add labels\n                            Can be specified multiple times.\n                            Cannot be used in the \'user\' command.\n                            Cannot be used with --no-issue\n    -o --open               Open the created card (or issue) in your $BROWSER.\n       --dry-run            Tell what will happen but does not do it. Still logs you in.\n                            Beware, objects created with --create-missing will\n                            still be created.\n    -m --create-missing     Creates missing objects (projects, columns, and labels/labels)\n    -@ --assign=USER...     Assign USER to the created issue. \n                            Can be specified multiple times.\n                            Cannot be used in the \'user\' command.\n                            Cannot be used with --no-issue\n       --debug              Shows extra information. Used for debugging purposes.\n\n    REPO only: \n       --self-assign        Assign the created issue to yourself. \n                            Has no effect when --assign is used.\n    -M --milestone=NAME     Adds the issue to the milestone NAME.\n\n    Google Keep only:\n       --pin                Pins the card. \n       --color=COLOR        Sets the card\'s color. [default: white]\n                            Available values: blue, brown, darkblue (or indigo), \n                            gray (or grey), green, orange, pink, purple (or magenta), \n                            red, teal (or cyan), white, yellow. \n\n\nConfiguration:\n   --default-column=COLUMN          Specifies the Default Column. \n                                    Used when PROJECT is set but not COLUMN\n                                    Can use Placeholders.\n   --default-project=PROJECT        Specifies the Default Project. \n                                    Used when REPO is set but not PROJECT\n                                    Can use Placeholders.\n                                    If not set, or set to \'<None>\',\n                                    using REPO without PROJECT creates an issue\n                                    without its project card.\n   --default-user-project=PROJECT   Specifies an override to Default Project,\n                                    that will only be used when the ‘user’ command is used\n                                    Can use Placeholders.\n                                    When not set, --default-project is used.\n   --default-user-column=COLUMN     Same as --default-user-project, but for the Default Column.                                   \n   --auth-cache=FILEPATH            Set the filepath for the auth. cache [default: /home/ewen/cache/ideaseed/auth.json]\n                                    If set to \'<None>\', disables caching of credentials.\n                                    Has no effect when used with --keyring.\n   --check-for-updates              Check for new versions and show a notification if a new one is found.\n   --local-copy=DIR                 Directory to save a copy of ideas to.\n                                    If not set, or set to \'<None>\',\n                                    ideas will not get saved locally.\n                                    DIR must exist beforehand. ~ and ~user constructs get expanded.\n                                    See Local Copy for more information.\n\n\nPlaceholders:\n    {repository}      Replaced with the repository\'s name\n                      Not available to --default-user-* flags\n    {owner}           Replaced with the repository\'s owner\n                      Not available to --default-user-* flags\n    {username}        Replaced with the currently-logged-in GitHub user\'s username\n    {project}         Replaced with the project the card will be added to.\n                      Not available to --default-project, --default-user-project or PROJECT.\n\nLocal Copy:\n    If you use --local-copy=DIR, copies of all created ideas will get saved as files inside of DIR.\n    If USER/REPO or REPO is used, the file will be written into DIR/[USER/]REPO instead.\n    If the ‘user’ command is used, the file will be written into DIR/PROJECT instead.\n\n    The file\'s name will be a slugified (meaning lowercased, with spaces replaced by dashes, mostly)\n    version of either the title or, if not set, the body\'s first line.\n\n    The file is a markdown with a YAML header that holds metadata such as labels and assigned people.\n    Values that count as false (empty strings, empty lists, empty objects, the False boolean and 0)\n    will not be included in the header.\n    The following information is written to the header:\n\n    assignees:      People assigned           (related to -@ / --assign)\n    color:          The card\'s color          (related to --color)\n    column:         The project\'s column      (related to -C / --column)\n    labels:         Included labels           (related to -# / --label)\n    milestone:      Assigned milestone        (related to -M / --milestone)\n    pinned:         The card\'s pinned state   (related to --pin)\n    project:        The github project        (related to -P / --project)\n    url:            A link to the idea        \n\n    The values correspond to what was actually used to publish the idea, so defaults get applied,\n    and things created with --create-missing also appear here.\n\n    If \'url\' is not in the header, than either the idea failed to get uploaded to the service (github, google keep)\n    Or that --dry-run was used.\n```\n\n[v1.0.0]: https://github.com/ewen-lbh/ideaseed/milestone/2\n[v0.4.0]: https://github.com/ewen-lbh/ideaseed/tree/master/CHANGELOG.md#040---2020-06-18\n[v0.9.0]: https://github.com/ewen-lbh/ideaseed/blob/master/CHANGELOG.md#090---2020-06-22\n\n* * *\n\n<center><p align="center">\n  <img src="https://raw.githubusercontent.com/ewen-lbh/ideaseed/master/visual-identity/ideaseed-logo-black-transparent.png" width="40px">\n  <br>\n  ideaseed by <a href="https://ewen.works">Ewen Le Bihan</a>\n</p></center>\n',
    'author': 'Ewen Le Bihan',
    'author_email': 'ewen.lebihan7@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ewen-lbh/ideaseed',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
