"""initial

Revision ID: d3da9ab956d7
Revises: 
Create Date: 2025-03-21 19:41:38.523130

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'd3da9ab956d7'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('textbooks',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('guid', sa.Uuid(), nullable=False),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('prompt', sa.String(), nullable=False),
    sa.Column('authors', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_textbooks'))
    )
    op.create_table('activities',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('guid', sa.Uuid(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('description', sa.String(), nullable=False),
    sa.Column('prompt', sa.String(), nullable=False),
    sa.Column('textbook_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['textbook_id'], ['textbooks.id'], name=op.f('fk_activities_textbook_id_textbooks')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_activities'))
    )
    op.create_table('modules',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('guid', sa.Uuid(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('outcomes', sa.String(), nullable=False),
    sa.Column('summary', sa.String(), nullable=False),
    sa.Column('textbook_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['textbook_id'], ['textbooks.id'], name=op.f('fk_modules_textbook_id_textbooks')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_modules'))
    )
    op.create_table('module_activity',
    sa.Column('module_id', sa.Integer(), nullable=False),
    sa.Column('activity_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['activity_id'], ['activities.id'], name=op.f('fk_module_activity_activity_id_activities')),
    sa.ForeignKeyConstraint(['module_id'], ['modules.id'], name=op.f('fk_module_activity_module_id_modules')),
    sa.PrimaryKeyConstraint('module_id', 'activity_id', name=op.f('pk_module_activity'))
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('module_activity')
    op.drop_table('modules')
    op.drop_table('activities')
    op.drop_table('textbooks')
    # ### end Alembic commands ###
