"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaStoreContainer = void 0;
const cdk = require("@aws-cdk/core");
const mediastore = require("@aws-cdk/aws-mediastore");
const mediastore_defaults_1 = require("./mediastore-defaults");
const utils_1 = require("./utils");
function MediaStoreContainer(scope, mediaStoreContainerProps) {
    const defaultprops = mediastore_defaults_1.MediaStoreContainerProps();
    let mediaStoreProps;
    if (mediaStoreContainerProps) {
        mediaStoreProps = utils_1.overrideProps(defaultprops, mediaStoreContainerProps);
    }
    else {
        mediaStoreProps = defaultprops;
    }
    // Create the MediaStore Container
    const mediaStoreContainer = new mediastore.CfnContainer(scope, 'MediaStoreContainer', mediaStoreProps);
    // Add deletion policy to retain because it will fail to delete if the container is not empty.
    mediaStoreContainer.cfnOptions.deletionPolicy = cdk.CfnDeletionPolicy.RETAIN;
    return mediaStoreContainer;
}
exports.MediaStoreContainer = MediaStoreContainer;
//# sourceMappingURL=data:application/json;base64,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