"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCfnDomainProps = void 0;
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
function DefaultCfnDomainProps(domainName, cognitoKibanaConfigureRole, options) {
    const roleARNs = [];
    roleARNs.push(new iam.ArnPrincipal(options.cognitoAuthorizedRoleARN));
    if (options.serviceRoleARN) {
        roleARNs.push(new iam.ArnPrincipal(options.serviceRoleARN));
    }
    return {
        domainName,
        elasticsearchVersion: '6.3',
        encryptionAtRestOptions: {
            enabled: true
        },
        nodeToNodeEncryptionOptions: {
            enabled: true
        },
        elasticsearchClusterConfig: {
            dedicatedMasterEnabled: true,
            dedicatedMasterCount: 3,
            instanceCount: 3,
            zoneAwarenessEnabled: true,
            zoneAwarenessConfig: {
                availabilityZoneCount: 3
            }
        },
        snapshotOptions: {
            automatedSnapshotStartHour: 1
        },
        ebsOptions: {
            ebsEnabled: true,
            volumeSize: 10
        },
        cognitoOptions: {
            enabled: true,
            identityPoolId: options.identitypool.ref,
            userPoolId: options.userpool.userPoolId,
            roleArn: cognitoKibanaConfigureRole.roleArn
        },
        accessPolicies: new iam.PolicyDocument({
            statements: [
                new iam.PolicyStatement({
                    principals: roleARNs,
                    actions: [
                        'es:ESHttp*'
                    ],
                    resources: [
                        `arn:aws:es:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:domain/${domainName}/*`
                    ]
                })
            ]
        })
    };
}
exports.DefaultCfnDomainProps = DefaultCfnDomainProps;
//# sourceMappingURL=data:application/json;base64,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