/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cognito from '@aws-cdk/aws-cognito';
import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
export interface CognitoOptions {
    readonly identitypool: cognito.CfnIdentityPool;
    readonly userpool: cognito.UserPool;
    readonly userpoolclient: cognito.UserPoolClient;
}
export declare function buildUserPool(scope: cdk.Construct, userPoolProps?: cognito.UserPoolProps): cognito.UserPool;
export declare function buildUserPoolClient(scope: cdk.Construct, userPool: cognito.UserPool, cognitoUserPoolClientProps?: cognito.UserPoolClientProps): cognito.UserPoolClient;
export declare function buildIdentityPool(scope: cdk.Construct, userpool: cognito.UserPool, userpoolclient: cognito.UserPoolClient, identityPoolProps?: cognito.CfnIdentityPoolProps): cognito.CfnIdentityPool;
export declare function setupCognitoForElasticSearch(scope: cdk.Construct, domainName: string, options: CognitoOptions): iam.Role;
