# Barcode Generation & Recognition via Python

Aspose.BarCode for Python via Java is a robust and reliable barcode generation and recognition component, written in Python and Java. It allows developers to quickly and easily add barcode creation and scanning functionality to their Python applications.

## General Barcode Features

- Supports most established barcode standards and barcode specifications.
- Ability to read & export barcodes in multiple image formats including BMP, GIF, JPEG & PNG.  
- Provides full control over barcode images including background color, bar color, image quality, rotation angle, x-dimension, resolution and more.  
- Complete control over barcode captions including caption font, back color, fore color, alignment, and location.
- Support for checksum.
- Support for X-dimension & Y-dimension for 2D BarCodes.
- Support for Wide to Narrow Ratio for supported symbologies.
- Support for DataMatrix barcode with X12, EDIFACT & Base 256 encoding. 

## Barcode Recognition Features

- Can read most common 1D, 2D barcodes anywhere at any angle from an image.
- Specify an area in the image to scan the barcode 
- Get region information for the barcodes recognized in the image

## Barcode Imaging Features

- Manipulate the barcode's image borders, border color, style, margins, width, etc.
- Rotate barcode images to any degree.
- Set anti-aliasing for barcode images.
- Manage barcode image margins.
- Customize image resolution.
- Set size in inches or millimeters.
- Auto size barcode images.

## Barcode Symbologies

**Numeric Only:** EAN13, EAN8, UPCA, UPCE, ISBN, ISMN, ISSN, Interleaved2of5, Standard2of5, MSI, Code11, Codabar, Postnet, Planet, EAN14(SCC14), SSCC18, ITF14, IATA 2 of 5, DatabarOmniDirectional, DatabarStackedOmniDirectional, DatabarExpandedStacked, DatabarStacked, DatabarLimited, DatabarTruncated\
**Alpha-Numeric:** GS1Code128, Code128, Code39 Extended, Code39 Standard, Code93 Extended, Code93 Standard, Australia Post, Italian Post 25, Matrix 2 of 5, DatabarExpanded, PatchCode\
**2D Symbologies:** PDF417, DataMatrix, Aztec, QR, MicroQR, GS1DataMatrix, Code16K, CompactPDF417, Swiss QR (QR Bill)

## Read Barcodes From

**Images:** JPEG, TIFF, PNG, BMP

## Save Barcode Labels As

**Images:** JPEG, TIFF, PNG, BMP

[Product](https://products.aspose.com/barcode/python-java) | [Documentation](https://docs.aspose.com/barcode/pythonjava/) | [Blog](https://blog.aspose.com/category/barcode/) | [API Reference](https://apireference.aspose.com/barcode/java) | [Free Support](https://forum.aspose.com/c/barcode) | [Temporary License](https://purchase.aspose.com/temporary-license)
