/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.generation;

import com.aspose.barcode.generation.Code128Emulation;
import com.aspose.barcode.generation.Pdf417CompactionMode;
import com.aspose.barcode.generation.Pdf417ErrorLevel;
import com.aspose.barcode.generation.Pdf417MacroTerminator;
import com.aspose.barcode.generation.aq;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import java.nio.charset.Charset;
import java.util.Date;

public class MwPdf417Parameters
extends MwJavaWrapper<aq> {
    public MwPdf417Parameters(aq nativeObject) throws MwBarcodeException {
        super(nativeObject);
    }

    public int getPdf417CompactionMode() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).a().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417CompactionMode(int value) throws MwBarcodeException {
        try {
            for (Pdf417CompactionMode pdf417CompactionMode : Pdf417CompactionMode.values()) {
                if (pdf417CompactionMode.getValue() != value) continue;
                ((aq)this.getNativeObject()).a(pdf417CompactionMode);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417ErrorLevel() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).b().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417ErrorLevel(int value) throws MwBarcodeException {
        try {
            for (Pdf417ErrorLevel pdf417ErrorLevel : Pdf417ErrorLevel.values()) {
                if (pdf417ErrorLevel.getValue() != value) continue;
                ((aq)this.getNativeObject()).a(pdf417ErrorLevel);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public boolean getPdf417Truncate() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).c();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417Truncate(boolean value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getColumns() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).d();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setColumns(int value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getRows() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).e();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setRows(int value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).b(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public float getAspectRatio() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).f();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setAspectRatio(float value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417MacroFileID() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).g();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroFileID(int value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).c(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417MacroSegmentID() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).h();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroSegmentID(int value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).d(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417MacroSegmentsCount() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).i();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroSegmentsCount(int value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).e(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getPdf417MacroFileName() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).j();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroFileName(String value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getPdf417MacroTimeStamp() throws MwBarcodeException {
        try {
            long l2 = ((aq)this.getNativeObject()).k().getTime() / 1000L < 0L ? 0L : ((aq)this.getNativeObject()).k().getTime() / 1000L;
            return String.valueOf(l2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroTimeStamp(String value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).a(new Date(Long.parseLong(value) * 1000L));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getPdf417MacroSender() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).l();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroSender(String value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).b(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getPdf417MacroAddressee() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).m();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroAddressee(String value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).c(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417MacroFileSize() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).n();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroFileSize(int value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).f(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417MacroChecksum() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).o();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroChecksum(int value) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).g(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getCodeTextEncoding() throws MwBarcodeException {
        try {
            return ((aq)this.getNativeObject()).p().displayName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setCodeTextEncoding(String codeTextEncoding) throws MwBarcodeException {
        try {
            ((aq)this.getNativeObject()).a(Charset.forName(codeTextEncoding));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417ECIEncoding() {
        return ((aq)this.getNativeObject()).q();
    }

    public void setPdf417ECIEncoding(int value) {
        ((aq)this.getNativeObject()).h(value);
    }

    public int getPdf417MacroECIEncoding() {
        return ((aq)this.getNativeObject()).r();
    }

    public void setPdf417MacroECIEncoding(int value) {
        ((aq)this.getNativeObject()).i(value);
    }

    public int getPdf417MacroTerminator() {
        return ((aq)this.getNativeObject()).s().getValue();
    }

    public void setPdf417MacroTerminator(int value) {
        ((aq)this.getNativeObject()).a(Pdf417MacroTerminator.values()[value]);
    }

    public boolean isReaderInitialization() {
        return ((aq)this.getNativeObject()).t();
    }

    public void setReaderInitialization(boolean value) {
        ((aq)this.getNativeObject()).b(value);
    }

    public int getCode128Emulation() {
        return ((aq)this.getNativeObject()).u().getValue();
    }

    public void setCode128Emulation(int value) {
        ((aq)this.getNativeObject()).a(Code128Emulation.valueOf(value));
    }

    public String toString() {
        return ((aq)this.getNativeObject()).toString();
    }

    @Override
    protected void init() {
    }
}

