from cpanlp.accounting.income.revenue import *
from cpanlp.market.commodity import *

class Market:
    """
    #### The Market class represents a market where a specific commodity is bought and sold.
    Attributes:
    - commodity (Commodity): The Commodity object that represents the commodity being traded in the market.
    - participants (list): A list of Participant objects representing the participants in the market.
    - transaction_costs (float): The transaction costs associated with trading in the market.
    - free_entry (bool): A flag indicating whether there are any barriers to entry in the market.
    - number_of_participants (int): The number of participants in the market.
    
    Methods:
    - calculate_revenue: Calculates the revenue generated by the market.
    - calculate_profit: Calculates the profit generated by the market.
    """
    def __init__(self, commodity, participants):
        """
        Initializes the Market object.
        
        Args:
        commodity (Commodity): The Commodity object that represents the commodity being traded in the market.
        participants (list): A list of Participant objects representing the participants in the market.
        """
        self.commodity = commodity
        self.participants = participants
        self.transaction_costs = None
        self.free_entry = None
        self.number_of_participants = len(participants)