from cpanlp.accounting.assets.asset import *
import pandas as pd
class InvestmentProperty(Asset):
    """
    #### This class represents an investment property.An investment property is real estate purchased to generate income (i.e., earn a return on the investment) through rental income or appreciation. 

    Attributes:
    - account (str): the account associated with the investment property.
    - debit (float): the value of the investment property.
    - date (str): the date of investment property recognition.
    - tenant (str): the tenant name.
    - address (str): the address of the investment property.
    - income (float): the income generated by the investment property.

    Methods:
        None
    
    Example:
        property1 = InvestmentProperty("Building", 1000000, "2022-01-01", "ABC Inc.", "123 Main St", 100000)
        print(InvestmentProperty.sum())
    """
    accounts = []
    def __init__(self, account, debit, date,tenant,address,income):
        super().__init__(account, debit, date)
        self.address = address
        self.income = income
        self.tenant = tenant
        InvestmentProperty.accounts.append(self)
    @classmethod
    def sum(cls):
        data = [[asset.account, asset.date, asset.debit] for asset in InvestmentProperty.accounts]
        df = pd.DataFrame(data, columns=['账户类别', '日期', '借方金额'])
        return df
    
        